/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.ui.components;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.Response;
import org.chorem.pollen.ui.base.ContextLink;
import org.slf4j.Logger;

/**
 * Composant générant une balise d'entête Link à partir d'un fichier dynamique.
 *
 * <pre>
 * Utilisation :
 * &lt;t:headlink rel=&quot;alternate&quot; href=&quot;${feedFilename}&quot; type=&quot;application/atom+xml&quot; title=&quot;Pollen ATOM Feed&quot; /&gt;
 * </pre>
 *
 * @author rannou
 * @version $Id: HeadLink.java 2791 2009-11-05 13:58:23Z echatellier $
 */
public class HeadLink {

    /** Chemin du fichier */
    @Parameter(required = true)
    private ContextLink _context;

    @Parameter(required = true, defaultPrefix = BindingConstants.LITERAL)
    private String _href;

    @Parameter(required = true, defaultPrefix = BindingConstants.LITERAL)
    private String _rel;

    @Parameter(required = true, defaultPrefix = BindingConstants.LITERAL)
    private String _type;

    @Parameter
    private String _title;

    @Inject
    private Logger logger;

    @Inject
    private ComponentResources _resources;

    void beginRender(MarkupWriter writer) {
        Link link = _resources.createEventLink("fileLink", _href, _type);
        writer.element("link", "href", link, "rel", _rel, "type", _type,
                "title", _title);

        _resources.renderInformalParameters(writer);
    }

    void afterRender(MarkupWriter writer) {
        writer.end();
    }

    /** Affichage du fichier */
    public StreamResponse onFileLink(final String href, final String type) {
        
        // security : src containing .. are filtered, to not access to full system
        if (StringUtils.isEmpty(href) || href.contains("..")) {
            return null;
        }

        File file = _context.getFile(href);
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
        } catch (FileNotFoundException e) {
            logger.error("Fichier inexistant : " + file.getAbsolutePath(), e);
        }

        return new FileStreamResponse(stream, type);
    }

    /** Création du flux du fichier */
    class FileStreamResponse implements StreamResponse {
        protected String contentType;
        protected InputStream stream;

        public FileStreamResponse(InputStream stream, String contentType) {
            this.stream = stream;
            this.contentType = contentType;
        }

        public String getContentType() {
            return contentType;
        }

        public InputStream getStream() throws IOException {
            return stream;
        }

        public void prepareResponse(Response arg0) {

        }
    }
}