/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.ui.utils;

/**
 * Classe permettant de convertir des nombres.
 *
 * @author rannou
 * @version $Id: UnitConverter.java 2680 2009-07-30 14:56:36Z nrannou $
 */
public class UnitConverter {

    /**
     * Conversion d'une taille en octets en Ko, Mo, Go, To.
     *
     * @param size taille en octets
     * @return chaîne représentant la taille dans l'unité la plus adaptée
     */
    public static String getFormattedFileSize(long size) {
        String[] suffixes = new String[] { "octets", "Ko", "Mo", "Go", "To" };

        double tmpSize = size;
        int i = 0;

        while (tmpSize >= 1024) {
            tmpSize /= 1024.0;
            i++;
        }

        // arrondi à 10^-2
        tmpSize *= 100;
        tmpSize = (int) (tmpSize + 0.5);
        tmpSize /= 100;

        return tmpSize + " " + suffixes[i];
    }
}
