/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.poll.vote;

import com.opensymphony.xwork2.Preparable;
import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.bean.PollImageChoice;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.common.ChoiceType;
import org.chorem.pollen.services.PollenServiceFunctions;
import org.chorem.pollen.services.exceptions.PollNotFoundException;
import org.chorem.pollen.ui.actions.FileUploadAware;
import org.chorem.pollen.ui.actions.poll.vote.AbstractVoteAction;

public class AddChoice
extends AbstractVoteAction
implements Preparable,
FileUploadAware {
    private static final long serialVersionUID = 1L;
    protected Choice choice;
    private File imageChoice;
    private String imageChoiceFileName;

    public Choice getChoice() {
        return this.choice;
    }

    public void addFile(int index, File file) {
        this.imageChoice = file;
    }

    public void addFileContentType(int index, String contentType) {
    }

    public void addFileName(int index, String fileName) {
        this.imageChoiceFileName = fileName;
    }

    public boolean isModerate() {
        return false;
    }

    public void prepare() throws PollNotFoundException {
        this.loadPoll();
        ChoiceType choiceType = this.getPoll().getChoiceType();
        this.choice = this.getPollService().getNewChoice(choiceType);
        if (ChoiceType.IMAGE == choiceType && this.imageChoice != null) {
            String fileName = this.imageChoiceFileName;
            String location = this.imageChoice.getAbsolutePath();
            this.choice.setName(fileName);
            ((PollImageChoice)this.choice).setLocation(location);
        }
    }

    public void validate() {
        Poll poll = this.getPoll();
        ChoiceType choiceType = poll.getChoiceType();
        String propName = (String)PollenServiceFunctions.CHOICE_TYPE_TO_PROPERTY_NAME.apply((Object)choiceType);
        String choiceName = this.choice.getName();
        if (StringUtils.isBlank((CharSequence)choiceName)) {
            String typeLabel = this.getText(choiceType.getI18nKey());
            this.addFieldError("choice." + propName, this._("pollen.error.choice.empty", new Object[]{typeLabel}));
        } else if (!poll.isChoiceEmpty()) {
            for (Choice pollChoice : poll.getChoice()) {
                String pollChoiceName = pollChoice.getName();
                if (!pollChoiceName.equals(choiceName)) continue;
                this.addFieldError("choice." + propName, this._("pollen.error.poll.choice.already.used.name", new Object[0]));
                break;
            }
        }
    }

    @InputConfig(methodName="prepareVotePage")
    public String execute() throws Exception {
        this.getPollService().addChoice(this.getPollUri().getPollId(), this.choice);
        return "success";
    }
}

