/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.callao.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.callao.entity.CallaoDAOHelper;
import org.chorem.callao.entity.Journal;
import org.chorem.callao.entity.JournalDAO;
import org.chorem.callao.entity.Transaction;
import org.chorem.callao.entity.TransactionDAO;
import org.chorem.callao.service.convertObject.ConvertJournal;
import org.chorem.callao.service.dto.JournalDTO;
import org.chorem.callao.service.utils.ContextCallao;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;

public class JournalServiceImpl {
    private static final Log log = LogFactory.getLog(JournalServiceImpl.class);
    private TopiaContext rootContext = ContextCallao.getInstance().getContext();
    private ConvertJournal convertJournal = new ConvertJournal();

    public String createJournal(String label, String prefix, String description) {
        String result = "error";
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            JournalDAO journalDAO = CallaoDAOHelper.getJournalDAO((TopiaContext)topiaContext);
            Journal journal = this.searchJournalWithLabel(label);
            if (journal != null) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Un journal avec le label " + label + " existe d\u00e9j\u00e0 !"));
                }
                result = "journal_double";
            } else {
                Journal newJournal = (Journal)journalDAO.create(new Object[0]);
                newJournal.setLabel(label);
                newJournal.setPrefix(prefix);
                newJournal.setDescription(description);
                topiaContext.commitTransaction();
                result = "success";
            }
            topiaContext.closeContext();
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return result;
    }

    public String createJournal(JournalDTO journalDTO) {
        String result = this.createJournal(journalDTO.getLabel(), journalDTO.getPrefix(), journalDTO.getDescription());
        return result;
    }

    public List<JournalDTO> getAllJournal() {
        ArrayList<JournalDTO> listJournalDTO = new ArrayList<JournalDTO>();
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            JournalDAO journalDAO = CallaoDAOHelper.getJournalDAO((TopiaContext)topiaContext);
            List listJournal = journalDAO.findAll();
            for (Journal journal : listJournal) {
                JournalDTO journalDTO = this.convertJournal.journalEntityToDto(journal);
                listJournalDTO.add(journalDTO);
            }
            topiaContext.closeContext();
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return listJournalDTO;
    }

    public Journal searchJournalWithLabel(String label) {
        Journal journalResult = null;
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            JournalDAO journalDAO = CallaoDAOHelper.getJournalDAO((TopiaContext)topiaContext);
            journalResult = journalDAO.findByLabel(label);
            topiaContext.closeContext();
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return journalResult;
    }

    public JournalDTO searchJournalDTOWithLabel(String label) {
        Journal journal = this.searchJournalWithLabel(label);
        JournalDTO journalDTO = this.convertJournal.journalEntityToDto(journal);
        return journalDTO;
    }

    public Journal searchJournalWithTopiaId(String topiaId) {
        Journal journalResult = null;
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            JournalDAO journalDAO = CallaoDAOHelper.getJournalDAO((TopiaContext)topiaContext);
            journalResult = (Journal)journalDAO.findByTopiaId(topiaId);
            topiaContext.closeContext();
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return journalResult;
    }

    public JournalDTO searchJournalDTOWithTopiaId(String topiaId) {
        Journal journal = this.searchJournalWithTopiaId(topiaId);
        JournalDTO journalDTO = this.convertJournal.journalEntityToDto(journal);
        return journalDTO;
    }

    public String modifyJournal(String topiaId, String label, String prefix, String description) {
        String result = "error";
        Journal journalModify = this.searchJournalWithTopiaId(topiaId);
        if (journalModify == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Le journal " + label + " n'existe pas !"));
            }
            result = "journal_not_exist";
        } else {
            try {
                TopiaContext topiaContext = this.rootContext.beginTransaction();
                JournalDAO journalDAO = CallaoDAOHelper.getJournalDAO((TopiaContext)topiaContext);
                journalModify.setPrefix(prefix);
                journalModify.setDescription(description);
                journalDAO.update((TopiaEntity)journalModify);
                topiaContext.commitTransaction();
                topiaContext.closeContext();
                result = "success";
            }
            catch (TopiaException e) {
                log.error((Object)e);
            }
        }
        return result;
    }

    public String removeJournal(String topiaId) {
        String result = "error";
        Journal journalDelete = this.searchJournalWithTopiaId(topiaId);
        if (journalDelete == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Le journal " + topiaId + " n'existe pas !"));
            }
            result = "journal_not_exist";
        } else {
            try {
                TopiaContext topiaContext = this.rootContext.beginTransaction();
                TransactionDAO transactionDAO = CallaoDAOHelper.getTransactionDAO((TopiaContext)topiaContext);
                Transaction transaction = transactionDAO.findByJournal(journalDelete);
                if (transaction != null) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Le journal " + topiaId + " poss\u00e8de des transactions comptables !"));
                    }
                    result = "journal_with_transactions";
                } else {
                    JournalDAO journalDAO = CallaoDAOHelper.getJournalDAO((TopiaContext)topiaContext);
                    journalDAO.delete(journalDelete);
                    topiaContext.commitTransaction();
                    topiaContext.closeContext();
                    result = "success";
                }
            }
            catch (TopiaException e) {
                log.error((Object)e);
            }
        }
        return result;
    }

    public String removeJournal(JournalDTO journalDTO) {
        String result = this.removeJournal(journalDTO.getId());
        return result;
    }
}

