/**
 * *##% Callao TransactionDTO
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */

package org.chorem.callao.service.dto;

import java.util.Date;

/**
 * Classe DTO - représente une transaction comptable.
 *
 * @author Rémi Chapelet
 */
public class TransactionDTO  {

    private String id; // Identifiant Topia

    private Date entryDate;

    private String voucherRef;

    private String description;

    private TimeSpanDTO timeSpanDTO;

    private JournalDTO journalDTO;


    public TransactionDTO ()
    {
        this.id = "";
        this.entryDate = new Date();
        this.voucherRef = "";
        this.description = "";
    }

    public TransactionDTO (String id, Date entryDate,String voucherRef,String description)
    {
        // Initialisation pour les variables chaines de caractères / Null
        if (voucherRef == null ) {
            voucherRef = "";
        }
        if (description == null ) {
            description = "";
        }
        this.id = id;
        this.entryDate = entryDate;
        this.voucherRef = voucherRef;
        this.description = description;
        this.timeSpanDTO = null;
        this.journalDTO = null;
    }

    /**
     * @return the id
     */
    public String getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * @return the entryDate
     */
    public Date getEntryDate() {
        return entryDate;
    }

    /**
     * @param entryDate the entryDate to set
     */
    public void setEntryDate(Date entryDate) {
        this.entryDate = entryDate;
    }

    /**
     * @return the voucherRef
     */
    public String getVoucherRef() {
        return voucherRef;
    }

    /**
     * @param voucherRef the voucherRef to set
     */
    public void setVoucherRef(String voucherRef) {
        if (voucherRef == null ) {
            voucherRef = "";
        }
        this.voucherRef = voucherRef;
    }

    /**
     * @return the description
     */
    public String getDescription() {
        return description;
    }

    /**
     * @param description the description to set
     */
    public void setDescription(String description) {
        if (description == null ) {
            description = "";
        }
        this.description = description;
    }

    /**
     * @return the journalDTO
     */
    public JournalDTO getJournalDTO() {
        return journalDTO;
    }

    /**
     * @param journalDTO the journalDTO to set
     */
    public void setJournalDTO(JournalDTO journalDTO) {
        this.journalDTO = journalDTO;
    }

    /**
     * @return the timeSpanDTO
     */
    public TimeSpanDTO getTimeSpanDTO() {
        return timeSpanDTO;
    }

    /**
     * @param timeSpanDTO the timeSpanDTO to set
     */
    public void setTimeSpanDTO(TimeSpanDTO timeSpanDTO) {
        this.timeSpanDTO = timeSpanDTO;
    }

    

}