/**
 * *##% Callao EntryDTO
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */

package org.chorem.callao.service.dto;


/**
 * Classe DTO - représente un objet entry
 *
 * @author Rémi Chapelet
 */
public class EntryDTO  {

    private String id; // Identifiant Topia

    private String description;

    private String amount;

    private boolean debit;

    private String lettering;

    private String detail;

    private TransactionDTO transactionDTO;

    private AccountDTO accountDTO;


    public EntryDTO ()
    {
        this.id = "";
        this.description = "";
        this.amount = "";
        this.debit = false;
        this.lettering = "";
        this.detail = "";
        this.transactionDTO = null;
        this.accountDTO = null;
    }

    public EntryDTO (String id, String description,String amount,boolean debit,
            String lettering,String detail,TransactionDTO transactionDTO,AccountDTO accountDTO)
    {
        // Initialisation pour les variables chaines de caractères / Null
        if (description == null ) {
            description = "";
        }
        if (lettering == null ) {
            lettering = "";
        }
        if (detail == null ) {
            detail = "";
        }
        this.id = id;
        this.description = description;
        this.amount = amount;
        this.debit = debit;
        this.lettering = lettering;
        this.detail = detail;
        this.transactionDTO = transactionDTO;
        this.accountDTO = accountDTO;
    }

    /**
     * @return the id
     */
    public String getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * @return the description
     */
    public String getDescription() {
        return description;
    }

    /**
     * @param description the description to set
     */
    public void setDescription(String description) {
        if (description == null ) {
            description = "";
        }
        this.description = description;
    }

    /**
     * @return the amount
     */
    public String getAmount() {
        return amount;
    }

    /**
     * @param amount the amount to set
     */
    public void setAmount(String amount) {
        this.amount = amount;
    }

    /**
     * @return the debit
     */
    public boolean isDebit() {
        return debit;
    }

    /**
     * @param debit the debit to set
     */
    public void setDebit(boolean debit) {
        this.debit = debit;
    }

    /**
     * @return the lettering
     */
    public String getLettering() {
        return lettering;
    }

    /**
     * @param lettering the lettering to set
     */
    public void setLettering(String lettering) {
        if (lettering == null ) {
            lettering = "";
        }
        this.lettering = lettering;
    }

    /**
     * @return the detail
     */
    public String getDetail() {
        return detail;
    }

    /**
     * @param detail the detail to set
     */
    public void setDetail(String detail) {
        if (detail == null ) {
            detail = "";
        }
        this.detail = detail;
    }

    /**
     * @return the transactionDTO
     */
    public TransactionDTO getTransactionDTO() {
        return transactionDTO;
    }

    /**
     * @param transactionDTO the transactionDTO to set
     */
    public void setTransactionDTO(TransactionDTO transactionDTO) {
        this.transactionDTO = transactionDTO;
    }

    /**
     * @return the accountDTO
     */
    public AccountDTO getAccountDTO() {
        return accountDTO;
    }

    /**
     * @param accountDTO the accountDTO to set
     */
    public void setAccountDTO(AccountDTO accountDTO) {
        this.accountDTO = accountDTO;
    }


}