package org.chorem.callao.service;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.callao.entity.CallaoDAOHelper;
import org.chorem.callao.entity.Users;
import org.chorem.callao.entity.UsersDAO;
import org.chorem.callao.service.utils.ContextCallao;
import org.chorem.callao.service.utils.ServiceHelper;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;


/** @author Rémi Chapelet */
public class UserServiceImpl {

    /** log */
    private static final Log log = LogFactory.getLog(UserServiceImpl.class);

    private TopiaContext rootContext = ContextCallao.getInstance().getContext();
	
	public UserServiceImpl() {
        // TopiaContext chargement du context si il n existe pas.
	}

    /**
     * Ajoute un utilisateur
     * @param name nom de la personne
     */
    public String addUser(String name)
    {
        // Attention doublon utilisateur
        try {
            // Acces BDD
            TopiaContext topiaContext = rootContext.beginTransaction();
            // Chargement du DAO
            UsersDAO userdao = CallaoDAOHelper.getUsersDAO(topiaContext);
            // Création de l'user
			Users newuser = userdao.create();
            newuser.setMatcher(name);            
            // Création BDD
            topiaContext.commitTransaction();
			topiaContext.closeContext();
            if (log.isInfoEnabled()) {
                log.info("Add user : " + name);
            }
            return ServiceHelper.RESPOND_SUCCESS;
        }catch (TopiaException e) {
			log.error(e);
            return ServiceHelper.RESPOND_ERROR;
		}
    }

    public String findUser(String name)
    {
        try {
            // Acces BDD
            TopiaContext topiaContext = rootContext.beginTransaction();
            // Chargement du DAO
            UsersDAO userdao = CallaoDAOHelper.getUsersDAO(topiaContext);
            // Recherche du user
			Users newuser = userdao.findByMatcher(name);
            // Fermeture BDD
			topiaContext.closeContext();
            if ( newuser == null)
            {
                if (log.isInfoEnabled()) {
                    log.info("Not find : " + name);
                }
                return ServiceHelper.RESPOND_ERROR;
            }
            if (log.isInfoEnabled()) {
                log.info("Find user : " + name);
            }
            return ServiceHelper.RESPOND_SUCCESS;
        }catch (TopiaException e) {
			log.error(e);
            return ServiceHelper.RESPOND_ERROR;
		}
    }


}
