/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.db;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.filesys.FileInfo;
import org.alfresco.jlan.server.filesys.db.DBDeviceContext;
import org.alfresco.jlan.server.filesys.db.DBException;
import org.alfresco.jlan.server.filesys.db.DBInterface;
import org.alfresco.jlan.server.filesys.loader.DeleteFileRequest;
import org.alfresco.jlan.server.filesys.loader.FileRequest;
import org.alfresco.jlan.server.filesys.loader.FileRequestQueue;
import org.alfresco.jlan.server.filesys.loader.MultipleFileRequest;
import org.alfresco.jlan.server.filesys.loader.SingleFileRequest;
import org.alfresco.jlan.util.db.DBConnectionPool;
import org.alfresco.jlan.util.db.DBConnectionPoolListener;
import org.springframework.extensions.config.ConfigElement;

public abstract class JdbcDBInterface
implements DBInterface,
DBConnectionPoolListener {
    public static final String FileSysTable = "JLANFileSys";
    public static final String StreamsTable = "JLANStreams";
    public static final String RetentionTable = "JLANRetain";
    public static final String QueueTable = "JLANQueue";
    public static final String TransactQueueTable = "JLANTransQueue";
    public static final String DataTable = "JLANData";
    public static final String JarDataTable = "JLANJarData";
    public static final String ObjectIdTable = "JLANObjectIds";
    public static final String SymLinkTable = "JLANSymLinks";
    public static final int NumPoolConnections = 5;
    protected String m_specialChars = "'\"\\";
    public static final long DefaultFragSize = 524288L;
    public static final long MinFragSize = 65536L;
    public static final long MaxFragSize = 0x40000000L;
    protected DBDeviceContext m_dbCtx;
    private int m_features = this.getSupportedFeatures();
    private int m_reqFeatures;
    protected String m_driver;
    protected String m_dsn;
    protected String m_userName;
    protected String m_password;
    protected String m_structTable;
    protected String m_streamTable;
    protected String m_retentionTable;
    protected String m_queueTable;
    protected String m_transactTable;
    protected String m_dataTable;
    protected String m_jarDataTable;
    protected String m_objectIdTable;
    protected String m_symLinkTable;
    protected long m_retentionPeriod = -1L;
    protected DBConnectionPool m_connPool;
    protected int m_dbInitConns = 5;
    protected int m_dbMaxConns = 10;
    protected int m_onlineCheckInterval;
    protected long m_dataFragSize = 524288L;
    protected FileRequestQueue m_pendingSaveRequests;
    protected boolean m_debug;
    protected boolean m_sqlDebug;
    private String m_lockFile;
    private boolean m_crashRecovery;

    @Override
    public final boolean supportsFeature(int feature) {
        return (this.m_features & feature) != 0;
    }

    @Override
    public void requestFeatures(int featureMask) throws DBException {
        int supFeatures = this.getSupportedFeatures();
        if ((featureMask | supFeatures) != supFeatures) {
            throw new DBException("Unsupported feature requested");
        }
        this.m_reqFeatures = featureMask;
    }

    protected abstract int getSupportedFeatures();

    public final boolean hasCrashRecovery() {
        return this.m_crashRecovery;
    }

    public final boolean isRetentionEnabled() {
        return (this.m_reqFeatures & 2) != 0;
    }

    public final boolean isNTFSEnabled() {
        return (this.m_reqFeatures & 1) != 0;
    }

    public final boolean isQueueEnabled() {
        return (this.m_reqFeatures & 4) != 0;
    }

    public final boolean isDataEnabled() {
        return (this.m_reqFeatures & 8) != 0;
    }

    public final boolean isJarDataEnabled() {
        return (this.m_reqFeatures & 0x10) != 0;
    }

    public final boolean isObjectIdEnabled() {
        return (this.m_reqFeatures & 0x20) != 0;
    }

    public final boolean isSymbolicLinksEnabled() {
        return (this.m_reqFeatures & 0x40) != 0;
    }

    protected final String getLockFile() {
        return this.m_lockFile;
    }

    protected final void setLockFile(String lockFile) {
        this.m_lockFile = lockFile;
    }

    protected final long setDataFragmentSize(long fragSize) {
        if (fragSize >= 65536L && fragSize <= 0x40000000L) {
            this.m_dataFragSize = fragSize;
        }
        return this.m_dataFragSize;
    }

    @Override
    public void initializeDatabase(DBDeviceContext context, ConfigElement params) throws InvalidConfigurationException {
        this.m_dbCtx = context;
        ConfigElement nameVal = null;
        nameVal = params.getChild("DSN");
        if (nameVal != null) {
            this.m_dsn = nameVal.getValue();
        }
        if ((nameVal = params.getChild("Username")) != null) {
            this.m_userName = nameVal.getValue();
        }
        if ((nameVal = params.getChild("Password")) != null) {
            this.m_password = nameVal.getValue();
        }
        this.m_structTable = (nameVal = params.getChild("FileSystemTable")) != null ? nameVal.getValue() : FileSysTable;
        nameVal = params.getChild("StreamsTable");
        this.m_streamTable = nameVal != null ? nameVal.getValue() : StreamsTable;
        nameVal = params.getChild("RetentionTable");
        this.m_retentionTable = nameVal != null ? nameVal.getValue() : RetentionTable;
        nameVal = params.getChild("QueueTable");
        this.m_queueTable = nameVal != null ? nameVal.getValue() : QueueTable;
        nameVal = params.getChild("TransactQueueTable");
        this.m_transactTable = nameVal != null ? nameVal.getValue() : TransactQueueTable;
        nameVal = params.getChild("DataTable");
        this.m_dataTable = nameVal != null ? nameVal.getValue() : DataTable;
        nameVal = params.getChild("JarDataTable");
        this.m_jarDataTable = nameVal != null ? nameVal.getValue() : JarDataTable;
        nameVal = params.getChild("ObjectIdTable");
        this.m_objectIdTable = nameVal != null ? nameVal.getValue() : ObjectIdTable;
        nameVal = params.getChild("SymLinksTable");
        this.m_symLinkTable = nameVal != null ? nameVal.getValue() : SymLinkTable;
        nameVal = params.getChild("ConnectionPool");
        if (nameVal != null) {
            try {
                String numVal = nameVal.getValue();
                int pos = numVal.indexOf(58);
                if (pos == -1) {
                    this.m_dbMaxConns = Integer.parseInt(numVal);
                } else {
                    String val = numVal.substring(0, pos);
                    this.m_dbInitConns = Integer.parseInt(val);
                    val = numVal.substring(pos + 1);
                    this.m_dbMaxConns = Integer.parseInt(val);
                }
                if (this.m_dbInitConns < 5 || this.m_dbInitConns > this.m_dbMaxConns) {
                    throw new InvalidConfigurationException("Database interface invalid initial connections value");
                }
                if (this.m_dbMaxConns > 500 || this.m_dbMaxConns < this.m_dbInitConns) {
                    throw new InvalidConfigurationException("Database interface invalid maximum connections value");
                }
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Database interface invalid ConnectionPool value, " + ex.toString());
            }
        }
        if ((nameVal = params.getChild("OnlineCheckInterval")) != null) {
            try {
                this.m_onlineCheckInterval = Integer.parseInt(nameVal.getValue());
                if (this.m_onlineCheckInterval < 1 || this.m_onlineCheckInterval > 30) {
                    throw new InvalidConfigurationException("Database online check interval out of valid range (1-30");
                }
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Database online check interval value invalid, " + nameVal.getValue());
            }
        }
        if (params.getChild("Debug") != null) {
            this.m_debug = true;
        }
        if (params.getChild("SQLDebug") != null) {
            this.m_sqlDebug = true;
        }
        this.m_retentionPeriod = context.getRetentionPeriod();
        if (params.getChild("useCrashRecovery") != null) {
            this.m_crashRecovery = true;
        }
    }

    @Override
    public boolean isOnline() {
        if (this.m_connPool != null) {
            if (this.m_connPool.isOnline()) {
                return true;
            }
            Connection conn = this.m_connPool.getConnection();
            if (conn != null) {
                this.m_connPool.releaseConnection(conn);
            }
            return this.m_connPool.isOnline();
        }
        return false;
    }

    @Override
    public void shutdownDatabase(DBDeviceContext context) {
        if (this.m_connPool != null) {
            this.m_connPool.closePool();
        }
    }

    protected final Connection getConnection() throws SQLException {
        Connection conn = this.m_connPool.getConnection();
        if (conn == null) {
            throw new SQLException("Failed to get database connection");
        }
        return conn;
    }

    protected final Connection getConnection(long leaseTime) throws SQLException {
        Connection conn = this.m_connPool.getConnection(leaseTime);
        if (conn == null) {
            throw new SQLException("Failed to get database connection");
        }
        return conn;
    }

    protected final void releaseConnection(Connection conn) {
        this.m_connPool.releaseConnection(conn);
    }

    protected final DBConnectionPool getConnectionPool() {
        return this.m_connPool;
    }

    protected final String getDriverName() {
        return this.m_driver;
    }

    protected final String getDSNString() {
        return this.m_dsn;
    }

    protected final String getUserName() {
        return this.m_userName;
    }

    protected final String getPassword() {
        return this.m_password;
    }

    protected final String getFileSysTableName() {
        return this.m_structTable;
    }

    protected final boolean hasStreamsTableName() {
        return this.m_streamTable != null;
    }

    protected final String getStreamsTableName() {
        return this.m_streamTable;
    }

    protected final boolean hasRetentionTableName() {
        return this.m_retentionTable != null;
    }

    protected final String getRetentionTableName() {
        return this.m_retentionTable;
    }

    protected final boolean hasRetentionPeriod() {
        return this.m_retentionPeriod != -1L;
    }

    protected final long getRetentionPeriod() {
        return this.m_retentionPeriod;
    }

    protected final boolean hasDataTableName() {
        return this.m_dataTable != null;
    }

    protected final String getDataTableName() {
        return this.m_dataTable;
    }

    protected final boolean hasJarDataTableName() {
        return this.m_jarDataTable != null;
    }

    protected final String getJarDataTableName() {
        return this.m_jarDataTable;
    }

    protected final boolean hasQueueTableName() {
        return this.m_queueTable != null;
    }

    protected final String getQueueTableName() {
        return this.m_queueTable;
    }

    protected final boolean hasTransactionTableName() {
        return this.m_transactTable != null;
    }

    protected final String getTransactionTableName() {
        return this.m_transactTable;
    }

    protected final boolean hasObjectIdTableName() {
        return this.m_objectIdTable != null;
    }

    protected final String getObjectIdTableName() {
        return this.m_objectIdTable;
    }

    protected final boolean hasSymLinksTableName() {
        return this.m_symLinkTable != null;
    }

    protected final String getSymLinksTableName() {
        return this.m_symLinkTable;
    }

    protected final long getDataFragmentSize() {
        return this.m_dataFragSize;
    }

    protected final boolean hasDebug() {
        return this.m_debug;
    }

    protected final boolean hasSQLDebug() {
        return this.m_sqlDebug;
    }

    protected final void setDSNString(String dsn) {
        this.m_dsn = dsn;
    }

    protected final void setDriverName(String driverClass) {
        this.m_driver = driverClass;
    }

    protected String checkNameForSpecialChars(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        int idx = 0;
        boolean specChars = false;
        while (idx < this.m_specialChars.length() && !specChars) {
            if (name.indexOf(this.m_specialChars.charAt(idx++)) == -1) continue;
            specChars = true;
        }
        if (!specChars) {
            return name;
        }
        StringBuffer nameBuf = new StringBuffer(name.length() * 2);
        for (int i = 0; i < name.length(); ++i) {
            char curChar = name.charAt(i);
            if (this.m_specialChars.indexOf(curChar) != -1) {
                nameBuf.append("\\");
            }
            nameBuf.append(curChar);
        }
        return nameBuf.toString();
    }

    protected final void createConnectionPool() throws Exception {
        this.m_connPool = new DBConnectionPool(this.m_driver, this.m_dsn, this.m_userName, this.m_password, this.m_dbInitConns, this.m_dbMaxConns);
        if (this.m_onlineCheckInterval != 0) {
            this.m_connPool.setOnlineCheckInterval(this.m_onlineCheckInterval * 60);
        }
        this.m_connPool.addConnectionPoolListener(this);
    }

    public void deleteFileRequest(FileRequest fileReq) throws DBException {
        throw new DBException("Feature not implemented");
    }

    protected final synchronized void queueOfflineSaveRequest(FileRequest saveReq) {
        if (this.m_pendingSaveRequests == null) {
            this.m_pendingSaveRequests = new FileRequestQueue();
        }
        if (this.hasDebug()) {
            Debug.println("JDBCInterface: Queueing save request " + saveReq);
        }
        this.m_pendingSaveRequests.addRequest(saveReq);
    }

    @Override
    public void databaseOnlineStatus(boolean dbonline) {
        if (this.hasDebug()) {
            Debug.println("JDBCInterface: Database connection event, status=" + (dbonline ? "OnLine" : "OffLine"));
        }
        this.m_dbCtx.setAvailable(dbonline);
        if (dbonline) {
            if (this.m_dbCtx.hasOfflineFileDeletes()) {
                FileRequestQueue deleteList = this.m_dbCtx.getOfflineFileDeletes(true);
                for (int i = 0; i < deleteList.numberOfRequests(); ++i) {
                    DeleteFileRequest deleteReq = (DeleteFileRequest)deleteList.removeRequestNoWait();
                    try {
                        if (deleteReq.getStreamId() == 0) {
                            this.deleteFileRecord(-1, deleteReq.getFileId(), this.m_dbCtx.isTrashCanEnabled());
                        } else {
                            this.deleteStreamRecord(deleteReq.getFileId(), deleteReq.getStreamId(), this.m_dbCtx.isTrashCanEnabled());
                        }
                        this.m_dbCtx.getStateCache().removeFileState(deleteReq.getFileState().getPath());
                        if (!this.hasDebug()) continue;
                        Debug.println("JDBCInterface: Offline delete of file " + deleteReq.getVirtualPath() + ", fid=" + deleteReq.getFileId());
                        continue;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
            if (this.m_pendingSaveRequests != null) {
                FileRequestQueue saveReqQueue = this.m_pendingSaveRequests;
                this.m_pendingSaveRequests = null;
                if (this.hasDebug()) {
                    Debug.println("JDBCInterface: Requeueing pending save requests, count=" + saveReqQueue.numberOfRequests());
                }
                FileRequest fileReq = null;
                while (saveReqQueue.numberOfRequests() > 0) {
                    try {
                        SingleFileRequest singleReq;
                        fileReq = saveReqQueue.removeRequestNoWait();
                        this.queueFileRequest(fileReq);
                        if (this.hasDebug()) {
                            Debug.println("JDBCInterface: Requeued save " + fileReq);
                        }
                        if (!(fileReq instanceof SingleFileRequest) || !(singleReq = (SingleFileRequest)fileReq).hasFileState()) continue;
                        File tempFile = new File(singleReq.getTemporaryFile());
                        FileInfo fInfo = new FileInfo("", 0L, 0);
                        fInfo.setFileInformationFlags(1);
                        fInfo.setFileId(singleReq.getFileId());
                        fInfo.setFileSize(tempFile.length());
                        this.setFileInformation(-1, singleReq.getFileId(), fInfo);
                        if (!this.hasDebug()) continue;
                        Debug.println("JDBCInterface: Updated file size for " + singleReq.getVirtualPath() + " size=" + tempFile.length());
                    }
                    catch (DBException ex) {}
                }
            }
        }
    }

    public final boolean hasOfflineFileRequests() {
        return this.m_pendingSaveRequests != null && this.m_pendingSaveRequests.numberOfRequests() > 0;
    }

    public boolean hasQueuedRequest(String tempFile) throws DBException {
        throw new DBException("Feature not implemented");
    }

    public int loadFileRequests(int seqNo, int reqType, FileRequestQueue reqQueue, int recLimit) throws DBException {
        throw new DBException("Feature not implemented");
    }

    public void queueFileRequest(FileRequest fileReq) throws DBException {
        throw new DBException("Feature not implemented");
    }

    public void queueTransactionRequest(FileRequest fileReq) throws DBException {
        throw new DBException("Feature not implemented");
    }

    public MultipleFileRequest loadTransactionRequest(MultipleFileRequest tranReq) throws DBException {
        throw new DBException("Feature not implemented");
    }
}

