/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.netbios.win32;

import org.alfresco.jlan.netbios.win32.NetBIOSSelector;
import org.alfresco.jlan.netbios.win32.NetBIOSSocket;

public class NetBIOSSelectionKey {
    public static final int OP_ACCEPT = 1;
    public static final int OP_CONNECT = 2;
    public static final int OP_READ = 4;
    public static final int OP_WRITE = 8;
    private boolean m_valid;
    private int m_interestOps;
    private int m_triggerOps;
    private NetBIOSSelector m_selector;
    private NetBIOSSocket m_socket;
    private Object m_attachment;

    protected NetBIOSSelectionKey(NetBIOSSelector selector, NetBIOSSocket socket, int ops, Object attachment) {
        this.m_selector = selector;
        this.m_socket = socket;
        this.m_attachment = attachment;
        this.m_interestOps = ops;
        this.m_valid = true;
    }

    public final void attach(Object obj) {
        this.m_attachment = obj;
    }

    public final Object attachment() {
        return this.m_attachment;
    }

    public final boolean isAcceptable() {
        return this.hasTrigger(1);
    }

    public final boolean isReadable() {
        return this.hasTrigger(4);
    }

    public final boolean isWritable() {
        return this.hasTrigger(4);
    }

    public final boolean isConnectable() {
        return this.hasTrigger(2);
    }

    public final int interestOps() {
        return this.m_interestOps;
    }

    public final void interestOps(int ops) {
        this.m_interestOps = ops;
    }

    public final int readyOps() {
        return this.m_triggerOps;
    }

    public final boolean isValid() {
        return this.m_valid;
    }

    private final boolean hasTrigger(int flag) {
        return (this.m_triggerOps & flag) != 0;
    }

    protected final void setTriggers(int ops) {
        this.m_triggerOps = ops;
    }

    public final NetBIOSSelector selector() {
        return this.m_selector;
    }

    protected final void setValid(boolean valid) {
        this.m_valid = valid;
    }

    public final NetBIOSSocket socket() {
        return this.m_socket;
    }

    public int hashcode() {
        return this.m_socket.getSocket();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[Socket=");
        str.append(this.socket());
        str.append(",Ops=0x");
        str.append(Integer.toHexString(this.interestOps()));
        str.append("/0x");
        str.append(Integer.toHexString(this.readyOps()));
        str.append(",Attachment=");
        str.append(this.attachment());
        if (!this.isValid()) {
            str.append(",Invalid");
        }
        str.append("]");
        return str.toString();
    }
}

