/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table;

import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.ui.content.ContentUIInitializer;
import fr.ird.observe.ui.content.table.ContentTableModel;
import fr.ird.observe.ui.content.table.ContentTableUIHandler;
import fr.ird.observe.ui.content.table.ContentTableUIModel;
import fr.ird.observe.ui.content.table.ObserveContentTableUI;
import fr.ird.observe.ui.util.BooleanEditor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.nuiton.jaxx.application.bean.JavaBeanObjectUtil;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public class ContentTableUIInitializer<E extends TopiaEntity, D extends TopiaEntity, UI extends ObserveContentTableUI<E, D>>
extends ContentUIInitializer<E, UI> {
    public static final String CLIENT_PROPERTY_TABLE_PROPERTY_NAME = "tablePropertyName";
    public static final String CLIENT_PROPERTY_RESET_TABLE_PROPERTY_NAME = "resetTablePropertyName";
    private static final Log log = LogFactory.getLog(ContentTableUIInitializer.class);

    public ContentTableUIInitializer(UI ui) {
        super(ui);
    }

    protected D getTableEditBean() {
        return this.getModel().getTableEditBean();
    }

    protected ContentTableUIModel<E, D> getModel() {
        return ((ObserveContentTableUI)this.ui).getModel();
    }

    protected ContentTableUIHandler<E, D> getHandler() {
        return ((ObserveContentTableUI)this.ui).getHandler();
    }

    @Override
    public void initUI(DataSource dataSource) throws Exception {
        ContentTableUIInitializer.attachTopiaContext(dataSource, (TopiaEntityAbstract)this.getTableEditBean());
        super.initUI(dataSource);
        ContentTableModel tableModel = ((ObserveContentTableUI)this.ui).getTableModel();
        ((ObserveContentTableUI)this.ui).setContextValue(tableModel);
        if (((ObserveContentTableUI)this.ui).getBody() != null) {
            SwingUtil.setLayerUI((JComponent)((ObserveContentTableUI)this.ui).getBody(), null);
        }
        if (((ObserveContentTableUI)this.ui).getExtraZone() != null) {
            SwingUtil.setLayerUI((JComponent)((ObserveContentTableUI)this.ui).getExtraZone(), (LayerUI)((ObserveContentTableUI)this.ui).getBlockLayerUI());
        }
        SwingUtil.setLayerUI((JComponent)((ObserveContentTableUI)this.ui).getEditor(), (LayerUI)((ObserveContentTableUI)this.ui).getEditorBlockLayerUI());
        this.getHandler().initTableUI(new DefaultTableCellRenderer());
        tableModel.addPropertyChangeListener("selectedRow", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ContentTableModel model = (ContentTableModel)evt.getSource();
                Object bean = model.getRowBean();
                boolean create = bean.getTopiaId() == null;
                Integer selectedRow = (Integer)evt.getNewValue();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("callback new selectedRow : " + selectedRow + " : " + bean.getTopiaId()));
                }
                ContentTableUIInitializer.this.getHandler().onSelectedRowChanged(selectedRow, bean, create);
                ContentTableUIInitializer.this.getModel().setRowSaved(!create);
                if (selectedRow == -1) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)">>>>>>>>>> will clear selection...");
                    }
                    ((ObserveContentTableUI)ContentTableUIInitializer.this.ui).getSelectionModel().clearSelection();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"<<<<<<<<<< has clear selection...");
                    }
                } else {
                    ((ObserveContentTableUI)ContentTableUIInitializer.this.ui).getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
                }
            }
        });
        this.getModel().addPropertyChangeListener("showData", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean newValue = (Boolean)evt.getNewValue();
                ContentTableUIInitializer.this.onShowDataChanged(newValue);
            }
        });
    }

    protected void onShowDataChanged(Boolean showData) {
        JComponent body = ((ObserveContentTableUI)this.ui).getBody();
        if (showData != null && showData.booleanValue()) {
            body.remove(((ObserveContentTableUI)this.ui).getHideForm());
            body.add((Component)((ObserveContentTableUI)this.ui).getShowForm(), "Center");
        } else {
            body.remove(((ObserveContentTableUI)this.ui).getShowForm());
            body.add((Component)((ObserveContentTableUI)this.ui).getHideForm(), "Center");
        }
    }

    @Override
    protected void init(ActionMap actionMap, AbstractButton editor) throws DataSourceException {
        String propertyName;
        super.init(actionMap, editor);
        String actionId = (String)editor.getClientProperty("observeAction");
        if (actionId == null && (propertyName = (String)editor.getClientProperty(CLIENT_PROPERTY_RESET_TABLE_PROPERTY_NAME)) != null) {
            editor.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JavaBeanObjectUtil.setProperty(ContentTableUIInitializer.this.getTableEditBean(), (String)propertyName, null);
                }
            });
        }
    }

    @Override
    protected void init(JTextField editor) {
        super.init(editor);
        final String propertyName = (String)editor.getClientProperty(CLIENT_PROPERTY_TABLE_PROPERTY_NAME);
        if (propertyName != null) {
            editor.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    JTextField source = (JTextField)e.getSource();
                    String text = source.getText();
                    JavaBeanObjectUtil.setProperty(ContentTableUIInitializer.this.getTableEditBean(), (String)propertyName, (Object)text);
                }
            });
        }
    }

    @Override
    protected void init(JTextArea editor) {
        super.init(editor);
        final String propertyName = (String)editor.getClientProperty(CLIENT_PROPERTY_TABLE_PROPERTY_NAME);
        if (propertyName != null) {
            editor.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    JTextArea source = (JTextArea)e.getSource();
                    String text = source.getText();
                    JavaBeanObjectUtil.setProperty(ContentTableUIInitializer.this.getTableEditBean(), (String)propertyName, (Object)text);
                }
            });
        }
    }

    @Override
    protected void init(JCheckBox editor) throws DataSourceException {
        super.init(editor);
        final String propertyName = (String)editor.getClientProperty(CLIENT_PROPERTY_TABLE_PROPERTY_NAME);
        if (propertyName != null) {
            editor.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent event) {
                    Boolean newValue = ((JCheckBox)event.getSource()).isSelected();
                    JavaBeanObjectUtil.setProperty(ContentTableUIInitializer.this.getTableEditBean(), (String)propertyName, (Object)newValue);
                }
            });
        }
    }

    @Override
    protected void init(BooleanEditor editor) throws DataSourceException {
        super.init(editor);
        final String propertyName = (String)editor.getClientProperty(CLIENT_PROPERTY_TABLE_PROPERTY_NAME);
        if (propertyName != null) {
            editor.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent event) {
                    if (event.getStateChange() == 1) {
                        Boolean newValue = ((BooleanEditor)event.getSource()).getBooleanValue();
                        JavaBeanObjectUtil.setProperty(ContentTableUIInitializer.this.getTableEditBean(), (String)propertyName, (Object)newValue);
                    }
                }
            });
        }
    }
}

