/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table.impl.longline;

import com.google.common.collect.Lists;
import fr.ird.observe.BinderService;
import fr.ird.observe.ObserveServiceHelper;
import fr.ird.observe.entities.longline.CatchLongline;
import fr.ird.observe.entities.longline.SetLongline;
import fr.ird.observe.entities.longline.SizeMeasure;
import fr.ird.observe.entities.longline.WeightMeasure;
import fr.ird.observe.ui.content.table.ContentTableMeta;
import fr.ird.observe.ui.content.table.ContentTableModel;
import fr.ird.observe.ui.content.table.ContentTableUIModel;
import fr.ird.observe.ui.content.table.ObserveContentTableUI;
import fr.ird.observe.ui.content.table.impl.longline.CatchLonglineTableModel;
import fr.ird.observe.ui.content.table.impl.longline.CatchLonglineUI;
import fr.ird.observe.ui.content.table.impl.longline.SizeMeasuresTableModel;
import fr.ird.observe.ui.content.table.impl.longline.WeightMeasuresTableModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderModelBuilder;

public class CatchLonglineUIModel
extends ContentTableUIModel<SetLongline, CatchLongline> {
    public static final String PROPERTY_SHOW_INDIVIDUAL_TABS = "showIndividualTabs";
    protected boolean showIndividualTabs;
    protected final SizeMeasuresTableModel sizeMeasuresTableModel;
    protected final Map<Integer, EditableList<SizeMeasure>> sizeMeasuresByRow = new TreeMap<Integer, EditableList<SizeMeasure>>();
    protected final Map<Integer, EditableList<WeightMeasure>> weightMeasuresByRow = new TreeMap<Integer, EditableList<WeightMeasure>>();
    protected final WeightMeasuresTableModel weightMeasuresTableModel;
    protected final TopiaEntityBinder<SizeMeasure> sizeMeasureLoader;
    protected final TopiaEntityBinder<WeightMeasure> weightMeasureLoader;

    public SizeMeasuresTableModel getSizeMeasuresTableModel() {
        return this.sizeMeasuresTableModel;
    }

    public WeightMeasuresTableModel getWeightMeasuresTableModel() {
        return this.weightMeasuresTableModel;
    }

    public boolean isShowIndividualTabs() {
        return this.showIndividualTabs;
    }

    public void setShowIndividualTabs(boolean showIndividualTabs) {
        this.showIndividualTabs = showIndividualTabs;
        this.firePropertyChange(PROPERTY_SHOW_INDIVIDUAL_TABS, null, showIndividualTabs);
    }

    public CatchLonglineUIModel(CatchLonglineUI ui) {
        super(SetLongline.class, CatchLongline.class, new String[]{"catchLongline"}, new String[]{"speciesCatch", "acquisitionMode", "count", "catchHealthness", "catchFateLongline", "discardHealthness", "depredated", "number", "homeId", "hookPosition", "hookWhenDiscarded", "maturityStatus", "photoReferences", "sex", "predator", "stomacFullness", "totalWeight", "beatDiameter", "gonadeWeight", "section", "basket", "branchline", "comment"});
        this.sizeMeasuresTableModel = new SizeMeasuresTableModel();
        this.weightMeasuresTableModel = new WeightMeasuresTableModel();
        BinderService binderService = ObserveServiceHelper.get().getBinderService();
        this.sizeMeasureLoader = binderService.getSimpleTopiaBinder(SizeMeasure.class);
        this.weightMeasureLoader = binderService.getSimpleTopiaBinder(WeightMeasure.class);
        ArrayList metas = Lists.newArrayList((Object[])new ContentTableMeta[]{ContentTableModel.newTableMeta(CatchLongline.class, "speciesCatch", false), ContentTableModel.newTableMeta(CatchLongline.class, "acquisitionMode", false), ContentTableModel.newTableMeta(CatchLongline.class, "count", false), ContentTableModel.newTableMeta(CatchLongline.class, "catchHealthness", false), ContentTableModel.newTableMeta(CatchLongline.class, "catchFateLongline", false), ContentTableModel.newTableMeta(CatchLongline.class, "discardHealthness", false), ContentTableModel.newTableMeta(CatchLongline.class, "depredated", false), ContentTableModel.newTableMeta(CatchLongline.class, "comment", false)});
        this.initModel(ui, metas);
    }

    @Override
    protected ContentTableModel<SetLongline, CatchLongline> createTableModel(ObserveContentTableUI<SetLongline, CatchLongline> ui, List<ContentTableMeta<CatchLongline>> contentTableMetas) {
        return new CatchLonglineTableModel(ui, contentTableMetas);
    }

    @Override
    protected BinderModelBuilder<CatchLongline, CatchLongline> prepareChildLoador(BinderService binderService, String binderName) {
        BinderModelBuilder builder = super.prepareChildLoador(binderService, binderName);
        builder.addCollectionStrategy(Binder.CollectionStrategy.duplicate, new String[]{"predator"});
        return builder;
    }

    public TopiaEntityBinder<SizeMeasure> getSizeMeasureLoader() {
        return this.sizeMeasureLoader;
    }

    public TopiaEntityBinder<WeightMeasure> getWeightMeasureLoader() {
        return this.weightMeasureLoader;
    }

    public List<SizeMeasure> getSizeMeasures() {
        return this.sizeMeasuresTableModel.getData();
    }

    public List<WeightMeasure> getWeightMeasures() {
        return this.weightMeasuresTableModel.getData();
    }

    public void setSizeMeasures(List<SizeMeasure> data) {
        this.sizeMeasuresTableModel.setData(data);
    }

    public void setWeightMeasures(List<WeightMeasure> data) {
        this.weightMeasuresTableModel.setData(data);
    }

    public void setSizeMeasures(int rowIndex, List<SizeMeasure> data) {
        EditableList<SizeMeasure> measures = this.sizeMeasuresByRow.get(rowIndex);
        measures.setData(data);
    }

    public void setWeightMeasures(int rowIndex, List<WeightMeasure> data) {
        EditableList<WeightMeasure> measures = this.weightMeasuresByRow.get(rowIndex);
        measures.setData(data);
    }

    public Set<Integer> getSizeMeasuresRowsChanged() {
        Set<Integer> rows = this.sizeMeasuresByRow.keySet();
        return rows;
    }

    public List<SizeMeasure> getSizeMeasures(int rowIndex) {
        EditableList<SizeMeasure> measures = this.sizeMeasuresByRow.get(rowIndex);
        return measures == null ? null : measures.getData();
    }

    public Set<Integer> getWeightMeasuresRowsChanged() {
        Set<Integer> rows = this.weightMeasuresByRow.keySet();
        return rows;
    }

    public List<WeightMeasure> getWeightMeasures(int rowIndex) {
        EditableList<WeightMeasure> measures = this.weightMeasuresByRow.get(rowIndex);
        return measures == null ? null : measures.getData();
    }

    public void storeSizeMeasures(int editingRow) {
        List<SizeMeasure> measures = this.getSizeMeasures();
        EditableList<Object> editableList = this.sizeMeasuresByRow.get(editingRow);
        if (editableList == null) {
            editableList = new EditableList();
            this.sizeMeasuresByRow.put(editingRow, editableList);
        }
        editableList.setData(measures);
    }

    public void storeWeightMeasures(int editingRow) {
        List<WeightMeasure> measures = this.getWeightMeasures();
        EditableList<Object> editableList = this.weightMeasuresByRow.get(editingRow);
        if (editableList == null) {
            editableList = new EditableList();
            this.weightMeasuresByRow.put(editingRow, editableList);
        }
        editableList.setData(measures);
    }

    public void removeSizeMeasures(int rowToDelete) {
        this.sizeMeasuresByRow.remove(rowToDelete);
        ArrayList rows = Lists.newArrayList(this.getSizeMeasuresRowsChanged());
        Collections.sort(rows);
        for (Integer row : rows) {
            if (row <= rowToDelete) continue;
            EditableList<SizeMeasure> remove = this.sizeMeasuresByRow.remove(row);
            this.sizeMeasuresByRow.put(row - 1, remove);
        }
    }

    public void removeWeightMeasures(int rowToDelete) {
        this.weightMeasuresByRow.remove(rowToDelete);
        ArrayList rows = Lists.newArrayList(this.getWeightMeasuresRowsChanged());
        Collections.sort(rows);
        for (Integer row : rows) {
            if (row <= rowToDelete) continue;
            EditableList<WeightMeasure> remove = this.weightMeasuresByRow.remove(row);
            this.weightMeasuresByRow.put(row - 1, remove);
        }
    }

    public boolean isSizeMeasureNotEmpty(SizeMeasure measure) {
        return measure.getSizeMeasureType() != null && measure.getSize() != null;
    }

    public boolean isWeightMeasureNotEmpty(WeightMeasure measure) {
        return measure.getWeightMeasureType() != null && measure.getWeight() != null;
    }

    public static class EditableList<E> {
        final List<E> data = new ArrayList();

        public List<E> getData() {
            return this.data;
        }

        public void setData(List<E> data) {
            this.data.clear();
            this.data.addAll(data);
        }
    }
}

