/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.storage.tabs;

import fr.ird.observe.db.util.SecurityModel;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.table.AbstractTableModel;
import org.nuiton.i18n.I18n;

public class RolesTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    public static final String[] COLUMN_NAMES = new String[]{I18n.n((String)"observe.security.role", (Object[])new Object[0]), I18n.n((String)"observe.security.unused", (Object[])new Object[0]), I18n.n((String)"observe.security.referentiel", (Object[])new Object[0]), I18n.n((String)"observe.security.utilisateur", (Object[])new Object[0]), I18n.n((String)"observe.security.technicien", (Object[])new Object[0])};
    public static final String[] COLUMN_NAME_TIPS = new String[]{I18n.n((String)"observe.security.role.tip", (Object[])new Object[0]), I18n.n((String)"observe.security.unused.tip", (Object[])new Object[0]), I18n.n((String)"observe.security.referentiel.tip", (Object[])new Object[0]), I18n.n((String)"observe.security.utilisateur.tip", (Object[])new Object[0]), I18n.n((String)"observe.security.technicien.tip", (Object[])new Object[0])};
    protected static final Class<?>[] COLUMN_CLASSES = new Class[]{String.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class};
    protected SecurityModel model;
    protected String[] roles;

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex > 0;
    }

    public void init(SecurityModel model) {
        this.model = model;
        ArrayList roles = new ArrayList(model.getRole());
        Collections.sort(roles);
        this.roles = roles.toArray(new String[roles.size()]);
        this.fireTableDataChanged();
    }

    public void clear() {
        this.model = null;
        this.roles = null;
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.roles == null ? 0 : this.roles.length;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_CLASSES.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object value = null;
        String p = this.getRole(rowIndex);
        if (p != null) {
            switch (columnIndex) {
                case 0: {
                    value = p;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    SecurityModel.Role r = SecurityModel.Role.values()[columnIndex - 1];
                    value = this.model.isRole(r, p);
                    break;
                }
                default: {
                    throw new IllegalStateException("can not get value for row " + rowIndex + ", col " + columnIndex);
                }
            }
        }
        return value;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return;
        }
        Boolean value = (Boolean)aValue;
        String role = this.getRole(rowIndex);
        SecurityModel.Role r = SecurityModel.Role.values()[columnIndex - 1];
        if (!value.booleanValue()) {
            r = null;
        }
        this.model.setRole(role, r, true);
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    protected String getRole(int rowIndex) {
        String role = this.roles == null ? null : this.roles[rowIndex];
        return role;
    }
}

