/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui;

import fr.ird.observe.DataService;
import fr.ird.observe.DecoratorService;
import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.impl.H2DataSource;
import fr.ird.observe.entities.constants.ReferenceLocale;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.ObserveUIMode;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUI;
import fr.ird.observe.ui.content.ContentUIManager;
import fr.ird.observe.ui.content.ContentUIModel;
import fr.ird.observe.ui.content.ObserveContentUI;
import fr.ird.observe.ui.tree.ObserveNavigationTreeShowPopupAction;
import fr.ird.observe.ui.tree.ObserveNode;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import fr.ird.observe.ui.util.ObserveSwingValidatorMessageTableModel;
import fr.ird.observe.ui.util.ObserveValidatorMessageTableRenderer;
import java.awt.Cursor;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.DefaultApplicationContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableRenderer;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.nuiton.i18n.I18n;

@DefaultApplicationContext.AutoLoad
public class ObserveMainUIHandler {
    private static Log log = LogFactory.getLog(ObserveMainUIHandler.class);
    public static final String H2_SERVER = "server";
    public static final String H2_WEB_SERVER = "webServer";
    public static final String H2_SERVER_URL_PATTERN = "jdbc:h2:%s/%s/obstuna";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeNavigationNode(ObserveMainUI ui, TreeSelectionEvent event) {
        DataSource source = ObserveContext.get().getDataSource();
        if (source == null || !source.isOpen()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No open Data source.");
            }
            return;
        }
        if (ui.getNavigation().isSelectionEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No selection, do nothing...");
            }
            return;
        }
        TreePath path = event.getPath();
        ObserveNode node = (ObserveNode)((Object)path.getLastPathComponent());
        ContentUIManager manager = ui.getContentManager();
        Class<? extends ObserveContentUI<?>> uiClass = manager.convertNodeToContentUI(node);
        if (log.isDebugEnabled()) {
            log.debug((Object)("new selected path = " + (Object)((Object)node) + ", ui = " + uiClass));
        }
        if (uiClass == null) {
            return;
        }
        ui.setBusy(true);
        try {
            this.doOpencontent(ui, path, manager, uiClass);
            ui.setBusy(false);
        }
        catch (Exception e) {
            try {
                if (log.isErrorEnabled()) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                ErrorDialogUI.showError((Exception)e);
                ui.setBusy(false);
            }
            catch (Throwable throwable) {
                ui.setBusy(false);
                String params = node.isStringNode() ? I18n.t((String)node.getId(), (Object[])new Object[0]) : I18n.t((String)ui.getContextValue(DataService.class).getDecoratorService().getEntityLabel(node.getInternalClass()), (Object[])new Object[0]);
                ui.getStatus().setStatus(I18n.t((String)"observe.action.open.screen", (Object[])new Object[]{params}));
                throw throwable;
            }
            String params = node.isStringNode() ? I18n.t((String)node.getId(), (Object[])new Object[0]) : I18n.t((String)ui.getContextValue(DataService.class).getDecoratorService().getEntityLabel(node.getInternalClass()), (Object[])new Object[0]);
            ui.getStatus().setStatus(I18n.t((String)"observe.action.open.screen", (Object[])new Object[]{params}));
        }
        String params = node.isStringNode() ? I18n.t((String)node.getId(), (Object[])new Object[0]) : I18n.t((String)ui.getContextValue(DataService.class).getDecoratorService().getEntityLabel(node.getInternalClass()), (Object[])new Object[0]);
        ui.getStatus().setStatus(I18n.t((String)"observe.action.open.screen", (Object[])new Object[]{params}));
    }

    public void doOpencontent(ObserveMainUI ui, TreePath path, ContentUIManager manager, Class<? extends ObserveContentUI<?>> uiClass) {
        Object[] nodes = path.getPath();
        ArrayList<String> ids = new ArrayList<String>();
        for (Object o : nodes) {
            ObserveNode n = (ObserveNode)((Object)o);
            if (n.isStringNode() || n.isReferentielNode() || n.isRoot() || !n.isDataNode()) continue;
            ids.add(n.getId());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("new selected ids from tree = " + ids));
        }
        String[] selectedIds = ids.toArray(new String[ids.size()]);
        DataContext context = ui.getDataContext();
        context.populateSelectedIds(selectedIds);
        ObserveContentUI<?> content = manager.getContent(uiClass);
        if (content == null) {
            content = manager.createContent(uiClass);
        }
        manager.openContent(content);
    }

    public ObserveMainUI initUI(ObserveContext context, ObserveConfig config) {
        ObserveSwingValidatorMessageTableModel errorModel = new ObserveSwingValidatorMessageTableModel();
        DecoratorService decoratorService = context.getDecoratorService();
        boolean reloadDecorators = false;
        Locale currentLocale = I18n.getDefaultLocale();
        Locale configurationLocale = config.getLocale();
        if (!configurationLocale.equals(currentLocale)) {
            if (log.isInfoEnabled()) {
                log.info((Object)("re-init I18n with locale " + configurationLocale));
            }
            I18n.setDefaultLocale((Locale)configurationLocale);
            reloadDecorators = true;
        }
        if (!config.getDbLocale().equals(decoratorService.getReferentielLocale().getLocale())) {
            if (log.isInfoEnabled()) {
                log.info((Object)("re-init db with locale " + config.getDbLocale()));
            }
            decoratorService.setReferentielLocale(ReferenceLocale.valueOf((Locale)config.getDbLocale()));
            reloadDecorators = true;
        }
        if (reloadDecorators) {
            if (log.isInfoEnabled()) {
                log.info((Object)"reload decorators");
            }
            decoratorService.reload();
        }
        ObserveTreeHelper treeHelper = new ObserveTreeHelper();
        DataSource source = context.getDataSource();
        boolean open = context.getDataContext().getEnabled();
        if (open) {
            treeHelper.createModel(source);
        } else {
            treeHelper.createEmptyModel();
        }
        JAXXInitialContext tx = new JAXXInitialContext();
        tx.add((Object)context).add((Object)treeHelper).add((Object)errorModel);
        ObserveMainUI ui = new ObserveMainUI((JAXXContext)tx);
        ui.setUndecorated(config.isFullScreen());
        String title = I18n.t((String)"observe.title.welcome.admin", (Object[])new Object[0]);
        title = title + " v " + config.getVersion();
        ui.setTitle(title);
        context.setObserveMainUI(ui);
        ErrorDialogUI.init((Frame)ui);
        ui.getGraphicsConfiguration().getDevice().setFullScreenWindow(config.isFullScreen() ? ui : null);
        context.registerShareActions(ui);
        new ObserveNavigationTreeShowPopupAction(treeHelper, ui.getNavigationScrollPane(), ui.getNavigationPopup());
        return ui;
    }

    public static DataSource getStorage() {
        DataSource source = ObserveContext.get().getDataSource();
        return source;
    }

    protected static DataService getDataService() {
        return ObserveContext.get().getDataService();
    }

    public static void restartEdit() {
        ContentUI<?> selectedUI = ObserveContext.get().getSelectedContentUI();
        if (selectedUI == null) {
            return;
        }
        ContentUIModel<?> model = selectedUI.getModel();
        if (!model.isEditable()) {
            return;
        }
        ContentMode contentMode = model.getMode();
        if (ContentMode.UPDATE != contentMode) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will restart edit for " + selectedUI.getName()));
        }
        selectedUI.restartEdit();
    }

    protected void reloadUI(ObserveContext rootContext, ObserveConfig config) {
        config.removeJaxxPropertyChangeListener();
        ObserveMainUI ui = this.getUI((JAXXContext)rootContext);
        DataSource mainStorage = rootContext.getDataSource();
        ObserveUIMode oldMode = null;
        String[] ids = null;
        if (ui != null) {
            oldMode = ui.getMode();
            ids = ui.getTreeHelper().getSelectedIds();
            ErrorDialogUI.init(null);
            rootContext.removeObserveMainUI();
            ui.dispose();
            ui.setVisible(false);
            System.runFinalization();
        }
        ui = this.initUI(rootContext, config);
        if (oldMode == null) {
            oldMode = mainStorage == null ? ObserveUIMode.NO_DB : ObserveUIMode.DB;
        }
        ui.setMode(oldMode);
        if (oldMode == ObserveUIMode.DB) {
            rootContext.setNodesToReselect(ids);
            ui.getTreeHelper().selectInitialNode(ui);
        }
        UIHelper.setMainUIVisible(ui);
    }

    protected Icon updateStorageSatutIcon(ObserveMainUI ui, boolean isOpened) {
        DataSource service;
        Icon icon = ui.getConfig().isMainStorageOpened() ? ((service = ObserveContext.get().getDataSource()) instanceof H2DataSource ? (Icon)ui.storageStatus.getClientProperty("localIcon") : (Icon)ui.storageStatus.getClientProperty("remoteIcon")) : (Icon)ui.storageStatus.getClientProperty("noneIcon");
        return icon;
    }

    protected String updateStorageSatutText(ObserveMainUI ui, boolean isOpened) {
        String text;
        if (ui.getConfig().isMainStorageOpened()) {
            DataSource service = ObserveContext.get().getDataSource();
            text = service.getShortLabel();
        } else {
            text = I18n.t((String)"observe.message.db.none.loaded", (Object[])new Object[0]);
        }
        return text;
    }

    protected String updateStorageStatutToolTipText(ObserveMainUI ui, boolean isOpened) {
        String text;
        if (ui.getConfig().isMainStorageOpened()) {
            DataSource source = ObserveContext.get().getDataSource();
            text = I18n.t((String)"observe.message.loaded.tip", (Object[])new Object[]{source.getLabel()});
        } else {
            text = I18n.t((String)"observe.message.db.none.loaded.tip", (Object[])new Object[0]);
        }
        return text;
    }

    public boolean acceptMode(ObserveUIMode mode, ObserveUIMode ... modes) {
        return this.acceptMode(mode, true, modes);
    }

    public boolean acceptMode(ObserveUIMode mode, boolean condition, ObserveUIMode ... modes) {
        if (condition) {
            for (ObserveUIMode m : modes) {
                if (!m.equals((Object)mode)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean acceptMode(ObserveUIMode mode, boolean notBusy, boolean condition, ObserveUIMode ... modes) {
        if (notBusy && condition) {
            for (ObserveUIMode m : modes) {
                if (!m.equals((Object)mode)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean rejectMode(ObserveUIMode mode, ObserveUIMode ... modes) {
        for (ObserveUIMode m : modes) {
            if (!m.equals((Object)mode)) continue;
            return false;
        }
        return true;
    }

    public boolean acceptLocale(Locale l, String expected) {
        return l != null && l.toString().equals(expected);
    }

    public ObserveMainUI getUI(JAXXContext context) {
        if (context instanceof ObserveMainUI) {
            return (ObserveMainUI)context;
        }
        ObserveMainUI ui = ObserveContext.get().getObserveMainUI();
        return ui;
    }

    protected void $afterCompleteSetup(final ObserveMainUI ui) {
        ui.getStatus().init();
        TreeSelectionListener listener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ObserveMainUIHandler.this.changeNavigationNode(ui, e);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ui.getNavigationScrollPane().getHorizontalScrollBar().setValue(0);
                        ui.getSplitpane2().resetToPreferredSizes();
                    }
                });
            }
        };
        TreeWillExpandListener veteobableTreeWillExpand = new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) {
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                ObserveNode selectedNode = (ObserveNode)ui.getTreeHelper().getSelectedNode();
                if (selectedNode == null) {
                    return;
                }
                ObserveNode o = (ObserveNode)((Object)event.getPath().getLastPathComponent());
                if (((Object)((Object)selectedNode)).equals((Object)o) || !selectedNode.isNodeAncestor((TreeNode)((Object)o))) {
                    return;
                }
                boolean canChange = ObserveContext.get().closeSelectedContentUI(ui);
                if (!canChange) {
                    throw new ExpandVetoException(event, "Can not collapse node " + event.getPath());
                }
            }
        };
        ui.getTreeHelper().setUI(ui.getNavigation(), true, true, listener, veteobableTreeWillExpand);
        SwingValidatorUtil.installUI((JTable)ui.getErrorTable(), (SwingValidatorMessageTableRenderer)new ObserveValidatorMessageTableRenderer());
        UIHelper.setLayerUI((JComponent)ui.getBody(), (LayerUI)ui.getBusyBlockLayerUI());
        ui.addPropertyChangeListener("busy", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean newvalue = (Boolean)evt.getNewValue();
                ObserveMainUIHandler.this.updateBusyState(ui, newvalue != null && newvalue != false);
            }
        });
    }

    protected void updateBusyState(ObserveMainUI ui, boolean busy) {
        if (busy) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"block ui in busy mode");
            }
            ui.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"unblock ui in none busy mode");
            }
            ui.setCursor(Cursor.getDefaultCursor());
        }
    }
}

