/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table.impl.seine;

import fr.ird.observe.DataService;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.entities.referentiel.Species;
import fr.ird.observe.entities.seine.SetSeine;
import fr.ird.observe.entities.seine.TargetLength;
import fr.ird.observe.entities.seine.TargetSample;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.table.ContentTableModel;
import fr.ird.observe.ui.content.table.ContentTableUI;
import fr.ird.observe.ui.content.table.ContentTableUIHandler;
import fr.ird.observe.ui.content.table.ContentTableUIModel;
import fr.ird.observe.ui.content.table.impl.seine.CodeMesureEnum;
import fr.ird.observe.ui.content.table.impl.seine.ModeSaisieEchantillonEnum;
import fr.ird.observe.ui.content.table.impl.seine.TargetSampleUI;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.validator.NuitonValidatorScope;

public class TargetSampleUIHandler
extends ContentTableUIHandler<TargetSample, TargetLength> {
    private static Log log = LogFactory.getLog(TargetSampleUIHandler.class);
    protected final boolean discarded;
    protected final PropertyChangeListener weightChanged = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            TargetLength source = (TargetLength)evt.getSource();
            source.setWeightSource(false);
        }
    };
    protected final PropertyChangeListener lengthChanged = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            TargetLength source = (TargetLength)evt.getSource();
            source.setLengthSource(false);
        }
    };

    public TargetSampleUIHandler(ContentTableUI<TargetSample, TargetLength> ui, boolean discarded) {
        super(ui, DataContextType.SetSeine);
        this.discarded = discarded;
    }

    @Override
    public TargetSampleUI getUi() {
        return (TargetSampleUI)super.getUi();
    }

    public void resetWeightSource() {
        ((TargetLength)this.getTableEditBean()).setWeightSource(false);
        this.getUi().getWeight().grabFocus();
    }

    public void resetLengthSource() {
        ((TargetLength)this.getTableEditBean()).setLengthSource(false);
        this.getUi().getLength().grabFocus();
    }

    @Override
    protected String getEditBeanIdToLoad(DataContext dataContext, DataService dataService, DataSource dataSource) throws DataSourceException {
        String setId = dataContext.getSelectedSetId();
        String id = dataService.getTargetSampleId(dataSource, setId, this.discarded);
        return id;
    }

    @Override
    protected TargetSample loadEditBean(ContentMode mode, DataContext dataContext, DataService dataService, DataSource dataSource) throws DataSourceException {
        String setId = dataContext.getSelectedSetId();
        if (mode == ContentMode.UPDATE) {
            List speciess = dataService.getAvailableEspeceForTargetSample(dataSource, setId, this.discarded);
            this.getUi().getSpecies().setData(speciess);
        }
        String id = this.getEditBeanIdToLoad(dataContext, dataService, dataSource);
        TargetSample editBean = (TargetSample)this.getBean();
        if (log.isInfoEnabled()) {
            log.info((Object)(this.prefix + " - set id            : " + setId));
            log.info((Object)(this.prefix + " - echantillon thon id : " + id));
            log.info((Object)(this.prefix + " - edit bean id        : " + editBean.getTopiaId()));
        }
        if (id == null) {
            this.getLoadBinder().load(null, (TopiaEntity)editBean, true, new String[0]);
            ((ContentTableUIModel)this.getModel()).getChildsUpdator().setChilds((TopiaEntity)editBean, new ArrayList());
        } else {
            dataService.loadEditEntity(dataSource, id, this.getLoadExecutor());
        }
        this.getModel().setMode(mode);
        this.getUi().getTableModel().attachModel();
        return editBean;
    }

    @Override
    protected boolean prepareSave(TargetSample bean, List<TargetLength> objets) throws DataSourceException {
        boolean withLengths;
        boolean bl = withLengths = !objets.isEmpty();
        if (withLengths) {
            if (bean.getTopiaId() == null) {
                String setId = this.getDataContext().getSelectedSetId();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Will create targetSample " + bean + " for " + setId));
                }
                this.getDataService().create(this.getDataSource(), setId, (TopiaEntity)bean, null, this.getCreateExecutor());
            }
            for (TargetLength targetLength : objets) {
                targetLength.setTargetSample(bean);
            }
        }
        return true;
    }

    @Override
    protected void doPersist(TargetSample bean, DataService dataService, DataSource dataSource) throws DataSourceException {
        if (bean.getTopiaId() != null && bean.isTargetLengthEmpty()) {
            String setId = this.getDataContext().getSelectedSetId();
            if (log.isInfoEnabled()) {
                log.info((Object)("Remove obsolete targetSample " + bean.getTopiaId() + " from Set: " + setId));
            }
            this.getDataService().delete(this.getDataSource(), setId, (TopiaEntity)bean, this.getDeleteExecutor());
        } else {
            super.doPersist(bean, dataService, dataSource);
        }
    }

    @Override
    protected TargetSample onCreate(TopiaContext tx, Object parent, TargetSample editBean) throws TopiaException {
        SetSeine parentBean = (SetSeine)parent;
        TargetSample beanToSave = (TargetSample)ObserveDAOHelper.getTargetSampleDAO((TopiaContext)tx).create(new Object[0]);
        beanToSave.setDiscarded(Boolean.valueOf(this.discarded));
        editBean.setTopiaId(beanToSave.getTopiaId());
        editBean.setTopiaCreateDate(beanToSave.getTopiaCreateDate());
        editBean.setTopiaVersion(beanToSave.getTopiaVersion());
        parentBean.addTargetSample(beanToSave);
        return beanToSave;
    }

    @Override
    protected void onDelete(TopiaContext tx, Object parent, TargetSample beanToDelete) throws TopiaException {
        SetSeine parentBean = (SetSeine)parent;
        parentBean.removeTargetSample(beanToDelete);
    }

    @Override
    protected void onSelectedRowChanged(int editingRow, TargetLength bean, boolean create) {
        BeanComboBox<Species> requestFocus;
        ContentTableModel model = this.getTableModel();
        TargetSampleUI ui = this.getUi();
        if (!model.isEditable()) {
            return;
        }
        Species species = bean.getSpecies();
        if (create) {
            if (model.isCreate()) {
                if (editingRow > 0) {
                    TargetLength editBean = (TargetLength)model.getValueAt(editingRow - 1);
                    species = editBean.getSpecies();
                }
                ui.getAcquisitionModeGroup().setSelectedValue(null);
                ui.getAcquisitionModeGroup().setSelectedValue((Object)ModeSaisieEchantillonEnum.byEffectif);
                ui.getMeasureType().setSelectedItem(null);
                ui.getMeasureType().setSelectedItem((Object)CodeMesureEnum.lf);
            }
            requestFocus = ui.getSpecies();
        } else {
            requestFocus = ui.getCount();
            int acquisitionMode = bean.getAcquisitionMode();
            ModeSaisieEchantillonEnum enumValue = ModeSaisieEchantillonEnum.valueOf(acquisitionMode);
            ui.getAcquisitionModeGroup().setSelectedValue(null);
            ui.getAcquisitionModeGroup().setSelectedValue((Object)enumValue);
        }
        ui.getSpecies().setSelectedItem(null);
        if (species != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("species to use " + species));
            }
            ui.getSpecies().setSelectedItem((Object)species);
        }
        requestFocus.requestFocus();
        TargetLength tableEditBean = (TargetLength)this.getTableEditBean();
        tableEditBean.removePropertyChangeListener("weight", this.weightChanged);
        tableEditBean.addPropertyChangeListener("weight", this.weightChanged);
        tableEditBean.removePropertyChangeListener("length", this.lengthChanged);
        tableEditBean.addPropertyChangeListener("length", this.lengthChanged);
    }

    @Override
    protected void initTableUI(DefaultTableCellRenderer renderer) {
        JTable table = this.getUi().getTable();
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n((String)"observe.targetSample.table.speciesThon", (Object[])new Object[0]), I18n.n((String)"observe.targetSample.table.speciesThon.tip", (Object[])new Object[0]), I18n.n((String)"observe.targetSample.table.measureType", (Object[])new Object[0]), I18n.n((String)"observe.targetSample.table.measureType.tip", (Object[])new Object[0]), I18n.n((String)"observe.targetSample.table.length", (Object[])new Object[0]), I18n.n((String)"observe.targetSample.table.length.tip", (Object[])new Object[0]), I18n.n((String)"observe.targetSample.table.meanWeight", (Object[])new Object[0]), I18n.n((String)"observe.targetSample.table.meanWeight.tip", (Object[])new Object[0]), I18n.n((String)"observe.targetSample.table.count", (Object[])new Object[0]), I18n.n((String)"observe.targetSample.table.count.tip", (Object[])new Object[0]), I18n.n((String)"observe.targetSample.table.totalWeight", (Object[])new Object[0]), I18n.n((String)"observe.targetSample.table.totalWeight.tip", (Object[])new Object[0])});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, Species.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newEnumTableCellRenderer((TableCellRenderer)renderer, CodeMesureEnum.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)3, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)4, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)5, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        boolean showData;
        ContentMode mode;
        block3: {
            mode = super.getContentMode(dataContext);
            showData = false;
            try {
                String setId = this.getDataContext().getSelectedSetId();
                showData = this.getDataService().canUseTargetSample(this.getDataSource(), setId, this.discarded);
            }
            catch (DataSourceException e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)e);
            }
        }
        ((ContentTableUIModel)this.getModel()).setShowData(showData);
        if (mode == ContentMode.UPDATE && !showData) {
            mode = ContentMode.READ;
            TargetSampleUIHandler.addMessage(this.getUi(), NuitonValidatorScope.INFO, this.getEntityLabel(SetSeine.class), this.discarded ? I18n.t((String)"observe.setSeine.message.no.targetCatch", (Object[])new Object[0]) : I18n.t((String)"observe.setSeine.message.no.targetDiscarded", (Object[])new Object[0]));
        }
        return mode;
    }

    public void updateModeSaisie(ModeSaisieEchantillonEnum newMode) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Change mode saisie to " + (Object)((Object)newMode)));
        }
        if (newMode == null) {
            return;
        }
        TargetSampleUI ui = this.getUi();
        boolean createMode = ui.getTableModel().isCreate();
        TargetLength editBean = ui.getTableEditBean();
        switch (newMode) {
            case byEffectif: {
                ui.getWeight().setEnabled(false);
                ui.getCount().setEnabled(true);
                if (!createMode) break;
                editBean.setWeight(null);
                editBean.setCount(null);
                break;
            }
            case byIndividu: {
                ui.getWeight().setEnabled(true);
                ui.getCount().setEnabled(false);
                if (!createMode) break;
                editBean.setCount(Integer.valueOf(1));
            }
        }
        if (createMode) {
            editBean.setAcquisitionMode(newMode.ordinal());
        }
    }
}

