/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui;

import fr.ird.observe.DecoratorService;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveServiceHelper;
import fr.ird.observe.ui.ObserveMainUI;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.FileChooserUtil;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.renderer.DecoratorTableCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntity;

public class UIHelper
extends SwingUtil {
    private static final Log log = LogFactory.getLog(UIHelper.class);
    public static final String INT_3_DIGITS_PATTERN = "\\d{0,3}";
    public static final String INT_6_DIGITS_PATTERN = "\\d{0,6}";
    public static final String INT_7_DIGITS_PATTERN = "\\d{0,7}";
    public static final String LONG_10_DIGITS_PATTERN = "\\d{0,10}";
    public static final String DECIMAL1_PATTERN = "\\d{0,6}|\\d{1,6}.\\d{0,1}";
    public static final String DECIMAL2_PATTERN = "\\d{0,6}|\\d{1,6}.\\d{0,2}";
    public static final String DECIMAL3_PATTERN = "\\d{0,6}|\\d{1,6}.\\d{0,3}";
    public static final String[] ACCEPTABLE_COMPONENTS = new String[]{"showProgressButton", "globalProgressionCopyToClipBoard", "progressionTopCopyCliptBoard"};
    public static final Comparator<Class> REFERENTIEL_COMPARATOR = new Comparator<Class>(){
        DecoratorService decoratorService = ObserveServiceHelper.getDecoratorService();

        @Override
        public int compare(Class o1, Class o2) {
            String s1 = I18n.t((String)this.decoratorService.getEntityLabel(o1), (Object[])new Object[0]);
            String s2 = I18n.t((String)this.decoratorService.getEntityLabel(o2), (Object[])new Object[0]);
            return s1.compareTo(s2);
        }
    };

    public static void displayInfo(String text) {
        ObserveMainUI ui = ObserveContext.get().getObserveMainUI();
        if (ui == null) {
            JOptionPane.showMessageDialog(null, text);
        } else {
            ui.getStatus().setStatus(text);
        }
    }

    public static void displayWarning(String title, String text) {
        ObserveMainUI ui = ObserveContext.get().getObserveMainUI();
        JOptionPane.showMessageDialog(ui, text, title, 2);
    }

    public static int askUser(String title, String message, int typeMessage, Object[] options, int defaultOption) {
        return UIHelper.askUser(null, title, message, typeMessage, options, defaultOption);
    }

    public static int askUser(Component parent, String title, Object message, int typeMessage, Object[] options, int defaultOption) {
        ObserveContext tx;
        if (parent == null && (tx = ObserveContext.get()) != null) {
            parent = ObserveContext.get().getObserveMainUI();
        }
        int response = JOptionPane.showOptionDialog(parent, message, title, -1, typeMessage, null, options, options[defaultOption]);
        return response;
    }

    public static File chooseFile(Component parent, String title, String buttonLabel, File incoming, String ... filters) {
        File basedir;
        File oldBasedir = FileChooserUtil.getCurrentDirectory();
        if (incoming != null && (basedir = incoming.isFile() ? incoming.getParentFile() : incoming).exists()) {
            FileChooserUtil.setCurrentDirectory((File)basedir);
        }
        File file = FileChooserUtil.getFile((String)title, (String)buttonLabel, (Component)parent, (String[])filters);
        if (log.isDebugEnabled()) {
            log.debug((Object)(title + " : " + file));
        }
        FileChooserUtil.setCurrentDirectory((File)oldBasedir);
        File result = file == null ? incoming : file;
        return result;
    }

    public static File chooseDirectory(Component parent, String title, String buttonLabel, File incoming) {
        File basedir;
        File oldBasedir = FileChooserUtil.getCurrentDirectory();
        if (incoming != null && (basedir = incoming.isFile() ? incoming.getParentFile() : incoming).exists()) {
            FileChooserUtil.setCurrentDirectory((File)basedir);
        }
        String file = FileChooserUtil.getDirectory((Component)parent, (String)title, (String)buttonLabel);
        if (log.isDebugEnabled()) {
            log.debug((Object)(title + " : " + file));
        }
        FileChooserUtil.setCurrentDirectory((File)oldBasedir);
        return file == null ? incoming : new File(file);
    }

    public static <E extends TopiaEntity> boolean confirmForEntityDelete(JAXXObject parent, Class<E> beanClass, E bean) {
        return UIHelper.confirmForEntityDelete(parent, beanClass, bean, null);
    }

    public static <E extends TopiaEntity> boolean confirmForEntityDelete(JAXXObject parent, Class<E> beanClass, E bean, String extraMessage) {
        String messageDelete;
        ObserveMainUI mainUI = ObserveContext.get().getObserveMainUI();
        if (parent == null) {
            parent = mainUI;
        }
        if (mainUI != null) {
            mainUI.setBusy(true);
        }
        DecoratorService decoratorService = ObserveContext.get().getDecoratorService();
        Decorator decorator = decoratorService.getDecoratorByType(beanClass);
        String type = decoratorService.getEntityLabel(beanClass);
        type = I18n.t((String)type, (Object[])new Object[0]);
        if (bean == null || bean.getTopiaId() == null || decorator == null) {
            messageDelete = I18n.t((String)"observe.message.delete.new", (Object[])new Object[]{type});
        } else {
            try {
                String beanStr = decorator.toString(bean);
                messageDelete = I18n.t((String)"observe.message.delete", (Object[])new Object[]{type, beanStr});
            }
            catch (Exception e) {
                messageDelete = I18n.t((String)"observe.message.delete.new", (Object[])new Object[]{type});
            }
        }
        if (extraMessage != null) {
            messageDelete = messageDelete + '\n' + extraMessage;
        }
        int response = UIHelper.askUser((Component)parent, I18n.t((String)"observe.title.delete", (Object[])new Object[0]), messageDelete, 2, new Object[]{I18n.t((String)"observe.choice.confirm.delete", (Object[])new Object[0]), I18n.t((String)"observe.choice.cancel", (Object[])new Object[0])}, 1);
        if (mainUI != null) {
            mainUI.setBusy(true);
        }
        return response == 0;
    }

    public static DecoratorTableCellRenderer newDecorateTableCellRenderer(TableCellRenderer renderer, Class<?> entityClass) {
        Decorator decorator = ObserveContext.get().getDecorator(entityClass);
        return new DecoratorTableCellRenderer(renderer, decorator);
    }

    public static DecoratorTableCellRenderer newDecorateTableCellRenderer(TableCellRenderer renderer, Class<?> entityClass, String context) {
        Decorator decorator = ObserveContext.get().getDecorator(entityClass, context);
        return new DecoratorTableCellRenderer(renderer, decorator);
    }

    public static void sortReferentiel(List<Class> classes) {
        Collections.sort(classes, REFERENTIEL_COMPARATOR);
    }

    public static void copyToClipBoard(String text) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (log.isInfoEnabled()) {
            log.info((Object)("Put in clipboard :\n" + text));
        }
        StringSelection selection = new StringSelection(text);
        clipboard.setContents(selection, selection);
    }

    public static void setMainUIVisible(final ObserveMainUI ui) {
        ui.getSplitpane().revalidate();
        ui.getSplitpane2().revalidate();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ui.setVisible(true);
            }
        });
    }

    public static <E extends TopiaEntity> E getEntity(List<E> list, E entity) {
        for (TopiaEntity e : list) {
            if (!e.getTopiaId().equals(entity.getTopiaId())) continue;
            return (E)e;
        }
        return null;
    }

    public static void openLink(HyperlinkEvent he) {
        block6: {
            if (he.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
                try {
                    URL u = he.getURL();
                    if (u.getProtocol().equalsIgnoreCase("mailto") || u.getProtocol().equalsIgnoreCase("http") || u.getProtocol().equalsIgnoreCase("ftp") || u.getProtocol().equalsIgnoreCase("file")) {
                        Desktop.getDesktop().browse(u.toURI());
                    }
                }
                catch (IOException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Error while opening link", (Throwable)e);
                    }
                }
                catch (URISyntaxException e) {
                    if (!log.isErrorEnabled()) break block6;
                    log.error((Object)"Error while opening link", (Throwable)e);
                }
            }
        }
    }

    public static void stopEditing(JTable table) {
        TableCellEditor cellEditor = table.getCellEditor();
        if (cellEditor != null) {
            cellEditor.cancelCellEditing();
        }
    }
}

