/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.open;

import fr.ird.observe.DataService;
import fr.ird.observe.ObserveServiceHelper;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.entities.OpenableEntity;
import fr.ird.observe.entities.Trip;
import fr.ird.observe.entities.seine.TripSeine;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUI;
import fr.ird.observe.ui.content.ContentUIHandler;
import fr.ird.observe.ui.content.ContentUIModel;
import fr.ird.observe.ui.content.ObserveContentUI;
import fr.ird.observe.ui.content.open.ContentOpenableUI;
import fr.ird.observe.ui.content.open.ContentOpenableUIModel;
import fr.ird.observe.ui.tree.ObserveNode;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import javax.swing.tree.TreeNode;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.nav.NavNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.validator.NuitonValidatorScope;

public abstract class ContentOpenableUIHandler<E extends TopiaEntity & OpenableEntity>
extends ContentUIHandler<E> {
    protected static final String POSITION_OPENABLE = "positionOpenable";
    private static final Log log = LogFactory.getLog(ContentOpenableUIHandler.class);
    protected final String closeMessage;

    public ContentOpenableUIHandler(ContentOpenableUI<E> ui, DataContextType parentType, DataContextType type, String closeMessage) {
        super(ui, parentType, type);
        this.closeMessage = closeMessage;
    }

    protected abstract boolean obtainCanReopen(boolean var1);

    @Override
    public ContentOpenableUI<E> getUi() {
        return (ContentOpenableUI)super.getUi();
    }

    @Override
    public ContentOpenableUIModel<E> getModel() {
        return (ContentOpenableUIModel)super.getModel();
    }

    @Override
    protected boolean computeCanWrite(DataSource source) {
        return source.canWriteData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void openDataUI() {
        boolean ok = false;
        try {
            this.doOpenData();
            ok = true;
        }
        catch (Exception e) {
            ErrorDialogUI.showError((Exception)e);
            if (log.isErrorEnabled()) {
                log.error((Object)e);
            }
        }
        finally {
            if (ok) {
                this.afterOpenData();
            }
        }
    }

    public final void doOpenData() throws Exception {
        String id = this.getBean().getTopiaId();
        this.getDataService().updateOpenProperty(this.getDataSource(), id, true);
    }

    public final void afterOpenData() {
        ObserveContentUI ui = this.getUi();
        ObserveTreeHelper treeHelper = ContentOpenableUIHandler.getTreeHelper((JAXXContext)ui);
        ObserveNode node = (ObserveNode)treeHelper.getSelectedNode();
        treeHelper.refreshNode((NavNode)node.getParent(), true);
        ((ContentOpenableUIModel)((ContentOpenableUI)ui).getModel()).setCanReopen(false);
        ((ContentUI)ui).restartEdit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeDataUI() {
        boolean ok = false;
        try {
            ok = this.doCloseData();
        }
        catch (Exception e) {
            ErrorDialogUI.showError((Exception)e);
            if (log.isErrorEnabled()) {
                log.error((Object)e);
            }
        }
        finally {
            if (ok) {
                this.afterCloseData();
            }
        }
    }

    public boolean doCloseData() throws Exception {
        return this.doCloseData(this.getBean().getTopiaId());
    }

    public final boolean doCloseData(String id) throws Exception {
        this.getDataService().updateOpenProperty(this.getDataSource(), id, false);
        return true;
    }

    public final void afterCloseData() {
        ObserveContentUI ui = this.getUi();
        ContentUIModel model = this.getModel();
        ((ContentOpenableUIModel)model).setCanReopen(true);
        Object bean = this.getBean();
        ((ContentUI)ui).stopEdit();
        model.setMode(ContentMode.READ);
        ContentOpenableUIHandler.removeAllMessages(ui);
        ContentOpenableUIHandler.addMessage(ui, NuitonValidatorScope.INFO, this.getEntityLabel(bean.getClass()), I18n.t((String)this.closeMessage, (Object[])new Object[0]));
        ObserveTreeHelper treeHelper = ContentOpenableUIHandler.getTreeHelper((JAXXContext)ui);
        ObserveNode selectedNode = (ObserveNode)treeHelper.getSelectedNode();
        if (bean instanceof TripSeine) {
            selectedNode = (ObserveNode)selectedNode.getParent();
        }
        treeHelper.refreshNode((NavNode)selectedNode, true);
        this.updateActions();
    }

    @Override
    protected void afterSave(boolean refresh) {
        super.afterSave(refresh);
        ObserveContentUI ui = this.getUi();
        int position = ((ContentUI)ui).getContextValue(Integer.class, POSITION_OPENABLE);
        ObserveTreeHelper treeHelper = ContentOpenableUIHandler.getTreeHelper((JAXXContext)ui);
        ObserveNode node = (ObserveNode)treeHelper.getSelectedNode();
        ObserveNode parentNode = (ObserveNode)node.getParent();
        boolean create = node.getId() == null;
        Object bean = this.getBean();
        int oldPosition = create ? parentNode.getChildCount() : parentNode.getIndex((TreeNode)((Object)node));
        if (create) {
            this.getModel().setMode(ContentMode.UPDATE);
            treeHelper.removeNode((NavNode)node);
            node = treeHelper.addOpenable(parentNode, (OpenableEntity)bean);
            this.stopEditUI();
            if (oldPosition != position) {
                treeHelper.moveNode((NavNode)parentNode, (NavNode)node, position);
            }
            treeHelper.selectNode((NavNode)node);
        } else {
            if (oldPosition != position) {
                treeHelper.moveNode((NavNode)parentNode, (NavNode)node, position);
                treeHelper.selectNode((NavNode)node);
            }
            treeHelper.refreshNode((NavNode)node, true);
        }
    }

    public final void closeAndCreateDataUI() {
        try {
            boolean b = this.doCloseData();
            if (!b) {
                if (log.isInfoEnabled()) {
                    log.info((Object)(this.prefix + "Stop closing data..."));
                }
                return;
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not close current data", (Throwable)eee);
            }
            ErrorDialogUI.showError((Exception)eee);
        }
        this.stopEditUI();
        ObserveTreeHelper treeHelper = ContentOpenableUIHandler.getTreeHelper((JAXXContext)this.getUi());
        ObserveNode parentNode = (ObserveNode)((ObserveNode)treeHelper.getSelectedNode()).getParent();
        if (log.isDebugEnabled()) {
            log.debug((Object)("PARENT NODE = " + (Object)((Object)parentNode)));
        }
        treeHelper.addUnsavedNode(parentNode, this.getBeanType());
    }

    protected final void obtainChildPosition(E bean, DataService dataService, DataSource dataSource) throws DataSourceException {
        String containerId = this.getSelectedParentId();
        int position = dataService.getOpenablePosition(dataSource, containerId, bean.getTopiaId());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Position of child : " + position));
        }
        ((ContentUI)this.getUi()).setContextValue(position, POSITION_OPENABLE);
    }

    protected final void finalizeOpenUI(ContentMode mode, boolean create) {
        Trip currentTrip;
        this.setContentMode(mode);
        boolean historicalData = false;
        ContentUIModel model = ((ContentOpenableUI)this.getUi()).getModel();
        if (!create && (currentTrip = ObserveServiceHelper.getValidationContext().getCurrentTrip()) != null && currentTrip.isHistoricalData()) {
            if (log.isInfoEnabled()) {
                log.info((Object)(this.prefix + "Using a historical fish trip " + currentTrip.getTopiaId()));
            }
            historicalData = true;
        }
        ((ContentOpenableUIModel)model).setHistoricalData(historicalData);
        boolean canReopen = this.obtainCanReopen(create);
        if (log.isInfoEnabled()) {
            log.info((Object)(this.prefix + "historical data ? = " + historicalData));
            log.info((Object)(this.prefix + "can reopen      ? = " + canReopen));
        }
        ((ContentOpenableUIModel)model).setCanReopen(canReopen);
        if (mode != ContentMode.READ) {
            ((ContentUI)this.getUi()).startEdit(null);
        }
    }
}

