/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.save;

import fr.ird.observe.ui.admin.AdminActionModel;
import fr.ird.observe.ui.admin.AdminStep;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SaveLocalModel
extends AdminActionModel {
    public static final String BACKUP_FILE_PROPERTY_NAME = "backupFile";
    public static final String DO_BACKUP_PROPERTY_NAME = "doBackup";
    public static final String CAN_SAVE_LOCAL_PROPERTY_NAME = "canSaveLocal";
    public static final String LOCAL_SOURCE_NEED_SAVE_PROPERTY_NAME = "localSourceNeedSave";
    private static final Log log = LogFactory.getLog(SaveLocalModel.class);
    protected File backupFile = new File("");
    protected boolean doBackup;
    protected boolean localSourceNeedSave;
    protected Set<AdminStep> stepsForSave;

    public SaveLocalModel() {
        super(AdminStep.SAVE_LOCAL);
    }

    public boolean isLocalSourceNeedSave() {
        return this.localSourceNeedSave;
    }

    public void setLocalSourceNeedSave(boolean localSourceNeedSave) {
        this.localSourceNeedSave = localSourceNeedSave;
        this.firePropertyChange(LOCAL_SOURCE_NEED_SAVE_PROPERTY_NAME, null, localSourceNeedSave);
    }

    public boolean isDoBackup() {
        return this.doBackup;
    }

    public void setDoBackup(boolean doBackup) {
        boolean canSave = this.isCanSaveLocal();
        boolean oldValue = this.doBackup;
        this.doBackup = doBackup;
        this.firePropertyChange(DO_BACKUP_PROPERTY_NAME, oldValue, doBackup);
        this.firePropertyChange(CAN_SAVE_LOCAL_PROPERTY_NAME, canSave, this.isCanSaveLocal());
    }

    public File getBackupFile() {
        return this.backupFile;
    }

    public void setBackupFile(File backupFile) {
        boolean canSave = this.isCanSaveLocal();
        File oldValue = this.backupFile;
        this.backupFile = backupFile;
        this.firePropertyChange(BACKUP_FILE_PROPERTY_NAME, oldValue, backupFile);
        this.firePropertyChange(CAN_SAVE_LOCAL_PROPERTY_NAME, canSave, this.isCanSaveLocal());
    }

    public Set<AdminStep> getStepsForSave() {
        if (this.stepsForSave == null) {
            this.stepsForSave = new HashSet<AdminStep>();
        }
        return this.stepsForSave;
    }

    public boolean containsStepForsave(AdminStep step) {
        return this.stepsForSave != null && this.stepsForSave.contains((Object)step);
    }

    public boolean isCanSaveLocal() {
        boolean validate;
        boolean bl = validate = !this.doBackup || this.backupFile != null && !this.backupFile.exists() && this.backupFile.getName().endsWith(".sql.gz") && this.backupFile.getParentFile().exists();
        if (log.isDebugEnabled()) {
            log.debug((Object)("can save ? " + validate));
        }
        return validate;
    }

    public void addStepForSave(AdminStep step) {
        this.getStepsForSave().add(step);
        this.setLocalSourceNeedSave(true);
    }
}

