/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table.impl;

import fr.ird.observe.DecoratorService;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.util.TopiaExecutor;
import fr.ird.observe.entities.Calee;
import fr.ird.observe.entities.CaptureThon;
import fr.ird.observe.entities.EchantillonThon;
import fr.ird.observe.entities.TailleThon;
import fr.ird.observe.entities.referentiel.CategoriePoids;
import fr.ird.observe.entities.referentiel.EspeceThon;
import fr.ird.observe.entities.referentiel.RaisonRejet;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.table.ContentTableModel;
import fr.ird.observe.ui.content.table.ContentTableUIHandler;
import fr.ird.observe.ui.content.table.ContentTableUIModel;
import fr.ird.observe.ui.content.table.impl.RejetThonUI;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;

public class RejetThonUIHandler
extends ContentTableUIHandler<Calee, CaptureThon> {
    private static Log log = LogFactory.getLog(RejetThonUIHandler.class);
    JAXXContextEntryDef<List<EspeceThon>> ALL_ESPECES_ENTRY = UIHelper.newListContextEntryDef((String)"all-especes");
    JAXXContextEntryDef<List<CategoriePoids>> ALL_CATEGORIES_ENTRY = UIHelper.newListContextEntryDef((String)"all-categories");
    JAXXContextEntryDef<List<RaisonRejet>> ALL_RAISONS_REJET_ENTRY = UIHelper.newListContextEntryDef((String)"all-raisonRejets");
    JAXXContextEntryDef<List<TailleThon>> ALL_TAILLES_TO_DELETE_ENTRY = UIHelper.newListContextEntryDef((String)"all-taille-to-delete");
    TopiaExecutor<CategoriePoids> categoriePoidsTopiaExecutor = new TopiaExecutor<CategoriePoids>(){

        public void execute(TopiaContext tx, CategoriePoids bean) {
            RejetThonUIHandler.this.getDecoratorService().decorate((Object)bean.getEspece());
        }
    };

    public static ContentTableUIModel<Calee, CaptureThon> newModel(RejetThonUI ui) {
        return new ContentTableUIModel<Calee, CaptureThon>(Calee.class, CaptureThon.class, new String[]{"captureThon", "rejetThon"}, new String[]{"calee", "categoriePoids", "poids", "raisonRejet", "rejete", "surLePont", "commentaire"}, ui, ContentTableModel.newTableMeta(CaptureThon.class, "espece", true), ContentTableModel.newTableMeta(CaptureThon.class, "categoriePoids", true), ContentTableModel.newTableMeta(CaptureThon.class, "raisonRejet", true), ContentTableModel.newTableMeta(CaptureThon.class, "poids", false), ContentTableModel.newTableMeta(CaptureThon.class, "surLePont", false), ContentTableModel.newTableMeta(CaptureThon.class, "commentaire", false));
    }

    public RejetThonUIHandler(RejetThonUI ui) {
        super(ui);
    }

    @Override
    public RejetThonUI getUi() {
        return (RejetThonUI)super.getUi();
    }

    @Override
    public void initUI() throws Exception {
        super.initUI();
        RejetThonUI ui = this.getUi();
        ui.getEspece().addPropertyChangeListener("selectedItem", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ContentTableModel model = RejetThonUIHandler.this.getTableModel();
                CaptureThon bean = (CaptureThon)model.getRowBean();
                if (bean.getTopiaId() == null) {
                    EspeceThon espece = (EspeceThon)evt.getNewValue();
                    RejetThonUIHandler.this.onEspeceChanged(bean, espece);
                }
            }
        });
        ui.getCategoriePoids().addPropertyChangeListener("selectedItem", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ContentTableModel model = RejetThonUIHandler.this.getTableModel();
                CaptureThon bean = (CaptureThon)model.getRowBean();
                if (bean.getTopiaId() == null) {
                    CategoriePoids categoriePoids = (CategoriePoids)evt.getNewValue();
                    RejetThonUIHandler.this.onCategorieChanged(bean, categoriePoids);
                }
            }
        });
    }

    @Override
    protected Calee loadEditBean(ContentMode mode, DataContext dataContext, DataService dataService, DataSource dataSource) throws DataSourceException {
        ArrayList raisonRejetList;
        ArrayList especeList;
        ArrayList categorieList;
        if (mode == ContentMode.UPDATE) {
            HashSet<EspeceThon> availableEspeces = new HashSet<EspeceThon>();
            categorieList = new ArrayList(dataService.loadDecoratedEntities(dataSource, CategoriePoids.class, this.categoriePoidsTopiaExecutor));
            UIHelper.filterReferentielList(categorieList, null);
            for (CategoriePoids c : categorieList) {
                availableEspeces.add(c.getEspece());
            }
            especeList = new ArrayList(availableEspeces);
            UIHelper.filterReferentielList(especeList, null);
            raisonRejetList = new ArrayList(dataService.loadDecoratedEntities(dataSource, RaisonRejet.class));
            UIHelper.filterReferentielList(raisonRejetList, null);
        } else {
            especeList = new ArrayList();
            categorieList = new ArrayList();
            raisonRejetList = new ArrayList();
        }
        RejetThonUI ui = this.getUi();
        this.ALL_ESPECES_ENTRY.setContextValue((JAXXContext)ui, especeList);
        this.ALL_CATEGORIES_ENTRY.setContextValue((JAXXContext)ui, categorieList);
        this.ALL_RAISONS_REJET_ENTRY.setContextValue((JAXXContext)ui, raisonRejetList);
        return (Calee)super.loadEditBean(mode, dataContext, dataService, dataSource);
    }

    @Override
    protected Collection<CaptureThon> loadChilds(TopiaContext tx, Calee bean) throws TopiaException {
        Collection childs = this.getChildsUpdator().getChilds((TopiaEntity)bean);
        ArrayList<CaptureThon> data = new ArrayList<CaptureThon>();
        if (CollectionUtils.isNotEmpty((Collection)childs)) {
            TopiaDAO dao = this.getDataSource().getDAO(tx, this.getTableEditBean());
            TopiaEntityBinder childLoador = this.getChildLoador();
            DecoratorService decoratorService = this.getDecoratorService();
            for (CaptureThon c : childs) {
                if (!c.isRejete()) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("captureThon " + c.getEspece().getLibelle2() + " non retenu."));
                    continue;
                }
                try {
                    CaptureThon c2 = (CaptureThon)((ContentTableUIModel)this.getModel()).newTableEditBean();
                    CaptureThon safeC = (CaptureThon)dao.findByTopiaId(c.getTopiaId());
                    CategoriePoids categoriePoids = safeC.getCategoriePoids();
                    if (categoriePoids != null) {
                        EspeceThon espece = categoriePoids.getEspece();
                        decoratorService.decorate((Object)espece);
                    }
                    childLoador.load((TopiaEntity)safeC, (TopiaEntity)c2, true, new String[0]);
                    data.add(c2);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doSave(Calee bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<Calee> binder) throws Exception {
        try {
            boolean bl = super.doSave(bean, dataService, dataSource, binder);
            return bl;
        }
        finally {
            this.ALL_TAILLES_TO_DELETE_ENTRY.removeContextValue((JAXXContext)this.getUi());
        }
    }

    @Override
    protected boolean prepareSave(Calee bean, List<CaptureThon> objets) throws DataSourceException {
        HashSet<EspeceThon> especesUsed = new HashSet<EspeceThon>();
        for (CaptureThon c : objets) {
            if (c.getSurLePont() == null || !c.getSurLePont().booleanValue()) continue;
            especesUsed.add(c.getEspece());
        }
        ArrayList tailleToDelete = new ArrayList();
        HashSet especesToDelete = new HashSet();
        this.getDataService().getObsoleteEspeceForEchantillonThon(this.getDataSource(), bean.getTopiaId(), especesUsed, especesToDelete, tailleToDelete, false);
        if (!tailleToDelete.isEmpty()) {
            StringBuilder sb = new StringBuilder(512);
            StringBuilder sb2 = new StringBuilder(512);
            Decorator decorator = this.getDecoratorService().getDecorator(EspeceThon.class);
            Decorator decorator2 = this.getDecoratorService().getDecorator(TailleThon.class);
            for (EspeceThon e : especesToDelete) {
                sb.append("  - ").append(decorator.toString((Object)e)).append('\n');
            }
            for (TailleThon t : tailleToDelete) {
                sb2.append("  - ").append(decorator2.toString((Object)t)).append('\n');
            }
            int reponse = UIHelper.askUser(I18n._((String)"observe.title.need.confirm", (Object[])new Object[0]), I18n._((String)"observe.message.table.rejetThon.will.delete.tailleThon", (Object[])new Object[]{sb.toString(), sb2.toString()}), 0, new Object[]{I18n._((String)"observe.choice.continue", (Object[])new Object[0]), I18n._((String)"observe.choice.cancel", (Object[])new Object[0])}, 0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("response : " + reponse));
            }
            boolean canContinue = false;
            switch (reponse) {
                case 0: {
                    canContinue = true;
                }
            }
            if (!canContinue) {
                return false;
            }
            this.ALL_TAILLES_TO_DELETE_ENTRY.setContextValue((JAXXContext)this.getUi(), tailleToDelete);
        }
        bean.setRejetThon(Boolean.valueOf(!objets.isEmpty()));
        for (CaptureThon capture : objets) {
            capture.setRejete(true);
            capture.setCalee(bean);
        }
        return true;
    }

    @Override
    protected void onUpdateFinalize(TopiaContext tx, Calee bean, Collection<CaptureThon> oldChilds) {
        List tailleToDelete;
        if (oldChilds != null && !oldChilds.isEmpty()) {
            for (CaptureThon captureThon : oldChilds) {
                if (captureThon.getRejete()) continue;
                bean.addCaptureThon(captureThon);
            }
        }
        if ((tailleToDelete = (List)this.ALL_TAILLES_TO_DELETE_ENTRY.getContextValue((JAXXContext)this.getUi())) != null && !tailleToDelete.isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Will remove " + tailleToDelete.size() + " obsolete tailleThon(s)."));
            }
            EchantillonThon echantillon = bean.getEchantillonThon(false);
            echantillon.getTailleThon().removeAll(tailleToDelete);
        }
    }

    @Override
    protected void onSelectedRowChanged(int editingRow, CaptureThon bean, boolean create) {
        NumberEditor requestFocus;
        RejetThonUI ui = this.getUi();
        CategoriePoids beanCategoriePoids = bean.getCategoriePoids();
        EspeceThon beanEspece = beanCategoriePoids == null ? null : beanCategoriePoids.getEspece();
        RaisonRejet beanRaisonRejet = bean.getRaisonRejet();
        if (log.isDebugEnabled()) {
            log.debug((Object)("selected categoriePoid " + beanCategoriePoids));
            log.debug((Object)("selected espece " + beanEspece));
            log.debug((Object)("selected raisonRejet " + beanRaisonRejet));
        }
        if (create) {
            ContentTableModel model = this.getTableModel();
            if (model.isCreate()) {
                bean.setSurLePont(Boolean.valueOf(true));
            }
            List<EspeceThon> availableEspeces = this.buildEspeceList(beanEspece, beanCategoriePoids);
            ui.getEspece().setData(availableEspeces);
            ui.getEspece().setSelectedItem(null);
            if (!model.isCreate()) {
                ui.getEspece().setSelectedItem((Object)beanEspece);
                ui.getCategoriePoids().setSelectedItem((Object)beanCategoriePoids);
                ui.getRaisonRejet().setSelectedItem((Object)beanRaisonRejet);
            }
            requestFocus = ui.getEspece();
        } else {
            ui.getEspece().setSelectedItem((Object)beanEspece);
            ui.getCategoriePoids().setData(Arrays.asList(beanCategoriePoids));
            ui.getCategoriePoids().setSelectedItem((Object)beanCategoriePoids);
            ui.getRaisonRejet().setData(Arrays.asList(beanRaisonRejet));
            ui.getRaisonRejet().setSelectedItem((Object)beanRaisonRejet);
            requestFocus = ui.getPoids();
        }
        requestFocus.requestFocus();
    }

    @Override
    protected void initTableUI(DefaultTableCellRenderer renderer) {
        JTable table = this.getUi().getTable();
        UIHelper.fixTableColumnWidth((JTable)table, (int)3, (int)75);
        UIHelper.fixTableColumnWidth((JTable)table, (int)4, (int)20);
        UIHelper.fixTableColumnWidth((JTable)table, (int)5, (int)50);
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n_((String)"observe.table.rejetThon.especeThon", (Object[])new Object[0]), I18n.n_((String)"observe.table.rejetThon.especeThon.tip", (Object[])new Object[0]), I18n.n_((String)"observe.table.rejetThon.categoriePoids", (Object[])new Object[0]), I18n.n_((String)"observe.table.rejetThon.categoriePoids.tip", (Object[])new Object[0]), I18n.n_((String)"observe.table.rejetThon.raisonRejet", (Object[])new Object[0]), I18n.n_((String)"observe.table.rejetThon.raisonRejet.tip", (Object[])new Object[0]), I18n.n_((String)"observe.table.rejetThon.poids", (Object[])new Object[0]), I18n.n_((String)"observe.table.rejetThon.poids.tip", (Object[])new Object[0]), I18n.n_((String)"observe.table.rejetThon.surLePont", (Object[])new Object[0]), I18n.n_((String)"observe.table.rejetThon.surLePont.tip", (Object[])new Object[0]), I18n.n_((String)"observe.table.rejetThon.commentaire", (Object[])new Object[0]), I18n.n_((String)"observe.table.rejetThon.commentaire.tip", (Object[])new Object[0])});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, EspeceThon.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, CategoriePoids.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, RaisonRejet.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)3, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)4, (TableCellRenderer)UIHelper.newStringTableCellRenderer((DefaultTableCellRenderer)renderer, (int)20, (boolean)false));
        UIHelper.setTableColumnRenderer((JTable)table, (int)5, (TableCellRenderer)UIHelper.newStringTableCellRenderer((DefaultTableCellRenderer)renderer, (int)10, (boolean)true));
    }

    protected void onEspeceChanged(CaptureThon bean, EspeceThon espece) {
        List<Object> data;
        CategoriePoids categoriePoids = null;
        if (espece == null) {
            data = Collections.emptyList();
        } else {
            List<CategoriePoids> availableCategories = this.buildCategoriePoidsList(espece);
            data = availableCategories;
            categoriePoids = bean.getCategoriePoids();
            if (categoriePoids != null && !availableCategories.contains(categoriePoids)) {
                categoriePoids = null;
            }
        }
        BeanComboBox<CategoriePoids> combo = this.getUi().getCategoriePoids();
        combo.setData(data);
        combo.setSelectedItem((Object)categoriePoids);
    }

    protected void onCategorieChanged(CaptureThon bean, CategoriePoids categoriePoids) {
        List<Object> data;
        RejetThonUI ui = this.getUi();
        RaisonRejet raisonRejet = null;
        if (categoriePoids == null) {
            data = Collections.emptyList();
        } else {
            List<RaisonRejet> raisonRejetList = this.buildRaisonRejetList(categoriePoids);
            if (log.isDebugEnabled()) {
                log.debug((Object)("new raisonRejet list " + raisonRejetList));
            }
            data = raisonRejetList;
            raisonRejet = bean.getRaisonRejet();
            if (raisonRejet != null && !raisonRejetList.contains(raisonRejet)) {
                raisonRejet = null;
            }
        }
        BeanComboBox<RaisonRejet> combo = ui.getRaisonRejet();
        combo.setData(data);
        combo.setSelectedItem(raisonRejet);
    }

    protected static Set<CategoriePoids> getCategoriePoidsUsed(ContentTableModel<Calee, CaptureThon> model) {
        List list = model.getColumnValues(1);
        HashSet<CategoriePoids> set = new HashSet<CategoriePoids>(list);
        list.clear();
        return set;
    }

    protected static Set<RaisonRejet> getRaisonRejetUsed(ContentTableModel<Calee, CaptureThon> model, CategoriePoids categoriePoids) {
        HashSet<RaisonRejet> set = new HashSet<RaisonRejet>();
        if (categoriePoids != null) {
            for (int i = 0; i < model.getRowCount(); ++i) {
                CaptureThon c = model.getValueAt(i);
                if (c == null || !categoriePoids.equals(c.getCategoriePoids()) || c.getRaisonRejet() == null) continue;
                set.add(c.getRaisonRejet());
            }
        }
        return set;
    }

    protected List<EspeceThon> buildEspeceList(EspeceThon espece, CategoriePoids categoriePoids) {
        List<CategoriePoids> categoriePoidsList = this.getAllCategories((JAXXContext)this.getUi());
        this.removeFullyUsedCategories(categoriePoidsList);
        if (categoriePoids != null) {
            categoriePoidsList.add(categoriePoids);
        }
        HashSet<EspeceThon> usedEspeces = new HashSet<EspeceThon>();
        for (CategoriePoids cat : categoriePoidsList) {
            usedEspeces.add(cat.getEspece());
        }
        ArrayList<EspeceThon> result = new ArrayList<EspeceThon>(usedEspeces);
        categoriePoidsList.clear();
        usedEspeces.clear();
        return result;
    }

    protected List<CategoriePoids> buildCategoriePoidsList(EspeceThon espece) {
        List<CategoriePoids> categoriePoidsList = this.getAllCategories((JAXXContext)this.getUi());
        Iterator<CategoriePoids> it = categoriePoidsList.iterator();
        while (it.hasNext()) {
            CategoriePoids poidse = it.next();
            if (espece.equals(poidse.getEspece())) continue;
            it.remove();
        }
        this.removeFullyUsedCategories(categoriePoidsList);
        return categoriePoidsList;
    }

    protected List<RaisonRejet> buildRaisonRejetList(CategoriePoids categoriePoids) {
        ContentTableModel model = this.getTableModel();
        ArrayList<RaisonRejet> raisonRejetList = new ArrayList<RaisonRejet>((Collection)this.ALL_RAISONS_REJET_ENTRY.getContextValue((JAXXContext)this.getUi()));
        for (int i = 0; i < model.getRowCount(); ++i) {
            CaptureThon c = (CaptureThon)model.getValueAt(i);
            if (c == null || c.getRaisonRejet() == null || !categoriePoids.equals(c.getCategoriePoids())) continue;
            raisonRejetList.remove(c.getRaisonRejet());
        }
        return raisonRejetList;
    }

    protected List<CategoriePoids> getAllCategories(JAXXContext context) {
        ArrayList<CategoriePoids> list = new ArrayList<CategoriePoids>((Collection)this.ALL_CATEGORIES_ENTRY.getContextValue(context));
        return list;
    }

    protected void removeFullyUsedCategories(List<CategoriePoids> categoriePoidsAvaillable) {
        ContentTableModel<Calee, CaptureThon> model = this.getTableModel();
        int nbRaisonRejet = ((List)this.ALL_RAISONS_REJET_ENTRY.getContextValue((JAXXContext)this.getUi())).size();
        for (CategoriePoids c : RejetThonUIHandler.getCategoriePoidsUsed(model)) {
            Set<RaisonRejet> raisonUsed = RejetThonUIHandler.getRaisonRejetUsed(model, c);
            if (raisonUsed.size() != nbRaisonRejet) continue;
            categoriePoidsAvaillable.remove(c);
        }
    }
}

