/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.tree;

import fr.ird.observe.ObserveContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.entities.Openable;
import fr.ird.observe.ui.tree.ObserveDataProvider;
import javax.swing.tree.DefaultTreeModel;
import jaxx.runtime.swing.nav.NavBridge;
import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.tree.NavTreeNode;
import jaxx.runtime.swing.nav.tree.NavTreeNodeChildLoador;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;

public class ObserveNode
extends NavTreeNode<ObserveNode> {
    private static final Log log = LogFactory.getLog(ObserveNode.class);
    public static long count;
    private static final long serialVersionUID = 1L;
    protected final boolean referentiel;
    protected Boolean open;
    protected transient DataService dataService;

    public ObserveNode(String id, boolean referentiel) {
        this(String.class, id, null, null, referentiel);
    }

    public ObserveNode(Class<?> internalClass, String id, boolean referentiel) {
        this(internalClass, id, null, null, referentiel);
    }

    public ObserveNode(Class<?> internalClass, String id, NavTreeNodeChildLoador<?, ?, ObserveNode> childLoador, boolean referentiel) {
        this(internalClass, id, null, childLoador, referentiel);
    }

    public ObserveNode(Class<?> internalClass, String id, String context, NavTreeNodeChildLoador<?, ?, ObserveNode> childLoador, boolean referentiel) {
        super(internalClass, id, context, childLoador);
        this.referentiel = referentiel;
        ++count;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creates a new node [" + count + "] " + (Object)((Object)this)));
        }
    }

    public boolean isDataNode() {
        return !this.referentiel;
    }

    public boolean isReferentielNode() {
        return this.referentiel;
    }

    public Boolean isOpen() {
        return this.open;
    }

    public void populateNode(NavBridge<DefaultTreeModel, ObserveNode> bridge, NavDataProvider provider, boolean populateChilds) {
        super.populateNode(bridge, provider, populateChilds);
        ObserveDataProvider oProvider = (ObserveDataProvider)provider;
        if (this.isStringNode()) {
            return;
        }
        if (this.isReferentielNode()) {
            return;
        }
        if (this.id == null) {
            return;
        }
        try {
            if (TopiaEntity.class.isAssignableFrom(this.internalClass)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("will load entity " + this.internalClass + " : " + this.id));
                }
                DataSource source = oProvider.getDataSource();
                TopiaEntity e = this.getDataService().loadEntity(source, this.id, true);
                if (Openable.class.isAssignableFrom(e.getClass())) {
                    this.open = ((Openable)e).isOpen();
                }
                return;
            }
        }
        catch (DataSourceException e) {
            throw new RuntimeException(e);
        }
        throw new IllegalStateException("Can not populate node [" + this.internalClass + ":" + this.id + "]");
    }

    protected DataService getDataService() {
        if (this.dataService == null) {
            this.dataService = ObserveContext.get().getDataService();
        }
        return this.dataService;
    }
}

