/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table.impl;

import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.entities.Calee;
import fr.ird.observe.entities.EchantillonThon;
import fr.ird.observe.entities.TailleThon;
import fr.ird.observe.entities.constants.CodeMesureEnum;
import fr.ird.observe.entities.constants.ModeSaisieEchantillonThonEnum;
import fr.ird.observe.entities.referentiel.EspeceThon;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.table.ContentTableModel;
import fr.ird.observe.ui.content.table.ContentTableUI;
import fr.ird.observe.ui.content.table.ContentTableUIHandler;
import fr.ird.observe.ui.content.table.ContentTableUIModel;
import fr.ird.observe.ui.content.table.impl.AbstractEchantillonThonUI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import jaxx.runtime.validator.BeanValidatorScope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;

public class EchantillonThonUIHandler
extends ContentTableUIHandler<EchantillonThon, TailleThon> {
    private static Log log = LogFactory.getLog(EchantillonThonUIHandler.class);
    protected final boolean capture;

    static ContentTableUIModel<EchantillonThon, TailleThon> newModel(ContentTableUI<EchantillonThon, TailleThon> ui) {
        return new ContentTableUIModel<EchantillonThon, TailleThon>(EchantillonThon.class, TailleThon.class, new String[]{"tailleThon", "commentaire"}, new String[]{"echantillonThon", "espece", "longueur", "longueurCalcule", "poids", "poidsCalcule", "effectif", "codeMesure", "modeSaisie"}, ui, ContentTableModel.newTableMeta(TailleThon.class, "espece", true), ContentTableModel.newTableMeta(TailleThon.class, "codeMesure", true), ContentTableModel.newTableMeta(TailleThon.class, "longueur", true), ContentTableModel.newTableMeta(TailleThon.class, "poids", true), ContentTableModel.newTableMeta(TailleThon.class, "effectif", false), ContentTableModel.newTableMeta(TailleThon.class, "poidsTotal", true));
    }

    public EchantillonThonUIHandler(ContentTableUI<EchantillonThon, TailleThon> ui, boolean capture) {
        super(ui);
        this.capture = capture;
    }

    @Override
    public AbstractEchantillonThonUI getUi() {
        return (AbstractEchantillonThonUI)super.getUi();
    }

    @Override
    protected EchantillonThon loadEditBean(ContentMode mode, DataContext dataContext, DataService dataService, DataSource dataSource) throws DataSourceException {
        Collection data;
        if (mode == ContentMode.UPDATE) {
            String caleeId = dataContext.getSelectedCaleeId();
            List especes = dataService.getAvailableEspeceForEchantillonThon(dataSource, caleeId, this.capture);
            this.getUi().getEspece().setData(especes);
        }
        String id = dataContext.getSelectedCaleeId();
        id = dataService.getEchantillonThonId(dataSource, id, this.capture);
        EchantillonThon editBean = (EchantillonThon)this.getBean();
        if (id == null) {
            this.getLoadBinder().copy(null, (Object)editBean, new String[0]);
            data = new ArrayList();
        } else {
            dataService.loadEditEntity(dataSource, id, this.getLoadExecutor());
            data = this.loadChilds(editBean);
        }
        this.getChildsUpdator().setChilds((TopiaEntity)editBean, data);
        this.getModel().setMode(mode);
        this.getUi().getTableModel().attachModel();
        return editBean;
    }

    @Override
    protected boolean prepareSave(EchantillonThon bean, List<TailleThon> objets) throws DataSourceException {
        if (bean.getTopiaId() == null) {
            String caleeId = this.getDataContext().getSelectedCaleeId();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will create " + bean + " for " + caleeId));
            }
            this.getDataService().create(this.getDataSource(), caleeId, (TopiaEntity)bean, null, this.getCreateExecutor());
        }
        for (TailleThon tailleThon : objets) {
            tailleThon.setEchantillonThon(bean);
        }
        return true;
    }

    @Override
    protected EchantillonThon onCreate(TopiaContext tx, Object parent, EchantillonThon editBean) throws TopiaException {
        Calee parentBean = (Calee)parent;
        EchantillonThon beanToSave = (EchantillonThon)ObserveDAOHelper.getEchantillonThonDAO((TopiaContext)tx).create(new Object[0]);
        beanToSave.setCapture(Boolean.valueOf(this.capture));
        editBean.setTopiaId(beanToSave.getTopiaId());
        editBean.setTopiaCreateDate(beanToSave.getTopiaCreateDate());
        editBean.setTopiaVersion(beanToSave.getTopiaVersion());
        parentBean.addEchantillonThon(beanToSave);
        return beanToSave;
    }

    @Override
    protected void onSelectedRowChanged(int editingRow, TailleThon bean, boolean create) {
        BeanComboBox<EspeceThon> requestFocus;
        ContentTableModel model = this.getTableModel();
        AbstractEchantillonThonUI ui = this.getUi();
        if (!model.isEditable()) {
            return;
        }
        EspeceThon espece = bean.getEspece();
        if (create) {
            if (model.isCreate()) {
                if (editingRow > 0) {
                    TailleThon editBean = (TailleThon)model.getValueAt(editingRow - 1);
                    espece = editBean.getEspece();
                }
                ui.getModeSaisieGroup().setSelectedValue(null);
                ui.getModeSaisieGroup().setSelectedValue((Object)ModeSaisieEchantillonThonEnum.byEffectif);
                ui.getCodeMesure().setSelectedItem(null);
                ui.getCodeMesure().setSelectedItem((Object)CodeMesureEnum.lf);
            }
            requestFocus = ui.getEspece();
        } else {
            requestFocus = ui.getEffectif();
            int modeSaisie = bean.getModeSaisie();
            ModeSaisieEchantillonThonEnum enumValue = ModeSaisieEchantillonThonEnum.valueOf((int)modeSaisie);
            ui.getModeSaisieGroup().setSelectedValue(null);
            ui.getModeSaisieGroup().setSelectedValue((Object)enumValue);
        }
        ui.getEspece().setSelectedItem(null);
        if (espece != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("espece to use " + espece));
            }
            ui.getEspece().setSelectedItem((Object)espece);
        }
        requestFocus.requestFocus();
    }

    @Override
    protected void initTableUI(DefaultTableCellRenderer renderer) {
        JTable table = this.getUi().getTable();
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n_((String)"observe.table.echantillonThon.especeThon"), I18n.n_((String)"observe.table.echantillonThon.especeThon.tip"), I18n.n_((String)"observe.table.echantillonThon.codeMesure"), I18n.n_((String)"observe.table.echantillonThon.codeMesure.tip"), I18n.n_((String)"observe.table.echantillonThon.longueur"), I18n.n_((String)"observe.table.echantillonThon.longueur.tip"), I18n.n_((String)"observe.table.echantillonThon.poidsIndividuel"), I18n.n_((String)"observe.table.echantillonThon.poidsIndividuel.tip"), I18n.n_((String)"observe.table.echantillonThon.effectif"), I18n.n_((String)"observe.table.echantillonThon.effectif.tip"), I18n.n_((String)"observe.table.echantillonThon.poidsTotal"), I18n.n_((String)"observe.table.echantillonThon.poidsTotal.tip")});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, EspeceThon.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newEnumTableCellRenderer((TableCellRenderer)renderer, CodeMesureEnum.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)3, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)4, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)5, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        boolean canEdit;
        ContentMode mode;
        block4: {
            mode = super.getContentMode(dataContext);
            if (mode != ContentMode.UPDATE) {
                return mode;
            }
            canEdit = false;
            try {
                String caleeId = this.getDataContext().getSelectedCaleeId();
                canEdit = this.getDataService().canUseEchantillonThon(this.getDataSource(), caleeId, this.capture);
            }
            catch (DataSourceException e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)e);
            }
        }
        if (!canEdit) {
            mode = ContentMode.READ;
            EchantillonThonUIHandler.addMessage(this.getUi(), BeanValidatorScope.INFO, this.getEntityLabel(Calee.class), this.capture ? I18n._((String)"observe.message.calee.no.captureThon") : I18n._((String)"observe.message.calee.no.rejetThon"));
        }
        return mode;
    }

    public void updateModeSaisie(ModeSaisieEchantillonThonEnum newMode) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Change mode saisie to " + newMode));
        }
        if (newMode == null) {
            return;
        }
        AbstractEchantillonThonUI ui = this.getUi();
        boolean createMode = ui.getTableModel().isCreate();
        TailleThon editBean = ui.getTableEditBean();
        switch (newMode) {
            case byEffectif: {
                ui.getPoids().setEnabled(false);
                ui.getEffectif().setEnabled(true);
                if (!createMode) break;
                editBean.setPoids(null);
                editBean.setEffectif(null);
                break;
            }
            case byIndividu: {
                ui.getPoids().setEnabled(true);
                ui.getEffectif().setEnabled(false);
                if (!createMode) break;
                editBean.setEffectif(Integer.valueOf(1));
            }
        }
        if (createMode) {
            editBean.setModeSaisie(newMode.ordinal());
        }
    }
}

