/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.impl;

import fr.ird.observe.BinderService;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.entities.Activite;
import fr.ird.observe.entities.Calee;
import fr.ird.observe.entities.referentiel.SystemeObserve;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIHandler;
import fr.ird.observe.ui.content.impl.SystemeObserveUI;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ListSelectionModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.BinderModelBuilder;

public class SystemeObserveUIHandler
extends ContentUIHandler<Activite> {
    private static Log log = LogFactory.getLog(SystemeObserveUIHandler.class);

    public SystemeObserveUIHandler(SystemeObserveUI ui) {
        super(ui, DataContextType.Activite, null);
    }

    public SystemeObserveUI getUi() {
        return (SystemeObserveUI)super.getUi();
    }

    @Override
    protected TopiaEntityBinder<Activite> createOpeningBinder(BinderService binderService) {
        String binderName = this.getClass().getName() + "-open";
        TopiaEntityBinder r = binderService.getTopiaBinder(Activite.class, binderName);
        if (r == null) {
            BinderModelBuilder builder = binderService.newBinderBuilder(Activite.class, new String[]{"systemeObserve", "calee", "commentaire", "distanceSystemeObserve"});
            r = binderService.registerTopiaBinder(Activite.class, builder, binderName);
        }
        return r;
    }

    @Override
    protected boolean computeCanWrite(DataSource source) {
        return source.canWriteData();
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        if (dataContext.isSelectedOpen(Activite.class)) {
            return ContentMode.UPDATE;
        }
        this.addInfoMessage(I18n._((String)"observe.message.activite.not.open"));
        return ContentMode.READ;
    }

    @Override
    public void openUI() throws Exception {
        super.openUI();
        String activiteId = this.getSelectedParentId();
        if (log.isInfoEnabled()) {
            log.info((Object)("activiteId = " + activiteId));
        }
        ContentMode mode = this.computeContentMode();
        this.getDataService().loadEditEntity(this.getDataSource(), activiteId, this.getLoadExecutor());
        this.getModel().setMode(mode);
        if (mode == ContentMode.UPDATE) {
            this.getUi().startEdit(null);
        }
    }

    @Override
    public void startEditUI(String ... binding) {
        this.addInfoMessage(I18n._((String)"observe.message.updating.activite"));
        super.startEditUI(binding);
    }

    @Override
    protected boolean doSave(Activite bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<Activite> binder) throws Exception {
        dataService.update(dataSource, null, (TopiaEntity)bean, this.getUpdateExecutor());
        return true;
    }

    @Override
    protected Activite onUpdate(TopiaContext tx, Object parentBean, Activite beanToSave) throws TopiaException {
        Activite bean = (Activite)this.getBean();
        boolean needUpdateCalee = false;
        int newTypeBanc = bean.getTypeBanc();
        Calee calee = bean.getCalee();
        if (calee != null) {
            Integer oldTypeBanc = calee.getTypeBanc();
            needUpdateCalee = oldTypeBanc == null || newTypeBanc != oldTypeBanc;
        }
        this.getLoadBinder().copyExcluding(this.getBean(), (Object)beanToSave, new String[]{"calee"});
        if (needUpdateCalee) {
            beanToSave.getCalee().setTypeBanc(Integer.valueOf(newTypeBanc));
        }
        return beanToSave;
    }

    @Override
    protected void afterSave(boolean refresh) {
        super.afterSave(refresh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectSystemeObserve(Activite bean, Object[] selected) {
        boolean update;
        boolean bl = update = selected.length != bean.sizeSystemeObserve();
        if (!update && selected.length > 0) {
            List list = bean.getSystemeObserve();
            for (Object o : selected) {
                if (list.contains(o)) continue;
                update = true;
                break;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(selected.length + " do update ? " + update));
        }
        if (update) {
            ListSelectionModel selectionModel = this.getUi().getSystemeObserve().getSelectionModel();
            selectionModel.setValueIsAdjusting(true);
            try {
                ArrayList<SystemeObserve> newList = new ArrayList<SystemeObserve>(selected.length);
                for (Object o : selected) {
                    newList.add((SystemeObserve)o);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("update operations " + newList.size()));
                }
                bean.setSystemeObserve(newList);
            }
            finally {
                selectionModel.setValueIsAdjusting(false);
            }
        }
    }
}

