/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.usage;

import fr.ird.observe.DecoratorService;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.entities.referentiel.ReferentielEntity;
import fr.ird.observe.ui.usage.UsagesUI;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import jaxx.runtime.decorator.Decorator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntity;

public class UsagesUIHandler {
    private static final Log log = LogFactory.getLog(UsagesUIHandler.class);

    public void initUI(UsagesUI ui, String message, String message2, String message3, Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> usages) {
        this.cleanUI(ui);
        ui.getMessage().setText(I18n._((String)message));
        if (message2 != null) {
            ui.getMessage2().setVisible(true);
            ui.getMessage2().setText(message2);
        }
        if (message3 != null) {
            ui.getMessage3().setVisible(true);
            ui.getMessage3().setText(message3);
        }
        if (usages.isEmpty()) {
            ui.getUsages().add(new JLabel(I18n._((String)"observe.message.no.usage.for.entity")));
        } else {
            DecoratorService dService = ObserveContext.get().getDecoratorService();
            for (Map.Entry<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> entry : usages.entrySet()) {
                Class<? extends TopiaEntity> type = entry.getKey();
                List<? extends TopiaEntity> entitites = entry.getValue();
                String typeTitle = dService.getEntityLabel(type);
                typeTitle = I18n._((String)typeTitle);
                this.addUsages(ui, type, entitites, typeTitle);
            }
        }
    }

    public void cleanUI(UsagesUI ui) {
        ui.getUsages().removeAll();
        ui.getMessage().setText(null);
        ui.getMessage2().setText(null);
        ui.getMessage2().setVisible(false);
        ui.getMessage3().setText(null);
        ui.getMessage3().setVisible(false);
    }

    protected void addUsages(UsagesUI ui, Class<? extends TopiaEntity> type, List<? extends TopiaEntity> entitites, String typeTitle) {
        JScrollPane pane = new JScrollPane();
        pane.setHorizontalScrollBarPolicy(30);
        pane.setVerticalScrollBarPolicy(20);
        pane.setMinimumSize(new Dimension(300, 30));
        int size = entitites.size();
        String typetitle = ReferentielEntity.class.isAssignableFrom(type) ? I18n.n_((String)"observe.label.usage.referentiel.title") : I18n.n_((String)"observe.label.usage.data.title");
        typetitle = I18n._((String)typetitle, (Object[])new Object[]{typeTitle, size});
        pane.setColumnHeaderView(new JLabel(typetitle));
        ArrayList<String> data = new ArrayList<String>(size);
        Decorator decorator = ObserveContext.get().getDecorator(type);
        if (decorator == null) {
            throw new NullPointerException("could not find decorator for type " + type);
        }
        for (TopiaEntity topiaEntity : entitites) {
            try {
                String s = decorator.toString((Object)topiaEntity);
                data.add(s);
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)e);
            }
        }
        JList<Object> l = new JList<Object>(data.toArray());
        pane.setViewportView(l);
        ui.getUsages().add(pane);
    }
}

