/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.gps;

import fr.ird.observe.ObserveContext;
import fr.ird.observe.entities.Activite;
import fr.ird.observe.gps.GPSPoint;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import jaxx.runtime.decorator.Decorator;
import org.nuiton.i18n.I18n;

public class GPSActiviteTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    protected static final String[] COLUMN_NAMES = new String[]{I18n.n_((String)"observe.synchro.common.select"), I18n.n_((String)"observe.synchro.common.activite"), I18n.n_((String)"observe.synchro.common.quadrant"), I18n.n_((String)"observe.synchro.common.latitude"), I18n.n_((String)"observe.synchro.common.longitude"), I18n.n_((String)"observe.synchro.common.vitesse")};
    protected static final Class<?>[] COLUMN_CLASSES = new Class[]{Boolean.class, Activite.class, Integer.class, Float.class, Float.class, Float.class};
    protected List<Map.Entry<Activite, GPSPoint>> entries;
    protected Set<Integer> selected = new HashSet<Integer>();
    protected boolean selectAll;
    protected Decorator<?> decorator = ObserveContext.get().getDecorator(Activite.class, "gps-activite");

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_CLASSES[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    public void init(Map<Activite, GPSPoint> entries) {
        this.entries = new ArrayList<Map.Entry<Activite, GPSPoint>>(entries.entrySet());
        this.selected.clear();
        this.setSelectAll(true);
    }

    public int[] getSelected() {
        int[] result = new int[this.selected.size()];
        int i = 0;
        for (Integer index : this.selected) {
            result[i++] = index;
        }
        return result;
    }

    public boolean hasSelection() {
        return !this.selected.isEmpty();
    }

    @Override
    public int getRowCount() {
        return this.entries == null ? 0 : this.entries.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_CLASSES.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object value = null;
        switch (columnIndex) {
            case 0: {
                value = this.selected.contains(rowIndex);
                break;
            }
            case 1: {
                value = this.getActiviteAt(rowIndex);
                break;
            }
            case 2: {
                GPSPoint p = this.getGPSPointAt(rowIndex);
                value = p.getQuadrant();
                break;
            }
            case 3: {
                GPSPoint p = this.getGPSPointAt(rowIndex);
                value = Float.valueOf(Math.abs(p.getLatitude().floatValue()));
                break;
            }
            case 4: {
                GPSPoint p = this.getGPSPointAt(rowIndex);
                value = Float.valueOf(Math.abs(p.getLongitude().floatValue()));
                break;
            }
            case 5: {
                GPSPoint p = this.getGPSPointAt(rowIndex);
                value = p.getVitesse();
                break;
            }
            default: {
                throw new IllegalStateException("can not get value for row " + rowIndex + ", col " + columnIndex);
            }
        }
        return value;
    }

    public String getTextValueAt(int rowIndex, int columnIndex) {
        Object value = null;
        String text = "";
        switch (columnIndex) {
            case 0: {
                break;
            }
            case 1: {
                value = this.getValueAt(rowIndex, columnIndex);
                text = this.decorator == null ? value + "" : this.decorator.toString(value);
                break;
            }
            case 2: {
                value = this.getValueAt(rowIndex, columnIndex);
                if (value == null || (Integer)value == 0) {
                    text = I18n._((String)"observe.common.undefined");
                    break;
                }
                text = I18n._((String)("observe.common.quadrant" + value));
                break;
            }
            case 3: {
                value = this.getValueAt(rowIndex, columnIndex);
                if (value == null || ((Float)value).floatValue() == 0.0f) {
                    text = I18n._((String)"observe.common.undefined");
                    break;
                }
                text = Math.abs(((Float)value).floatValue()) + "";
                break;
            }
            case 4: {
                value = this.getValueAt(rowIndex, columnIndex);
                if (value == null || ((Float)value).floatValue() == 0.0f) {
                    text = I18n._((String)"observe.common.undefined");
                    break;
                }
                text = Math.abs(((Float)value).floatValue()) + "";
                break;
            }
            case 5: {
                value = this.getValueAt(rowIndex, columnIndex);
                if (value == null || ((Float)value).floatValue() == 0.0f) {
                    text = I18n._((String)"observe.common.undefined");
                    break;
                }
                text = value + "";
                break;
            }
            case -2: {
                value = this.getActiviteAt(rowIndex).getQuadrant();
                if (value == null || (Integer)value == 0) {
                    text = I18n._((String)"observe.common.undefined");
                    break;
                }
                text = I18n._((String)("observe.common.quadrant" + value));
                break;
            }
            case -3: {
                value = this.getActiviteAt(rowIndex).getLatitude();
                if (value == null || ((Float)value).floatValue() == 0.0f) {
                    text = I18n._((String)"observe.common.undefined");
                    break;
                }
                text = Math.abs(((Float)value).floatValue()) + "";
                break;
            }
            case -4: {
                value = this.getActiviteAt(rowIndex).getLongitude();
                if (value == null || ((Float)value).floatValue() == 0.0f) {
                    text = I18n._((String)"observe.common.undefined");
                    break;
                }
                text = Math.abs(((Float)value).floatValue()) + "";
                break;
            }
            case -5: {
                value = this.getActiviteAt(rowIndex).getVitesseBateau();
                if (value == null || ((Float)value).floatValue() == 0.0f) {
                    text = I18n._((String)"observe.common.undefined");
                    break;
                }
                text = value + "";
                break;
            }
            default: {
                throw new IllegalStateException("can not get value for column " + columnIndex);
            }
        }
        return text;
    }

    public Activite getActiviteAt(int rowIndex) {
        return this.entries.get(rowIndex).getKey();
    }

    public GPSPoint getGPSPointAt(int rowIndex) {
        return this.entries.get(rowIndex).getValue();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            Boolean value = (Boolean)aValue;
            if (value.booleanValue()) {
                this.selected.add(rowIndex);
                if (this.selected.size() == this.getRowCount()) {
                    this.selectAll = true;
                }
            } else {
                this.selected.remove(rowIndex);
                if (this.selected.isEmpty()) {
                    this.selectAll = false;
                }
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    public boolean isSelectAll() {
        return this.selectAll;
    }

    public void setSelectAll(boolean selectAll) {
        this.selectAll = selectAll;
        if (selectAll) {
            int max = this.getRowCount();
            for (int i = 0; i < max; ++i) {
                this.selected.add(i);
            }
        } else {
            this.selected.clear();
        }
        this.fireTableDataChanged();
    }

    public void clear() {
        this.selected.clear();
        if (this.entries != null) {
            this.entries.clear();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.clear();
    }
}

