/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.access;

import com.healthmarketscience.jackcess.Database;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.referentiel.Ocean;
import fr.ird.observe.entities.referentiel.Programme;
import fr.ird.observe.ui.admin.AdminActionModel;
import fr.ird.observe.ui.admin.AdminStep;
import fr.ird.observe.ui.admin.access.AccessDataSource;
import fr.ird.observe.ui.admin.access.AccessHitModel;
import fr.ird.observe.ui.admin.access.EntityBuilder;
import fr.ird.observe.ui.admin.access.metas.MareeMeta;
import java.io.File;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AccessModel
extends AdminActionModel {
    private static final Log log = LogFactory.getLog(AccessModel.class);
    public static final String PROPERTY_IMPORT_FILE = "importFile";
    public static final String PROPERTY_OUTPUT_FILE = "outputFile";
    public static final String PROPERTY_SELECTED_PROGRAMME = "selectedProgramme";
    public static final String PROPERTY_SELECTED_OCEAN = "selectedOcean";
    protected File importFile = new File("");
    protected File outputFile = new File("");
    protected Database accessConnexion;
    protected DataSource tmpSource;
    protected DataSource centralSource;
    protected AccessDataSource accessDataSource;
    protected AccessHitModel hits = new AccessHitModel();
    protected AccessHitModel totalHits = new AccessHitModel();
    protected EntityBuilder builder;
    protected Programme selectedProgramme;
    protected Ocean selectedOcean;

    public AccessModel() {
        super(AdminStep.VALIDATE);
    }

    public File getImportFile() {
        return this.importFile;
    }

    public void setImportFile(File importFile) {
        File oldValue = this.importFile;
        this.importFile = importFile;
        this.firePropertyChange(PROPERTY_IMPORT_FILE, oldValue, importFile);
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public AccessHitModel getHits() {
        return this.hits;
    }

    public AccessHitModel getTotalHits() {
        return this.totalHits;
    }

    public Programme getSelectedProgramme() {
        return this.selectedProgramme;
    }

    public Ocean getSelectedOcean() {
        return this.selectedOcean;
    }

    public void initAccessDataSource() throws Exception {
        if (this.accessConnexion == null) {
            throw new IllegalStateException("Required a access connexion");
        }
        this.accessDataSource = new AccessDataSource(this.accessConnexion);
    }

    public EntityBuilder getBuilder() {
        return this.builder;
    }

    public void setBuilder(EntityBuilder builder) {
        this.builder = builder;
    }

    public void setOutputFile(File outputFile) {
        File oldValue = this.outputFile;
        this.outputFile = outputFile;
        this.firePropertyChange(PROPERTY_OUTPUT_FILE, oldValue, outputFile);
    }

    public void setSelectedProgramme(Programme selectedProgramme) {
        Programme oldValue = this.selectedProgramme;
        this.selectedProgramme = selectedProgramme;
        this.firePropertyChange(PROPERTY_SELECTED_PROGRAMME, oldValue, selectedProgramme);
    }

    public void setSelectedOcean(Ocean selectedOcean) {
        Ocean oldValue = this.selectedOcean;
        this.selectedOcean = selectedOcean;
        this.firePropertyChange(PROPERTY_SELECTED_OCEAN, oldValue, selectedOcean);
    }

    public Database getAccessConnexion() {
        return this.accessConnexion;
    }

    public void setAccessConnexion(Database accessConnexion) {
        this.accessConnexion = accessConnexion;
    }

    public DataSource getTmpSource() {
        return this.tmpSource;
    }

    public DataSource getCentralSource() {
        return this.centralSource;
    }

    public AccessDataSource getAccessDataSource() {
        return this.accessDataSource;
    }

    public void setTmpSource(DataSource tmpSource) {
        this.tmpSource = tmpSource;
    }

    public void setCentralSource(DataSource centralSource) {
        this.centralSource = centralSource;
    }

    public Maree[] getAccessMarees() throws Exception {
        AccessDataSource db = this.getAccessDataSource();
        MareeMeta meta = db.getMeta(MareeMeta.class);
        Maree[] result = (Maree[])db.loadEntities(meta);
        return result;
    }

    public String getDefaultBackupFilename() {
        return String.format("import-access-%1$tF--%1$tk-%1$tM-%1$tS.sql.gz", new Date());
    }

    public void destroy() {
        super.destroy();
        if (this.accessConnexion != null) {
            block8: {
                try {
                    this.accessConnexion.close();
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block8;
                    log.error((Object)"Could not close access connexion", (Throwable)e);
                }
            }
            this.accessConnexion = null;
        }
        if (this.accessDataSource != null) {
            this.accessDataSource.destroy();
            this.accessDataSource = null;
        }
        if (this.tmpSource != null) {
            block9: {
                if (this.tmpSource.isOpen()) {
                    try {
                        this.tmpSource.doClose(false);
                    }
                    catch (Exception e) {
                        if (!log.isErrorEnabled()) break block9;
                        log.error((Object)("Could not close temporary " + this.tmpSource.getLabel()), (Throwable)e);
                    }
                }
            }
            this.tmpSource = null;
        }
        this.hits.clear();
        this.totalHits.clear();
    }
}

