/*
 * #%L
 * Refcomp :: services
 * 
 * $Id: RefcompServiceActionDef.java 173 2011-05-27 08:32:56Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.3/refcomp-services/src/main/java/fr/inra/refcomp/services/RefcompServiceActionDef.java $
 * %%
 * Copyright (C) 2010 - 2011 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.services;

import org.nuiton.util.ApplicationConfig;

import static org.nuiton.i18n.I18n._;

/**
 * User: couteau
 * Date: 01/02/11
 */
public enum RefcompServiceActionDef implements ApplicationConfig.ActionDef {

    REINDEX_SOLR(
            RefcompServiceAction.class.getName() + "#reIndexSolr",
            _("refcomp.service.config.reIndexSolr.description"),
            "--reIndexSolr");

    protected String action;

    protected String description;

    protected String[] aliases;

    private RefcompServiceActionDef(String action, String description, String... aliases) {
        this.action = action;
        this.description = description;
        this.aliases = aliases;
    }

    @Override
    public String getAction() {
        return action;
    }

    public String getDescription() {
        return action;
    }

    @Override
    public String[] getAliases() {
        return aliases;
    }
}