/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.tools.osb.mbean;

import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.tools.osb.mbean.ObjStoreTypeBean;
import com.arjuna.ats.arjuna.tools.osb.util.JMXServer;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.management.MBeanException;
import javax.management.ObjectInstance;
import javax.management.OperationsException;

public class ObjStoreBean
extends ObjStoreTypeBean {
    private ObjectStore store;
    private int id;
    private static ObjStoreBean localStore;

    public static ObjStoreTypeBean getObjectStoreBrowserBean() throws OperationsException, MBeanException, InterruptedException, IOException {
        if (localStore == null) {
            localStore = (ObjStoreBean)ObjStoreBean.getObjectStoreBrowserBean(0, arjPropertyManager.getObjectStoreEnvironmentBean().getObjectStoreDir());
        }
        return localStore;
    }

    public static ObjStoreTypeBean getObjectStoreBrowserBean(int id, String storeDir) throws OperationsException, MBeanException, InterruptedException, IOException {
        ObjStoreBean sbean = new ObjStoreBean(id, storeDir);
        sbean.register();
        return sbean;
    }

    public ObjStoreBean() {
    }

    private List<String> getStoreNames() {
        File osf = new File(this.store.storeDir());
        List<String> storeNames = new ArrayList<String>();
        if (osf.exists()) {
            storeNames = Arrays.asList(osf.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return new File(dir, name).isDirectory();
                }
            }));
        }
        return storeNames;
    }

    public ObjStoreBean(int id, String storeLocation) {
        super(null, "/", "root");
        this.id = id;
        if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
            tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.tools.osb.mbean.ObjStoreBean.m_1", new Object[]{storeLocation});
        }
        this.store = this.getObjectStore(storeLocation, null);
    }

    @Override
    public String getObjectName() {
        return "jboss.jta:type=ObjectStore,id=" + this.id;
    }

    @Override
    public ObjectStore getStore() {
        return this.store;
    }

    @Override
    public ObjectInstance register() {
        if (arjPropertyManager.getObjectStoreEnvironmentBean().isJmxEnabled()) {
            ArrayList<ObjStoreTypeBean> beans = new ArrayList<ObjStoreTypeBean>();
            ObjectInstance oi = JMXServer.getAgent().registerMBean(this);
            if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
                tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.tools.osb.mbean.ObjStoreBean.m_4", new Object[]{arjPropertyManager.getCoordinatorEnvironmentBean().getActionStore()});
            }
            for (String storeName : this.getStoreNames()) {
                this.allTypes(this, storeName, beans);
                if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
                    tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.tools.osb.mbean.ObjStoreBean.m_5", new Object[]{storeName, this.store.storeDir()});
                }
                for (ObjStoreTypeBean bean : beans) {
                    bean.register();
                }
                this.registeredBeans.addAll(beans);
                beans.clear();
            }
            super.register();
            return oi;
        }
        return null;
    }

    @Override
    public boolean unregister() {
        return super.unregister();
    }

    public ObjectStore getObjectStore(String storeDir, String storeName) {
        arjPropertyManager.getObjectStoreEnvironmentBean().setObjectStoreDir(storeDir);
        String storeImple = arjPropertyManager.getCoordinatorEnvironmentBean().getActionStore();
        arjPropertyManager.getObjectStoreEnvironmentBean().setLocalOSRoot(storeName);
        try {
            Class<?> osImple = Class.forName(storeImple);
            return (ObjectStore)osImple.newInstance();
        }
        catch (Exception e) {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.tools.osb.mbean.ObjStoreBean.m_2", new Object[]{e});
            }
            return null;
        }
    }

    public void allTypes(ObjStoreTypeBean parent, String storeName, Collection<ObjStoreTypeBean> names) {
        block5: {
            InputObjectState types = new InputObjectState();
            try {
                if (!this.getObjectStore(this.store.storeDir(), storeName).allTypes(types)) break block5;
                try {
                    String theName;
                    while ((theName = types.unpackString()).length() != 0) {
                        names.add(new ObjStoreTypeBean(parent, storeName, theName));
                    }
                }
                catch (IOException e) {
                }
            }
            catch (ObjectStoreException e) {
                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block5;
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.tools.osb.mbean.ObjStoreBean.m_3", new Object[]{e});
            }
        }
    }

    public static void main(String[] args) throws OperationsException, MBeanException, InterruptedException, IOException {
        String[] storeLocations = new String[]{"/home/mmusgrov/source/as/trunk/build/output/jboss-6.0.0-SNAPSHOT/server/all/data/tx-object-store"};
        ObjStoreBean[] browsers = new ObjStoreBean[storeLocations.length];
        for (int i = 0; i < storeLocations.length; ++i) {
            browsers[i] = new ObjStoreBean(i, storeLocations[i]);
            browsers[i].register();
        }
        Thread.sleep(24000000L);
    }
}

