/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator.xwork2;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.validator.AbstractNuitonValidatorProvider;
import org.nuiton.validator.NuitonValidator;
import org.nuiton.validator.NuitonValidatorModel;
import org.nuiton.validator.NuitonValidatorScope;
import org.nuiton.validator.xwork2.XWork2NuitonValidator;
import org.nuiton.validator.xwork2.XWork2ValidatorUtil;

public class XWork2NuitonValidatorProvider
extends AbstractNuitonValidatorProvider {
    public static final String PROVIDER_NAME = "xwork2";
    private static final Log log = LogFactory.getLog(XWork2NuitonValidatorProvider.class);

    public XWork2NuitonValidatorProvider() {
        super(PROVIDER_NAME);
    }

    @Override
    public <O> NuitonValidatorModel<O> newModel(Class<O> type, String context, NuitonValidatorScope ... scopes) {
        if (scopes.length == 0) {
            scopes = NuitonValidatorScope.values();
        }
        Map<NuitonValidatorScope, String[]> fields = XWork2ValidatorUtil.detectFields(type, context, scopes);
        EnumSet<NuitonValidatorScope> scopeSet = EnumSet.noneOf(NuitonValidatorScope.class);
        scopeSet.addAll(Arrays.asList(scopes));
        return new NuitonValidatorModel<O>(type, context, scopeSet, fields);
    }

    public <O> XWork2NuitonValidator<O> newValidator(NuitonValidatorModel<O> model) {
        return new XWork2NuitonValidator<O>(model);
    }

    @Override
    public SortedSet<NuitonValidator<?>> detectValidators(File sourceRoot, Pattern contextFilter, NuitonValidatorScope[] scopes, Class<?> ... types) {
        if (scopes == null) {
            scopes = NuitonValidatorScope.values();
        }
        TreeSet result = new TreeSet(new ValidatorComparator());
        for (Class<?> c : types) {
            File dir = this.getClassDir(sourceRoot, c);
            if (!dir.exists()) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("skip none existing directory " + dir));
                continue;
            }
            Object[] contexts = this.getContexts(c, dir);
            if (log.isDebugEnabled()) {
                log.debug((Object)("contexts : " + Arrays.toString(contexts)));
            }
            if (contexts.length <= 0) continue;
            Object[] realContexts = this.getContextsWithoutScopes((String[])contexts);
            if (log.isDebugEnabled()) {
                log.debug((Object)("realContexts : " + Arrays.toString(realContexts)));
            }
            if (contextFilter != null) {
                realContexts = this.getFilterContexts(contextFilter, (String[])realContexts);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("filterContexts : " + Arrays.toString(realContexts)));
                }
            }
            for (Object context : realContexts) {
                NuitonValidator<?> validator = this.getValidator(c, (String)(((String)context).isEmpty() ? null : context), scopes);
                if (validator == null) continue;
                result.add(validator);
            }
        }
        return result;
    }

    protected <O> NuitonValidator<O> getValidator(Class<O> klass, String context, NuitonValidatorScope ... scopes) {
        NuitonValidatorModel<O> model = this.newModel(klass, context, scopes);
        NuitonValidator valitator = this.newValidator((NuitonValidatorModel)model);
        Set<NuitonValidatorScope> realScopes = ((XWork2NuitonValidator)valitator).getEffectiveScopes();
        if (realScopes.isEmpty()) {
            valitator = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)(klass + " : validator skip (no scopes detected)"));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)(klass + " : keep validator " + valitator));
        }
        return valitator;
    }

    protected File getClassDir(File sourceRoot, Class<?> clazz) {
        String path = clazz.getPackage().getName();
        path = path.replaceAll("\\.", File.separator);
        File dir = new File(sourceRoot, path);
        return dir;
    }

    protected String[] getContexts(Class<?> clazz, File dir) {
        String[] files;
        TreeSet<String> result = new TreeSet<String>();
        ValidatorFilenameFilter filter = new ValidatorFilenameFilter(clazz);
        if (log.isDebugEnabled()) {
            log.debug((Object)("dir : " + dir));
        }
        for (String file : files = dir.list(filter)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("file " + file));
            }
            String context = file.substring(filter.prefix.length(), file.length() - "-validation.xml".length());
            if (log.isDebugEnabled()) {
                log.debug((Object)("detect " + clazz.getSimpleName() + " context [" + context + "]"));
            }
            result.add(context);
        }
        return result.toArray(new String[result.size()]);
    }

    protected String[] getContextsWithoutScopes(String[] contexts) {
        TreeSet<String> result = new TreeSet<String>();
        NuitonValidatorScope[] scopes = NuitonValidatorScope.values();
        for (String context : contexts) {
            for (NuitonValidatorScope scope : scopes) {
                String realContext;
                String scopeName = scope.name().toLowerCase();
                if (!context.endsWith(scopeName)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("detect context : " + context));
                }
                if ((realContext = context.substring(0, context.length() - scopeName.length())).endsWith("-")) {
                    realContext = realContext.substring(0, realContext.length() - 1);
                }
                result.add(realContext);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    protected String[] getFilterContexts(Pattern contextFilter, String[] realContexts) {
        ArrayList<String> result = new ArrayList<String>();
        for (String c : realContexts) {
            Matcher m = contextFilter.matcher(c);
            if (!m.matches()) continue;
            result.add(c);
        }
        return result.toArray(new String[result.size()]);
    }

    protected static class ValidatorComparator
    implements Comparator<NuitonValidator<?>> {
        protected ValidatorComparator() {
        }

        @Override
        public int compare(NuitonValidator<?> o1, NuitonValidator<?> o2) {
            NuitonValidatorModel model1 = ((XWork2NuitonValidator)o1).getModel();
            NuitonValidatorModel model2 = ((XWork2NuitonValidator)o2).getModel();
            String contextName1 = model1.getType().getSimpleName() + "-" + (model1.getContext() == null ? "" : model1.getContext());
            String contextName2 = model2.getType().getSimpleName() + "-" + (model2.getContext() == null ? "" : model2.getContext());
            return contextName1.compareTo(contextName2);
        }
    }

    protected static class ValidatorFilenameFilter
    implements FilenameFilter {
        protected static final String SUFFIX = "-validation.xml";
        protected Class<?> clazz;
        protected String prefix;

        public ValidatorFilenameFilter(Class<?> clazz) {
            this.clazz = clazz;
            this.prefix = clazz.getSimpleName() + "-";
        }

        @Override
        public boolean accept(File dir, String name) {
            boolean result = name.endsWith(SUFFIX);
            if (result) {
                result = name.startsWith(this.prefix);
            }
            return result;
        }
    }
}

