/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.services;

import gnu.cajo.invoke.Remote;
import gnu.cajo.utils.ItemServer;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyConfigOption;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.services.WikittyServiceDelegator;

public class WikittyServiceCajoServer
extends WikittyServiceDelegator {
    private static Log log = LogFactory.getLog(WikittyServiceCajoServer.class);
    protected int port = 80;
    protected String path = "";

    public WikittyServiceCajoServer(ApplicationConfig config, WikittyService ws) {
        try {
            this.setDelegate(ws);
            String urlString = config.getOption(WikittyConfigOption.WIKITTY_SERVER_URL.getKey());
            if (urlString != null && !"".equals(urlString)) {
                URL url = new URL(urlString);
                if (-1 != url.getPort()) {
                    this.port = url.getPort();
                }
                if (null != url.getPath()) {
                    this.path = url.getPath();
                }
            }
            if ("".equals(this.path)) {
                this.path = "WikittyService";
            } else if (this.path.startsWith("/")) {
                this.path = this.path.substring(1);
            }
            Remote.config(null, (int)this.port, null, (int)0);
            ItemServer.bind((Object)this, (String)this.path);
            log.info((Object)String.format("The server is running on %s:%s/%s", Remote.getDefaultServerHost(), Remote.getDefaultServerPort(), this.path));
        }
        catch (Exception eee) {
            throw new WikittyException("Can't start wikitty server", eee);
        }
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public void stop() {
        ItemServer.unbind((String)this.path);
    }
}

