/*
 * *##% 
 * Wao :: Web Interface
 * Copyright (C) 2009 - 2010 Ifremer
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */

package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.ui.base.WaoPage;
import fr.ifremer.wao.ui.components.Layout;
import fr.ifremer.wao.ui.data.BusinessUtils;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.ExceptionReporter;
import org.slf4j.Logger;

/**
 * ExceptionReport
 *
 * Created: 5 janv. 2010
 *
 * @author fdesbois
 * @version $Revision: 409 $
 *
 * Mise a jour: $Date: 2010-04-01 20:21:22 +0200 (jeu., 01 avril 2010) $
 * par : $Author$
 */
public class ExceptionReport implements ExceptionReporter, WaoPage {
/**
     * No restriction to display this page.
     *
     * @return true
     */
    @Override
    public boolean canDisplay() {
        return true;
    }

    @InjectComponent
    private Layout layout;

    @Inject
    private Logger log;

    @Inject
    private Messages messages;

    @Property
    private Throwable exception;

    @Override
    public void reportException(Throwable eee) {
//        this.exception = getWaoExceptionO(eee);
//        if (exception != null) {
//            layout.addError(exception.getMessage());
//            this.exception = exception.getCause();
//            layout.addError("Erreur : " + this.exception.getClass().getSimpleName()
//                    + " : " + this.exception.getMessage());
//        } else {
            this.exception = getWaoException(eee);
            if (exception != null) {
                String[] errors =
                       BusinessUtils.getErrorMessages(
                                        (WaoException)exception, messages, log);
                layout.addError(errors);
            } else {
                log.error("Unexpected exception", eee);
                layout.addError("Erreur : " +
                        this.exception.getClass().getSimpleName()
                        + " : " + this.exception.getMessage());
            }
//        }
    }

    protected Throwable getWaoException(Throwable eee) {
        if (eee == null) {
            return eee;
        }
        if (eee instanceof WaoException) {
            return eee;
        }
        return getWaoException(eee.getCause());
    }

//    protected Throwable getWaoExceptionO(Throwable eee) {
//        if (eee == null) {
//            return eee;
//        }
//        if (eee instanceof WaoExceptionO) {
//            return eee;
//        }
//        return getWaoExceptionO(eee.getCause());
//    }
        
}
