/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.ui.base.WaoPage;
import fr.ifremer.wao.ui.components.Layout;
import fr.ifremer.wao.ui.data.BusinessUtils;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.ExceptionReporter;
import org.slf4j.Logger;

public class ExceptionReport
implements ExceptionReporter,
WaoPage {
    @InjectComponent
    private Layout layout;
    @Inject
    private Logger log;
    @Inject
    private Messages messages;
    @Property
    private Throwable exception;

    public boolean canDisplay() {
        return true;
    }

    public void reportException(Throwable eee) {
        this.exception = this.getWaoException(eee);
        if (this.exception != null) {
            String[] errors = BusinessUtils.getErrorMessages((WaoException)((WaoException)this.exception), (Messages)this.messages, (Logger)this.log);
            this.layout.addError(errors);
        } else {
            this.log.error("Unexpected exception", eee);
            this.layout.addError(new String[]{"Erreur : " + eee.getClass().getSimpleName() + " : " + eee.getMessage()});
        }
    }

    protected Throwable getWaoException(Throwable eee) {
        if (eee == null) {
            return eee;
        }
        if (eee instanceof WaoException) {
            return eee;
        }
        return this.getWaoException(eee.getCause());
    }
}

