/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.actions;

import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmId;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueId;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValues;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.actions.SimpleActionSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.renderer.DecoratorListCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.widgets.number.NumberEditor;

public class ChangeSpeciesBatchSampleCategoryAction
extends SimpleActionSupport<SpeciesBatchUI> {
    private static final Log log = LogFactory.getLog(ChangeSpeciesBatchSampleCategoryAction.class);
    private static final long serialVersionUID = -6540241422935319461L;

    public ChangeSpeciesBatchSampleCategoryAction(SpeciesBatchUI ui) {
        super(ui);
    }

    @Override
    protected void onActionPerformed(SpeciesBatchUI ui) {
        Object selectedItem;
        SpeciesBatchUIHandler handler = ui.getHandler();
        SpeciesBatchTableModel tableModel = handler.getTableModel();
        int rowIndex = SwingUtil.getSelectedModelRow((JTable)ui.getTable());
        int columnIndex = SwingUtil.getSelectedModelColumn((JTable)ui.getTable());
        SpeciesBatchRowModel selectedRow = (SpeciesBatchRowModel)tableModel.getEntry(rowIndex);
        SampleCategoryModel sampleCategoryModel = handler.getSampleCategoryModel();
        Integer sampleCategoryId = tableModel.getSampleCategoryId(columnIndex);
        SampleCategoryModelEntry sampleCategoryEntry = sampleCategoryModel.getCategoryById(sampleCategoryId);
        Caracteristic caracteristic = sampleCategoryEntry.getCaracteristic();
        SpeciesBatchRowModel firstAncestorRow = selectedRow.getFirstAncestor(sampleCategoryId);
        Set<Serializable> usedValues = handler.getSampleUsedValues(firstAncestorRow, sampleCategoryId);
        String categoryDecorated = handler.getDecorator(caracteristic.getClass(), "parameterOnly").toString((Object)caracteristic);
        String dialogTitle = I18n.t((String)"tutti.editSpeciesBatch.title.changeSampleCategoryValue", (Object[])new Object[]{categoryDecorated});
        boolean numericType = caracteristic.isNumericType();
        if (numericType) {
            NumberEditor editor = new NumberEditor();
            editor.setNumberPattern("\\d{0,6}(\\.\\d{0,3})?");
            editor.setUseSign(false);
            editor.setShowPopupButton(Boolean.valueOf(false));
            editor.setShowReset(Boolean.valueOf(false));
            int response = JOptionPane.showConfirmDialog(ui, editor, dialogTitle, 2);
            selectedItem = response == 0 ? editor.getModel() : null;
            if (usedValues.contains(selectedItem)) {
                JOptionPane.showMessageDialog(handler.getTopestUI(), I18n.t((String)"tutti.editSpeciesBatch.error.sampleCategoryValue.notAvailable", (Object[])new Object[]{selectedItem, categoryDecorated}));
                selectedItem = null;
            }
        } else {
            ArrayList availableValues = new ArrayList(caracteristic.getQualitativeValue());
            boolean firstCategory = sampleCategoryModel.getFirstCategoryId().equals(sampleCategoryId);
            if (firstCategory) {
                CaracteristicQualitativeValues.removeQualitativeValue(availableValues, (int)handler.getQualitative_unsorted_id());
            }
            availableValues.removeAll(usedValues);
            JComboBox editor = new JComboBox();
            editor.setRenderer(new DecoratorListCellRenderer(handler.getDecorator(CaracteristicQualitativeValue.class, null)));
            SwingUtil.fillComboBox(editor, availableValues, availableValues.get(0));
            int response = JOptionPane.showConfirmDialog(handler.getTopestUI(), editor, dialogTitle, 2);
            selectedItem = response == 0 ? (CaracteristicQualitativeValue)editor.getSelectedItem() : null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("New selected category: " + selectedItem));
        }
        if (selectedItem != null) {
            Serializable oldValue = tableModel.updateSampleCategorieValue(firstAncestorRow, columnIndex, (Serializable)selectedItem);
            handler.saveRow(firstAncestorRow);
            SpeciesBatchUIModel model = ui.getModel();
            if (PmfmId.SORTED_UNSORTED.getValue().equals(sampleCategoryId)) {
                if (QualitativeValueId.SORTED_VRAC.getValue().equals(((CaracteristicQualitativeValue)selectedItem).getIdAsInt())) {
                    model.decDistinctUnsortedSpeciesCount();
                    model.incDistinctSortedSpeciesCount();
                } else {
                    model.decDistinctSortedSpeciesCount();
                    model.incDistinctUnsortedSpeciesCount();
                }
            }
            if (!numericType) {
                EditCatchesUIModel createBatchModel = model.getCatchesUIModel();
                createBatchModel.replaceCaracteristicValue(firstAncestorRow.getSpecies(), (CaracteristicQualitativeValue)oldValue, (CaracteristicQualitativeValue)selectedItem);
            }
        }
    }
}

