/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.genericformat.actions;

import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportConfiguration;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportResult;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportService;
import fr.ifremer.tutti.service.genericformat.GenericFormatValidateFileResult;
import fr.ifremer.tutti.ui.swing.content.genericformat.GenericFormatImportUI;
import fr.ifremer.tutti.ui.swing.content.genericformat.GenericFormatImportUIHandler;
import fr.ifremer.tutti.ui.swing.content.genericformat.GenericFormatImportUIModel;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.awt.Component;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class GenericFormatImportAction
extends LongActionSupport<GenericFormatImportUIModel, GenericFormatImportUI, GenericFormatImportUIHandler> {
    private static final Log log = LogFactory.getLog(GenericFormatImportAction.class);
    public static final DateFormat df = new SimpleDateFormat("yyy-MM-dd-hh-mm");
    private File backupFile;
    private GenericFormatImportResult importResult;
    protected boolean overrideProtocol;

    public GenericFormatImportAction(GenericFormatImportUIHandler handler) {
        super(handler, false);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            doAction = ((GenericFormatImportUIModel)this.getModel()).isCanValidate();
        }
        if (doAction) {
            doAction = this.acceptOverrideData();
        }
        if (doAction) {
            doAction = this.acceptProtocol();
        }
        if (doAction && !this.getConfig().isGenericFormatImportSkipBackup()) {
            this.backupFile = this.saveFileWithStartDirectory(this.getConfig().getDbBackupDirectory(), false, "tutti-db-" + df.format(new Date()), "zip", I18n.t((String)"tutti.genericFormat.title.choose.dbBackupFile", (Object[])new Object[0]), I18n.t((String)"tutti.genericFormat.action.chooseDbBackupFile", (Object[])new Object[0]), new String[]{"^.+\\.zip$", I18n.t((String)"tutti.common.file.genericFormat", (Object[])new Object[0])});
            if (this.backupFile == null) {
                this.displayWarningMessage(I18n.t((String)"tutti.dbManager.title.backup.db", (Object[])new Object[0]), I18n.t((String)"tutti.dbManager.action.importdb.no.backup.db.choosen", (Object[])new Object[0]));
                doAction = false;
            }
        }
        if (doAction) {
            this.updateResult(null);
        }
        return doAction;
    }

    @Override
    public void doAction() throws Exception {
        ((GenericFormatImportUIModel)this.getModel()).setImportReportFile(this.getConfig().newTempFile("genericFormatImportReport", ".pdf"));
        GenericFormatImportConfiguration configuration = ((GenericFormatImportUIModel)this.getModel()).toImportConfiguration();
        configuration.setOverrideProtocol(this.overrideProtocol);
        GenericFormatImportService service = this.getContext().getGenericFormatImportService();
        boolean doBackup = !this.getConfig().isGenericFormatImportSkipBackup() && this.backupFile != null;
        int nbSteps = service.getImportProgramNbSteps(configuration);
        if (doBackup) {
            nbSteps += 3;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Import nb steps: " + nbSteps));
        }
        this.createProgressionModelIfRequired(nbSteps);
        if (doBackup) {
            this.getProgressionModel().increments(I18n.t((String)"tutti.genericFormatImport.step.closeDb", (Object[])new Object[0]));
            this.getContext().closePersistenceService();
            this.getProgressionModel().increments(I18n.t((String)"tutti.genericFormatImport.step.backupDb", (Object[])new Object[]{this.backupFile}));
            this.getContext().getPersistenceService().exportDb(this.backupFile);
            this.getProgressionModel().increments(I18n.t((String)"tutti.genericFormatImport.step.reopenDb", (Object[])new Object[]{this.backupFile}));
            this.getContext().openPersistenceService();
            service = this.getContext().getGenericFormatImportService();
        }
        Program program = ((GenericFormatImportUIModel)this.getModel()).getProgram();
        File importFile = ((GenericFormatImportUIModel)this.getModel()).getImportFile();
        if (log.isInfoEnabled()) {
            log.info((Object)("Do generic format import for program: " + program.getName() + " from file: " + importFile));
        }
        this.importResult = service.importProgram(configuration, this.getProgressionModel());
    }

    public void postSuccessAction() {
        this.updateResult(this.importResult);
        if (this.importResult.getProtocol() != null) {
            this.getDataContext().setProtocolId(this.importResult.getProtocol().getId());
        }
    }

    public void releaseAction() {
        this.backupFile = null;
        this.importResult = null;
        this.overrideProtocol = false;
        super.releaseAction();
    }

    protected void updateResult(GenericFormatImportResult result) {
        ((GenericFormatImportUIModel)this.getModel()).setImportResult(result);
        if (result != null) {
            String tip;
            String text;
            ImageIcon icon;
            if (result.isValid()) {
                icon = SwingUtil.createActionIcon((String)"accept");
                text = I18n.t((String)"tutti.genericFormat.import.success", (Object[])new Object[0]);
                tip = I18n.t((String)"tutti.genericFormat.import.success.tip", (Object[])new Object[0]);
            } else {
                icon = SwingUtil.createActionIcon((String)"cancel");
                text = I18n.t((String)"tutti.genericFormat.import.error", (Object[])new Object[0]);
                tip = I18n.t((String)"tutti.genericFormat.import.error.tip", (Object[])new Object[0]);
            }
            JLabel resultText = ((GenericFormatImportUI)this.getUI()).getImportResultText();
            resultText.setIcon(icon);
            resultText.setText(text);
            resultText.setToolTipText(tip);
        }
    }

    protected boolean acceptOverrideData() {
        boolean doAction = true;
        GenericFormatImportUIModel model = (GenericFormatImportUIModel)this.getModel();
        if (model.isSelectedDataExists(model.isUpdateCruises())) {
            String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n.t((String)"tutti.genericformat.overrideData.conflict.message", (Object[])new Object[0]), I18n.t((String)"tutti.genericformat.overrideData.conflict.help", (Object[])new Object[0]));
            Component ui = this.getDialogParentComponent();
            int i = JOptionPane.showConfirmDialog(ui, htmlMessage, I18n.t((String)"tutti.genericformat.overrideData.conflict.title", (Object[])new Object[0]), 2, 3);
            doAction = i == 0;
        }
        return doAction;
    }

    protected boolean acceptProtocol() {
        String protocolOriginalName;
        List allProtocolNames;
        GenericFormatValidateFileResult validateResult = ((GenericFormatImportUIModel)this.getModel()).getValidateResult();
        boolean withProtocolToImport = validateResult.getProtocolFileResult().isImported();
        boolean doAction = true;
        if (withProtocolToImport && (allProtocolNames = this.getContext().getPersistenceService().getAllProtocolNames()).contains(protocolOriginalName = validateResult.getProtocolOriginalName())) {
            String cancel = I18n.t((String)"tutti.genericformat.protocol.action.cancel", (Object[])new Object[0]);
            String override = I18n.t((String)"tutti.genericformat.protocol.action.override", (Object[])new Object[0]);
            String add = I18n.t((String)"tutti.genericformat.protocol.action.add", (Object[])new Object[0]);
            String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n.t((String)"tutti.genericformat.protocolName.conflict.message", (Object[])new Object[]{protocolOriginalName}), I18n.t((String)"tutti.genericformat.protocolName.conflict.help", (Object[])new Object[]{validateResult.getProtocol().getName()}));
            Component ui = this.getDialogParentComponent();
            int response = JOptionPane.showOptionDialog(ui, htmlMessage, I18n.t((String)"tutti.genericformat.protocolName.conflict.title", (Object[])new Object[0]), 2, 3, null, new String[]{add, override, cancel}, add);
            switch (response) {
                case 2: {
                    doAction = false;
                    break;
                }
                case 1: {
                    doAction = true;
                    this.overrideProtocol = true;
                    break;
                }
                case 0: {
                    doAction = true;
                }
            }
        }
        return doAction;
    }
}

