// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.vessel.feature.person;

import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.referential.EducationGrade;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;

/**
 * Personne liés à une usager. Par exemple, un capitaine (patron) de navire, un marin, etc.
 * ref : flux SACAPT, SIH-INRH
 * ATTENTION :
 * - Pour Ifremer, actuellement non utilisée, pour observation de la données SACAPT avant
 * utilisation. Pour le moment, la donnée est stockée dans 'Playground'.
 */
// HibernateEntity.vsl annotations merge-point
public abstract class VesselPerson
    implements Serializable, Comparable<VesselPerson>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 7324469036407033140L;

    // Generate 15 attributes
    private Integer id;

    /**
     * 
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * 
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private String registrationCode;

    /**
     * Code d'enregistrament du patron pecheur.
     * Code unique si donnée SACAPT (DPMA)
     * @return this.registrationCode String
     */
    public String getRegistrationCode()
    {
        return this.registrationCode;
    }

    /**
     * Code d'enregistrament du patron pecheur.
     * Code unique si donnée SACAPT (DPMA)
     * @param registrationCodeIn String
     */
    public void setRegistrationCode(String registrationCodeIn)
    {
        this.registrationCode = registrationCodeIn;
    }

    private String lastname;

    /**
     * Nom du patron de peche
     * @return this.lastname String
     */
    public String getLastname()
    {
        return this.lastname;
    }

    /**
     * Nom du patron de peche
     * @param lastnameIn String
     */
    public void setLastname(String lastnameIn)
    {
        this.lastname = lastnameIn;
    }

    private String firstname;

    /**
     * Prénom du patron de peche
     * @return this.firstname String
     */
    public String getFirstname()
    {
        return this.firstname;
    }

    /**
     * Prénom du patron de peche
     * @param firstnameIn String
     */
    public void setFirstname(String firstnameIn)
    {
        this.firstname = firstnameIn;
    }

    private String street;

    /**
     * Rue de l'habitation du patron de peche
     * @return this.street String
     */
    public String getStreet()
    {
        return this.street;
    }

    /**
     * Rue de l'habitation du patron de peche
     * @param streetIn String
     */
    public void setStreet(String streetIn)
    {
        this.street = streetIn;
    }

    private String zipCode;

    /**
     * Code postal du patron
     * @return this.zipCode String
     */
    public String getZipCode()
    {
        return this.zipCode;
    }

    /**
     * Code postal du patron
     * @param zipCodeIn String
     */
    public void setZipCode(String zipCodeIn)
    {
        this.zipCode = zipCodeIn;
    }

    private String city;

    /**
     * Ville du patron
     * @return this.city String
     */
    public String getCity()
    {
        return this.city;
    }

    /**
     * Ville du patron
     * @param cityIn String
     */
    public void setCity(String cityIn)
    {
        this.city = cityIn;
    }

    private Date dateOfBirth;

    /**
     * Date de naissance du patron.
     * @return this.dateOfBirth Date
     */
    public Date getDateOfBirth()
    {
        return this.dateOfBirth;
    }

    /**
     * Date de naissance du patron.
     * @param dateOfBirthIn Date
     */
    public void setDateOfBirth(Date dateOfBirthIn)
    {
        this.dateOfBirth = dateOfBirthIn;
    }

    private Date retirementDate;

    /**
     * Date du dernier jour d'activité (retraite)
     * @return this.retirementDate Date
     */
    public Date getRetirementDate()
    {
        return this.retirementDate;
    }

    /**
     * Date du dernier jour d'activité (retraite)
     * @param retirementDateIn Date
     */
    public void setRetirementDate(Date retirementDateIn)
    {
        this.retirementDate = retirementDateIn;
    }

    private String phoneNumber;

    /**
     * 
     * @return this.phoneNumber String
     */
    public String getPhoneNumber()
    {
        return this.phoneNumber;
    }

    /**
     * 
     * @param phoneNumberIn String
     */
    public void setPhoneNumber(String phoneNumberIn)
    {
        this.phoneNumber = phoneNumberIn;
    }

    private String mobileNumber;

    /**
     * 
     * @return this.mobileNumber String
     */
    public String getMobileNumber()
    {
        return this.mobileNumber;
    }

    /**
     * 
     * @param mobileNumberIn String
     */
    public void setMobileNumber(String mobileNumberIn)
    {
        this.mobileNumber = mobileNumberIn;
    }

    private String faxNumber;

    /**
     * 
     * @return this.faxNumber String
     */
    public String getFaxNumber()
    {
        return this.faxNumber;
    }

    /**
     * 
     * @param faxNumberIn String
     */
    public void setFaxNumber(String faxNumberIn)
    {
        this.faxNumber = faxNumberIn;
    }

    private String email;

    /**
     * 
     * @return this.email String
     */
    public String getEmail()
    {
        return this.email;
    }

    /**
     * 
     * @param emailIn String
     */
    public void setEmail(String emailIn)
    {
        this.email = emailIn;
    }

    private Timestamp updateDate;

    /**
     * 
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * 
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    private Integer remoteId;

    /**
     * 
     * @return this.remoteId Integer
     */
    public Integer getRemoteId()
    {
        return this.remoteId;
    }

    /**
     * 
     * @param remoteIdIn Integer
     */
    public void setRemoteId(Integer remoteIdIn)
    {
        this.remoteId = remoteIdIn;
    }

    // Generate 4 associations
    private EducationGrade educationGrade;

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Niveau de d'instruction ou de qualification (par exemple d'un patron de
     * navire : <i>VesselMaster</i>).
     * </p>
     * <p>
     * </p>
     * <p>
     * ref : SIH-INRH (05-2011)
     * </p>
     * </body>
     * </html>
     * @return this.educationGrade EducationGrade
     */
    public EducationGrade getEducationGrade()
    {
        return this.educationGrade;
    }

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Niveau de d'instruction ou de qualification (par exemple d'un patron de
     * navire : <i>VesselMaster</i>).
     * </p>
     * <p>
     * </p>
     * <p>
     * ref : SIH-INRH (05-2011)
     * </p>
     * </body>
     * </html>
     * @param educationGradeIn EducationGrade
     */
    public void setEducationGrade(EducationGrade educationGradeIn)
    {
        this.educationGrade = educationGradeIn;
    }

    private Location countryLocation;

    /**
     * Représente un lieu au sens général du terme. Il peut s'agir d'un lieu ponctuel, linéaire ou
     * surfacique.
     * Suivant sa classification et son niveau, il peut s'agir d'un secteur FAO, un port de pêche,
     * un
     * quartier maritime, une criée, etc.
     * Nombre de lignes : lieux terrestre : 4500 + secteurs : 11210 + strates : 1000 + localités :
     * 200
     * @return this.countryLocation Location
     */
    public Location getCountryLocation()
    {
        return this.countryLocation;
    }

    /**
     * Représente un lieu au sens général du terme. Il peut s'agir d'un lieu ponctuel, linéaire ou
     * surfacique.
     * Suivant sa classification et son niveau, il peut s'agir d'un secteur FAO, un port de pêche,
     * un
     * quartier maritime, une criée, etc.
     * Nombre de lignes : lieux terrestre : 4500 + secteurs : 11210 + strates : 1000 + localités :
     * 200
     * @param countryLocationIn Location
     */
    public void setCountryLocation(Location countryLocationIn)
    {
        this.countryLocation = countryLocationIn;
    }

    private Program program;

    /**
     * Programme d'observation à l'origine d'une collecte de données.
     * Désigne les activités qui sont à l'origine de la collecte d'un ensemble cohérent de données,
     * que ce
     * soit pour des collectes continues (marées observées en mer, SIPA) ou pour des études limitées
     * dans
     * le temps. La quantité de données rattachées à un programme peut être variable, selon qu'il
     * s'agit
     * d'une activité longue ou intensive, ou d'une opération plus ponctuelle (étude) mais toujours
     * mise en
     * œuvre selon un schéma décidé à l'avance.
     * Exemple de programmes d'observations :
     * - SIH-OBSMER (marées observées en mer)
     * - SIH-STATPECHE (enquete d'activité et d'effort...)
     * - SIPA : données déclaratives transmises par la DPMA
     * - VMS : données satellitaires
     * - OFIMER : données du SI de l'OFIMER
     * @return this.program Program
     */
    public Program getProgram()
    {
        return this.program;
    }

    /**
     * Programme d'observation à l'origine d'une collecte de données.
     * Désigne les activités qui sont à l'origine de la collecte d'un ensemble cohérent de données,
     * que ce
     * soit pour des collectes continues (marées observées en mer, SIPA) ou pour des études limitées
     * dans
     * le temps. La quantité de données rattachées à un programme peut être variable, selon qu'il
     * s'agit
     * d'une activité longue ou intensive, ou d'une opération plus ponctuelle (étude) mais toujours
     * mise en
     * œuvre selon un schéma décidé à l'avance.
     * Exemple de programmes d'observations :
     * - SIH-OBSMER (marées observées en mer)
     * - SIH-STATPECHE (enquete d'activité et d'effort...)
     * - SIPA : données déclaratives transmises par la DPMA
     * - VMS : données satellitaires
     * - OFIMER : données du SI de l'OFIMER
     * @param programIn Program
     */
    public void setProgram(Program programIn)
    {
        this.program = programIn;
    }

    /**
     * Returns <code>true</code> if the argument is an VesselPerson instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof VesselPerson))
        {
            return false;
        }
        final VesselPerson that = (VesselPerson)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link VesselPerson}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link VesselPerson}.
         * @return new VesselPersonImpl()
         */
        public static VesselPerson newInstance()
        {
            return new VesselPersonImpl();
        }

        /**
         * Constructs a new instance of {@link VesselPerson}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param program Program
         * @return newInstance
         */
        public static VesselPerson newInstance(Program program)
        {
            final VesselPerson entity = new VesselPersonImpl();
            entity.setProgram(program);
            return entity;
        }

        /**
         * Constructs a new instance of {@link VesselPerson}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param registrationCode String
         * @param lastname String
         * @param firstname String
         * @param street String
         * @param zipCode String
         * @param city String
         * @param dateOfBirth Date
         * @param retirementDate Date
         * @param phoneNumber String
         * @param mobileNumber String
         * @param faxNumber String
         * @param email String
         * @param updateDate Timestamp
         * @param remoteId Integer
         * @param educationGrade EducationGrade
         * @param countryLocation Location
         * @param program Program
         * @return newInstance VesselPerson
         */
        public static VesselPerson newInstance(String registrationCode, String lastname, String firstname, String street, String zipCode, String city, Date dateOfBirth, Date retirementDate, String phoneNumber, String mobileNumber, String faxNumber, String email, Timestamp updateDate, Integer remoteId, EducationGrade educationGrade, Location countryLocation, Program program)
        {
            final VesselPerson entity = new VesselPersonImpl();
            entity.setRegistrationCode(registrationCode);
            entity.setLastname(lastname);
            entity.setFirstname(firstname);
            entity.setStreet(street);
            entity.setZipCode(zipCode);
            entity.setCity(city);
            entity.setDateOfBirth(dateOfBirth);
            entity.setRetirementDate(retirementDate);
            entity.setPhoneNumber(phoneNumber);
            entity.setMobileNumber(mobileNumber);
            entity.setFaxNumber(faxNumber);
            entity.setEmail(email);
            entity.setUpdateDate(updateDate);
            entity.setRemoteId(remoteId);
            entity.setEducationGrade(educationGrade);
            entity.setCountryLocation(countryLocation);
            entity.setProgram(program);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(VesselPerson o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getRegistrationCode() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRegistrationCode().compareTo(o.getRegistrationCode()));
            }
            if (this.getLastname() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getLastname().compareTo(o.getLastname()));
            }
            if (this.getFirstname() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getFirstname().compareTo(o.getFirstname()));
            }
            if (this.getStreet() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getStreet().compareTo(o.getStreet()));
            }
            if (this.getZipCode() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getZipCode().compareTo(o.getZipCode()));
            }
            if (this.getCity() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getCity().compareTo(o.getCity()));
            }
            if (this.getDateOfBirth() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getDateOfBirth().compareTo(o.getDateOfBirth()));
            }
            if (this.getRetirementDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRetirementDate().compareTo(o.getRetirementDate()));
            }
            if (this.getPhoneNumber() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getPhoneNumber().compareTo(o.getPhoneNumber()));
            }
            if (this.getMobileNumber() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getMobileNumber().compareTo(o.getMobileNumber()));
            }
            if (this.getFaxNumber() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getFaxNumber().compareTo(o.getFaxNumber()));
            }
            if (this.getEmail() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getEmail().compareTo(o.getEmail()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
            if (this.getRemoteId() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRemoteId().compareTo(o.getRemoteId()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// VesselPerson.java merge-point
}