/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.config.providers;

import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.entities.InterceptorConfig;
import com.opensymphony.xwork2.config.entities.InterceptorLocator;
import com.opensymphony.xwork2.config.entities.InterceptorMapping;
import com.opensymphony.xwork2.config.entities.InterceptorStackConfig;
import com.opensymphony.xwork2.interceptor.Interceptor;
import com.opensymphony.xwork2.util.location.Location;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(InterceptorBuilder.class);

    public static List<InterceptorMapping> constructInterceptorReference(InterceptorLocator interceptorLocator, String refName, Map<String, String> refParams, Location location, ObjectFactory objectFactory) throws ConfigurationException {
        Object referencedConfig = interceptorLocator.getInterceptorConfig(refName);
        List<InterceptorMapping> result = new ArrayList<InterceptorMapping>();
        if (referencedConfig == null) {
            throw new ConfigurationException("Unable to find interceptor class referenced by ref-name " + refName, (Object)location);
        }
        if (referencedConfig instanceof InterceptorConfig) {
            InterceptorConfig config = (InterceptorConfig)referencedConfig;
            Interceptor inter = null;
            try {
                inter = objectFactory.buildInterceptor(config, refParams);
                result.add(new InterceptorMapping(refName, inter));
            }
            catch (ConfigurationException ex) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Unable to load config class #0 at #1 probably due to a missing jar, which might be fine if you never plan to use the #2 interceptor", config.getClassName(), ex.getLocation().toString(), config.getName());
                }
                LOG.error("Actual exception", ex, new String[0]);
            }
        } else if (referencedConfig instanceof InterceptorStackConfig) {
            InterceptorStackConfig stackConfig = (InterceptorStackConfig)referencedConfig;
            if (refParams != null && refParams.size() > 0) {
                result = InterceptorBuilder.constructParameterizedInterceptorReferences(interceptorLocator, stackConfig, refParams, objectFactory);
            } else {
                result.addAll(stackConfig.getInterceptors());
            }
        } else {
            LOG.error("Got unexpected type for interceptor " + refName + ". Got " + referencedConfig, new String[0]);
        }
        return result;
    }

    private static List<InterceptorMapping> constructParameterizedInterceptorReferences(InterceptorLocator interceptorLocator, InterceptorStackConfig stackConfig, Map<String, String> refParams, ObjectFactory objectFactory) {
        LinkedHashMap params = new LinkedHashMap();
        for (String key : refParams.keySet()) {
            String value = refParams.get(key);
            try {
                String name = key.substring(0, key.indexOf(46));
                key = key.substring(key.indexOf(46) + 1);
                Map map = params.containsKey(name) ? (Map)params.get(name) : new LinkedHashMap();
                map.put(key, value);
                params.put(name, map);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn("No interceptor found for name = #0", key);
            }
        }
        ArrayList<InterceptorMapping> result = new ArrayList<InterceptorMapping>(stackConfig.getInterceptors());
        for (String key : params.keySet()) {
            Map map = (Map)params.get(key);
            Object interceptorCfgObj = interceptorLocator.getInterceptorConfig(key);
            if (interceptorCfgObj instanceof InterceptorConfig) {
                InterceptorConfig cfg = (InterceptorConfig)interceptorCfgObj;
                Interceptor interceptor = objectFactory.buildInterceptor(cfg, map);
                InterceptorMapping mapping = new InterceptorMapping(key, interceptor);
                if (result != null && result.contains(mapping)) {
                    int index = result.indexOf(mapping);
                    result.set(index, mapping);
                    continue;
                }
                result.add(mapping);
                continue;
            }
            if (!(interceptorCfgObj instanceof InterceptorStackConfig)) continue;
            InterceptorStackConfig stackCfg = (InterceptorStackConfig)interceptorCfgObj;
            List<InterceptorMapping> tmpResult = InterceptorBuilder.constructParameterizedInterceptorReferences(interceptorLocator, stackCfg, map, objectFactory);
            for (InterceptorMapping tmpInterceptorMapping : tmpResult) {
                if (result.contains(tmpInterceptorMapping)) {
                    int index = result.indexOf(tmpInterceptorMapping);
                    result.set(index, tmpInterceptorMapping);
                    continue;
                }
                result.add(tmpInterceptorMapping);
            }
        }
        return result;
    }
}

