/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.consumer;

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.service.csv.CsvComsumer;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportEntityParserFactory;
import fr.ifremer.tutti.service.genericformat.csv.SampleCategoryModel;
import fr.ifremer.tutti.service.genericformat.csv.SampleCategoryRow;
import java.nio.file.Path;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.csv.ImportRow;
import org.nuiton.i18n.I18n;

public class CsvConsumerForSampleCategory
extends CsvComsumer<SampleCategoryRow, SampleCategoryModel> {
    public CsvConsumerForSampleCategory(Path file, char separator, GenericFormatImportEntityParserFactory parserFactory, boolean reportError) {
        super(file, SampleCategoryModel.forImport(separator, parserFactory), reportError);
    }

    public void validateRow(ImportRow<SampleCategoryRow> row, Set<String> existingCodes, Set<Integer> existingCaracteristicIds) {
        if (row.isValid()) {
            SampleCategoryRow bean = (SampleCategoryRow)row.getBean();
            String code = bean.getCode();
            if (StringUtils.isBlank((CharSequence)code)) {
                this.addCheckError(row, new IllegalStateException(I18n.t((String)"tutti.service.genericFormat.import.sampleCategoryModel.error.noCode", (Object[])new Object[0])));
            } else if (!existingCodes.add(code)) {
                this.addCheckError(row, new IllegalStateException(I18n.t((String)"tutti.service.genericFormat.import.sampleCategoryModel.error.alreadyUsedCode", (Object[])new Object[]{code})));
            }
            Caracteristic caracteristic = bean.getCaracteristic();
            if (caracteristic == null) {
                this.addCheckError(row, new IllegalStateException(I18n.t((String)"tutti.service.genericFormat.import.sampleCategoryModel.error.noCaracteristic", (Object[])new Object[0])));
            } else if (!existingCaracteristicIds.add(caracteristic.getIdAsInt())) {
                this.addCheckError(row, new IllegalStateException(I18n.t((String)"tutti.service.genericFormat.import.sampleCategoryModel.error.alreadyUsedCaracteristic", (Object[])new Object[]{caracteristic.getIdAsInt()})));
            }
        }
        this.reportError(row);
    }
}

