/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol.calcifiedpiecessampling.actions;

import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.calcifiedpiecessampling.CalcifiedPiecesSamplingEditorRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.calcifiedpiecessampling.CalcifiedPiecesSamplingEditorTableModel;
import fr.ifremer.tutti.ui.swing.content.protocol.calcifiedpiecessampling.CalcifiedPiecesSamplingEditorUI;
import fr.ifremer.tutti.ui.swing.util.actions.SimpleActionSupport;
import java.util.List;
import javax.swing.JOptionPane;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;

public class DeleteRowAction
extends SimpleActionSupport<CalcifiedPiecesSamplingEditorUI> {
    public DeleteRowAction(CalcifiedPiecesSamplingEditorUI ui) {
        super(ui);
    }

    @Override
    protected void onActionPerformed(CalcifiedPiecesSamplingEditorUI ui) {
        JXTable cpsTable = ui.getCpsTable();
        CalcifiedPiecesSamplingEditorTableModel tableModel = (CalcifiedPiecesSamplingEditorTableModel)((Object)cpsTable.getModel());
        int selectedRow = cpsTable.getSelectedRow();
        List<CalcifiedPiecesSamplingEditorRowModel> cspRows = ui.getModel().getCpsRows();
        CalcifiedPiecesSamplingEditorRowModel row = cspRows.get(selectedRow);
        if (row.getMinSize() > 0) {
            EditProtocolSpeciesRowModel speciesToDelete = row.getProtocolSpecies();
            String decoratedRow = ui.getHandler().getDecorator(Species.class, null).toString((Object)speciesToDelete.getSpecies());
            if (row.getMaturity() != null) {
                decoratedRow = decoratedRow + " (" + ui.getHandler().getDecorator(Boolean.class, "maturity").toString((Object)row.getMaturity()) + ")";
            }
            decoratedRow = decoratedRow + " [" + row.getMinSize() + ", " + ui.getHandler().getDecorator(Integer.class, "nullInfinite").toString((Object)row.getMaxSize()) + "]";
            int confirmDeletion = JOptionPane.showConfirmDialog(ui, I18n.t((String)"tutti.editCps.deleteRow.message", (Object[])new Object[]{decoratedRow}), I18n.t((String)"tutti.editCps.deleteRow.title", (Object[])new Object[0]), 0, 3);
            if (confirmDeletion == 0) {
                CalcifiedPiecesSamplingEditorRowModel previousRow = cspRows.get(selectedRow - 1);
                previousRow.setMaxSize(row.getMaxSize());
                cspRows.remove((Object)row);
                tableModel.fireTableRowsDeleted(selectedRow, selectedRow);
            }
        }
    }
}

