/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.actions;

import fr.ifremer.tutti.service.sampling.SamplingCodePrefix;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.SampleCodeEditionPopupUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.SampleCodeEditionPopupUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.util.actions.SimpleActionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;

public class EditSampleCodeAction
extends SimpleActionSupport<SpeciesFrequencyUI> {
    private static final Log log = LogFactory.getLog(EditSampleCodeAction.class);

    public EditSampleCodeAction(SpeciesFrequencyUI speciesFrequencyUI) {
        super(speciesFrequencyUI, false);
    }

    @Override
    protected void onActionPerformed(SpeciesFrequencyUI ui) {
        String samplingCode;
        boolean modelValid;
        JXTable obsTable = ui.getObsTable();
        IndividualObservationBatchTableModel obsTableModel = (IndividualObservationBatchTableModel)((Object)obsTable.getModel());
        int selectedRowIndex = obsTable.getSelectedRow();
        IndividualObservationBatchRowModel selectedRow = (IndividualObservationBatchRowModel)obsTableModel.getRows().get(selectedRowIndex);
        SampleCodeEditionPopupUI sampleCodeEditionPopupUI = new SampleCodeEditionPopupUI(ui);
        boolean samplingCodeAvailable = false;
        do {
            samplingCode = null;
            Integer samplingCodeId = selectedRow.getSamplingCodeId();
            SamplingCodePrefix samplingCodePrefix = ui.getModel().getIndividualObservationModel().getSamplingCodePrefix();
            sampleCodeEditionPopupUI.open(samplingCodePrefix, samplingCodeId);
            SampleCodeEditionPopupUIModel model = sampleCodeEditionPopupUI.getModel();
            modelValid = model.isValid();
            if (!modelValid) continue;
            Integer sampleCode = model.getSampleCode();
            samplingCode = samplingCodePrefix.toSamplingCode(sampleCode.intValue());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Test if sampling code " + samplingCode + " is available."));
            }
            boolean bl = samplingCodeAvailable = samplingCodeId.equals(sampleCode) || ui.getModel().getSamplingCodeUICache().canUseSamplingCode(sampleCode);
            if (samplingCodeAvailable) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sampling code " + samplingCode + " is not available."));
            }
            TuttiUIContext.getApplicationContext().getErrorHelper().showErrorDialog(I18n.t((String)"tutti.editSpeciesFrequencies.error.notAvailableSamplingCode", (Object[])new Object[]{samplingCode}));
        } while (!samplingCodeAvailable && modelValid);
        if (samplingCode != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sampling code " + samplingCode + " is available, use it on selected row."));
            }
            selectedRow.setSamplingCode(samplingCode);
            obsTableModel.fireTableRowsUpdated(selectedRowIndex, selectedRowIndex);
        }
    }
}

