// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.referential.location;

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * Représente une association entre un lieu parent et un lieu fils.
 */
// HibernateEntity.vsl annotations merge-point
public abstract class LocationAssociation
    implements Serializable, Comparable<LocationAssociation>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 6358749952819942603L;

    private LocationAssociationPK locationAssociationPk;

    /**
     * Get the composite primary key identifier class
     * @return locationAssociationPk
     */
    public LocationAssociationPK getLocationAssociationPk()
    {
        return this.locationAssociationPk;
    }

    /**
     * Set the composite primary key identifier class
     * @param locationAssociationPkIn
     */
    public void setLocationAssociationPk(LocationAssociationPK locationAssociationPkIn) {
        this.locationAssociationPk = locationAssociationPkIn;
    }

    // Generate 2 attributes
    private Float childSurfaceRatio = Float.valueOf("1.0");

    /**
     * Ratio de couverture (en surface) du lieu fils par rapport au lieu père. La valeur doit etre
     * supérieure strictement à 0 et inférieur ou égale à 1.
     * Un Lieu qui a un ratio de surface de 1 n'a donc qu'un seul lieu père direct. Un lieu qui a un
     * ratio de surface inférieur à 1 peu avoir potentiellement plusieurs lieux pères directs.
     * @return this.childSurfaceRatio Float
     */
    public Float getChildSurfaceRatio()
    {
        return this.childSurfaceRatio;
    }

    /**
     * Ratio de couverture (en surface) du lieu fils par rapport au lieu père. La valeur doit etre
     * supérieure strictement à 0 et inférieur ou égale à 1.
     * Un Lieu qui a un ratio de surface de 1 n'a donc qu'un seul lieu père direct. Un lieu qui a un
     * ratio de surface inférieur à 1 peu avoir potentiellement plusieurs lieux pères directs.
     * @param childSurfaceRatioIn Float
     */
    public void setChildSurfaceRatio(Float childSurfaceRatioIn)
    {
        this.childSurfaceRatio = childSurfaceRatioIn;
    }

    private Timestamp updateDate;

    /**
     * 
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * 
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    // Generate 2 associations
    private Location parentLocation;

    /**
     * Représente un lieu au sens général du terme. Il peut s'agir d'un lieu ponctuel, linéaire ou
     * surfacique.
     * Suivant sa classification et son niveau, il peut s'agir d'un secteur FAO, un port de pêche,
     * un
     * quartier maritime, une criée, etc.
     * Nombre de lignes : lieux terrestre : 4500 + secteurs : 11210 + strates : 1000 + localités :
     * 200
     * @return this.parentLocation Location
     */
    public Location getParentLocation()
    {
        return this.parentLocation;
    }

    /**
     * Représente un lieu au sens général du terme. Il peut s'agir d'un lieu ponctuel, linéaire ou
     * surfacique.
     * Suivant sa classification et son niveau, il peut s'agir d'un secteur FAO, un port de pêche,
     * un
     * quartier maritime, une criée, etc.
     * Nombre de lignes : lieux terrestre : 4500 + secteurs : 11210 + strates : 1000 + localités :
     * 200
     * @param parentLocationIn Location
     */
    public void setParentLocation(Location parentLocationIn)
    {
        this.parentLocation = parentLocationIn;
    }

    private Location childLocation;

    /**
     * Représente un lieu au sens général du terme. Il peut s'agir d'un lieu ponctuel, linéaire ou
     * surfacique.
     * Suivant sa classification et son niveau, il peut s'agir d'un secteur FAO, un port de pêche,
     * un
     * quartier maritime, une criée, etc.
     * Nombre de lignes : lieux terrestre : 4500 + secteurs : 11210 + strates : 1000 + localités :
     * 200
     * @return this.childLocation Location
     */
    public Location getChildLocation()
    {
        return this.childLocation;
    }

    /**
     * Représente un lieu au sens général du terme. Il peut s'agir d'un lieu ponctuel, linéaire ou
     * surfacique.
     * Suivant sa classification et son niveau, il peut s'agir d'un secteur FAO, un port de pêche,
     * un
     * quartier maritime, une criée, etc.
     * Nombre de lignes : lieux terrestre : 4500 + secteurs : 11210 + strates : 1000 + localités :
     * 200
     * @param childLocationIn Location
     */
    public void setChildLocation(Location childLocationIn)
    {
        this.childLocation = childLocationIn;
    }

    /**
     * This entity does not have any identifiers
     * and is not extending any other entity,
     * so this method will only return <code>true</code> if the argument reference and <code>this</code>
     * refer to the same object.
     */
    @Override
    public boolean equals(Object object)
    {
        return super.equals(object);
    }

    /**
     * This entity does not have any identifiers
     * and is not extending any other entity,
     * so this method will only take the identifiers of this entity into account when calculating the hash code.
     */
    @Override
    public int hashCode()
    {
        return super.hashCode();
    }

    /**
     * Constructs new instances of {@link LocationAssociation}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link LocationAssociation}.
         * @return new LocationAssociationImpl()
         */
        public static LocationAssociation newInstance()
        {
            return new LocationAssociationImpl();
        }

        /**
         * Constructs a new instance of {@link LocationAssociation}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param childSurfaceRatio Float
         * @param parentLocation Location
         * @param childLocation Location
         * @return newInstance
         */
        public static LocationAssociation newInstance(Float childSurfaceRatio, Location parentLocation, Location childLocation)
        {
            final LocationAssociation entity = new LocationAssociationImpl();
            entity.setChildSurfaceRatio(childSurfaceRatio);
            entity.setParentLocation(parentLocation);
            entity.setChildLocation(childLocation);
            return entity;
        }

        /**
         * Constructs a new instance of {@link LocationAssociation}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param childSurfaceRatio Float
         * @param updateDate Timestamp
         * @param parentLocation Location
         * @param childLocation Location
         * @return newInstance LocationAssociation
         */
        public static LocationAssociation newInstance(Float childSurfaceRatio, Timestamp updateDate, Location parentLocation, Location childLocation)
        {
            final LocationAssociation entity = new LocationAssociationImpl();
            entity.setChildSurfaceRatio(childSurfaceRatio);
            entity.setUpdateDate(updateDate);
            entity.setParentLocation(parentLocation);
            entity.setChildLocation(childLocation);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(LocationAssociation o)
    {
        int cmp = 0;
        if (this.getLocationAssociationPk() != null)
        {
            cmp = this.getLocationAssociationPk().compareTo(o.getLocationAssociationPk());
        }
            if (this.getChildSurfaceRatio() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getChildSurfaceRatio().compareTo(o.getChildSurfaceRatio()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// LocationAssociation.java merge-point
}