/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.parser;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;

public class StylePropertyMapping {
    protected static final HashMap nameMapping = new HashMap();
    protected static IElementDefn styleDefn;

    static {
        nameMapping.put("fontFamily", 55);
        nameMapping.put("fontStyle", 40);
        nameMapping.put("fontVariant", 30);
        nameMapping.put("fontWeight", 29);
        nameMapping.put("fontSize", 39);
        nameMapping.put("color", 0);
        nameMapping.put("backgroundColor", 8);
        nameMapping.put("backgroundImage", 45);
        nameMapping.put("backgroundRepeat", 9);
        nameMapping.put("backgroundAttachment", 47);
        nameMapping.put("backgroundPositionX", 32);
        nameMapping.put("backgroundPositionY", 37);
        nameMapping.put("wordSpacing", 59);
        nameMapping.put("letterSpacing", 44);
        nameMapping.put("textUnderline", 58);
        nameMapping.put("textOverline", 34);
        nameMapping.put("textLineThrough", 27);
        nameMapping.put("verticalAlign", 48);
        nameMapping.put("textTransform", 35);
        nameMapping.put("textAlign", 23);
        nameMapping.put("textIndent", 20);
        nameMapping.put("lineHeight", 2);
        nameMapping.put("whiteSpace", 60);
        nameMapping.put("marginTop", 19);
        nameMapping.put("marginBottom", 31);
        nameMapping.put("marginLeft", 16);
        nameMapping.put("marginRight", 17);
        nameMapping.put("paddingTop", 6);
        nameMapping.put("paddingBottom", 18);
        nameMapping.put("paddingLeft", 3);
        nameMapping.put("paddingRight", 4);
        nameMapping.put("borderTopWidth", 41);
        nameMapping.put("borderBottomWidth", 11);
        nameMapping.put("borderLeftWidth", 42);
        nameMapping.put("borderRightWidth", 10);
        nameMapping.put("borderTopColor", 13);
        nameMapping.put("borderBottomColor", 15);
        nameMapping.put("borderLeftColor", 46);
        nameMapping.put("borderRightColor", 14);
        nameMapping.put("borderTopStyle", 49);
        nameMapping.put("borderBottomStyle", 22);
        nameMapping.put("borderLeftStyle", 52);
        nameMapping.put("borderRightStyle", 21);
        nameMapping.put("display", 50);
        nameMapping.put("orphans", 28);
        nameMapping.put("widows", 54);
        nameMapping.put("pageBreakAfter", 57);
        nameMapping.put("pageBreakBefore", 33);
        nameMapping.put("pageBreakInside", 56);
        nameMapping.put("masterPage", 51);
        nameMapping.put("showIfBlank", 43);
        nameMapping.put("canShrink", 12);
        nameMapping.put("numberAlign", 25);
        nameMapping.put("bidiTextDirection", 5);
        nameMapping.put("data-format", 1);
    }

    protected static IElementDefn getStyleDefn() {
        if (styleDefn != null) {
            return styleDefn;
        }
        styleDefn = MetaDataDictionary.getInstance().getElement("Style");
        assert (styleDefn != null);
        return styleDefn;
    }

    public static boolean canInherit(String name) {
        IElementPropertyDefn defn = StylePropertyMapping.getStyleDefn().getProperty(name);
        if (defn != null) {
            return defn.canInherit();
        }
        return false;
    }

    public static Object getDefaultValue(String name) {
        IElementPropertyDefn defn = StylePropertyMapping.getStyleDefn().getProperty(name);
        if (defn != null) {
            return defn.getDefault();
        }
        return null;
    }

    public static Object getDefaultValue(String name, ReportDesignHandle handle) {
        Object value = StylePropertyMapping.getDefaultValue(name);
        if (value == null && handle != null && handle.isDirectionRTL() && "bidiTextDirection".equals(name)) {
            return "rtl";
        }
        return value;
    }

    public static Object getDefaultValue(int index) {
        return StylePropertyMapping.getDefaultValue(nameMapping.get(index).toString());
    }

    public static int getPropertyID(String name) {
        int id = -1;
        Object obj = nameMapping.get(name);
        if (obj instanceof Integer) {
            id = (Integer)obj;
        }
        return id;
    }

    public static Set getPropertyMapping() {
        return nameMapping.entrySet();
    }
}

