/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.computable;

import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableData;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableDataEditor;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import javax.swing.JTextField;
import jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.widgets.number.NumberEditorHandler;

public class ComputableDataEditorHandler
extends NumberEditorHandler {
    private WeightUnit weightUnit;
    boolean displayNullComputedValue = true;

    public void init() {
        PropertyChangeListener l = evt -> this.setComputedTextIfNullModel();
        ComputableData computableData = (ComputableData)((Object)this.ui.getModel().getBean());
        if (computableData != null) {
            computableData.addPropertyChangeListener(l);
        }
        this.ui.getModel().addPropertyChangeListener("bean", evt -> {
            ComputableData newComputableData;
            ComputableData oldComputableData = (ComputableData)((Object)((Object)evt.getOldValue()));
            if (oldComputableData != null) {
                oldComputableData.removePropertyChangeListener("computedData", l);
            }
            if ((newComputableData = (ComputableData)((Object)((Object)evt.getNewValue()))) != null) {
                newComputableData.removePropertyChangeListener("computedData", l);
                newComputableData.addPropertyChangeListener("computedData", l);
            }
        });
        this.ui.getTextField().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JTextField tf = ComputableDataEditorHandler.this.ui.getTextField();
                tf.setFont(TuttiUI.TEXTFIELD_NORMAL_FONT);
                tf.setForeground(Color.BLACK);
                if (ComputableDataEditorHandler.this.ui.getModel().getNumberValue() == null) {
                    tf.setText("");
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                ComputableDataEditorHandler.this.setComputedTextIfNullModel();
            }
        });
        this.ui.addPropertyChangeListener("weightUnit", evt -> {
            this.weightUnit = (WeightUnit)evt.getNewValue();
            this.ui.setNumberPattern(this.weightUnit.getNumberEditorPattern());
        });
        super.init();
    }

    public void reset() {
        this.displayNullComputedValue = false;
        try {
            this.setTextValue("");
        }
        finally {
            this.displayNullComputedValue = true;
        }
    }

    protected void setComputedTextIfNullModel() {
        ComputableData bean = (ComputableData)((Object)this.ui.getModel().getBean());
        JTextField tf = this.ui.getTextField();
        if (bean != null && bean.getData() == null && this.displayNullComputedValue && !tf.isFocusOwner()) {
            tf.setFont(TuttiUI.TEXTFIELD_COMPUTED_FONT);
            tf.setForeground(((ComputableDataEditor)this.ui).getComputedDataColor());
            Object computedData = bean.getComputedData();
            String modelText = this.weightUnit != null ? this.weightUnit.renderWeight((Float)computedData) : JAXXUtil.getStringValue(computedData);
            tf.setText(modelText);
        } else {
            tf.setFont(TuttiUI.TEXTFIELD_NORMAL_FONT);
            tf.setForeground(Color.BLACK);
        }
    }
}

