/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.actions;

import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import jaxx.runtime.swing.JTables;
import org.nuiton.i18n.I18n;

public abstract class SaveSupportAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    final SpeciesFrequencyUI ui;

    public SaveSupportAction(SpeciesFrequencyUI ui) {
        this.ui = ui;
    }

    protected boolean canSaveFrequencies() {
        boolean doSave = true;
        SpeciesFrequencyUIModel model = this.ui.getModel();
        HashSet<Float> lengths = new HashSet<Float>();
        Float doublon = null;
        int index = 0;
        List rows = model.getRows();
        for (SpeciesFrequencyRowModel row : rows) {
            Float lengthStep = row.getLengthStep();
            if (!lengths.add(lengthStep)) {
                doublon = lengthStep;
                break;
            }
            ++index;
        }
        SpeciesFrequencyUIHandler handler = this.ui.getHandler();
        if (doublon != null) {
            String message = I18n.t((String)"tutti.editSpeciesFrequencies.error.length.doublon", (Object[])new Object[]{doublon, index + 1});
            handler.getContext().getErrorHelper().showErrorDialog(message);
            JTables.selectFirstCellOnRow((JTable)this.ui.getTable(), (int)index, (boolean)false);
            doSave = false;
        }
        if (doSave && model.isSomeRowsWithWeightAndOtherWithout()) {
            String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n.t((String)"tutti.editSpeciesFrequencies.askBeforeSave.message", (Object[])new Object[0]), I18n.t((String)"tutti.editSpeciesFrequencies.askBeforeSave.help", (Object[])new Object[0]));
            int answer = JOptionPane.showConfirmDialog(handler.getTopestUI(), htmlMessage, I18n.t((String)"tutti.editSpeciesFrequencies.askBeforeSave.title", (Object[])new Object[0]), 0, 3);
            switch (answer) {
                case 0: {
                    break;
                }
                default: {
                    doSave = false;
                }
            }
        }
        return doSave;
    }
}

