/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.home.actions;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.service.TuttiDataContext;
import fr.ifremer.tutti.service.cruise.CruiseCacheLoader;
import fr.ifremer.tutti.service.export.cps.CalcifiedPiecesSamplingExportService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.content.actions.AbstractMainUITuttiAction;
import java.io.File;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.DateUtil;

public class CalcifiedPiecesSamplingReportAction
extends AbstractMainUITuttiAction {
    private static final Log log = LogFactory.getLog(CalcifiedPiecesSamplingReportAction.class);
    protected File file;

    public CalcifiedPiecesSamplingReportAction(MainUIHandler handler) {
        super(handler, false);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction && !this.getDataContext().isProtocolFilled()) {
            this.displayErrorMessage(I18n.t((String)"tutti.exportCpsCsv.title.missing.protocol", (Object[])new Object[0]), I18n.t((String)"tutti.exportCpsCsv.message.missing.protocol", (Object[])new Object[0]));
            doAction = false;
        }
        if (doAction && !this.getDataContext().getProtocol().isUseCalcifiedPieceSampling()) {
            this.displayErrorMessage(I18n.t((String)"tutti.exportCpsCsv.title.sampling.notActivated", (Object[])new Object[0]), I18n.t((String)"tutti.exportCpsCsv.message.sampling.notActivated", (Object[])new Object[0]));
            doAction = false;
        }
        if (doAction) {
            String date = DateUtil.formatDate((Date)new Date(), (String)"dd-MM-yyyy");
            String exportFilename = I18n.t((String)"tutti.exportCpsCsv.fileName", (Object[])new Object[]{this.getDataContext().getCruise().getName(), date});
            this.file = this.saveFile(exportFilename, "csv", I18n.t((String)"tutti.exportCpsCsv.title.choose.exportFile", (Object[])new Object[0]), I18n.t((String)"tutti.exportCpsCsv.action.chooseFile", (Object[])new Object[0]), new String[]{"^.+\\.csv$", I18n.t((String)"tutti.common.file.csv", (Object[])new Object[0])});
            doAction = this.file != null;
        }
        return doAction;
    }

    @Override
    public void doAction() throws Exception {
        TuttiDataContext dataContext = this.getDataContext();
        Cruise cruise = dataContext.getCruise();
        Preconditions.checkNotNull((Object)cruise);
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export cps for cruise " + cruise.getId() + " to file: " + this.file));
        }
        ProgressionModel pm = new ProgressionModel();
        this.setProgressionModel(pm);
        long cruiseFishingOperationIds = dataContext.getCruiseFishingOperationIds().size();
        pm.setTotal((int)(1L + cruiseFishingOperationIds));
        TuttiUIContext context = this.getContext();
        if (!dataContext.isCruiseCacheLoaded() || !dataContext.isCruiseCacheUpToDate()) {
            CruiseCacheLoader cruiseCacheLoader = context.createCruiseCacheLoader(this.getProgressionModel());
            dataContext.loadCruiseCache(cruiseCacheLoader);
        }
        CalcifiedPiecesSamplingExportService service = context.getCalcifiedPiecesSamplingExportService();
        service.exportCruiseCalcifiedPiecesSamplingsReport(this.file, pm);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        this.sendMessage(I18n.t((String)"tutti.exportCpsCsv.action.success", (Object[])new Object[]{this.file}));
    }

    public void releaseAction() {
        this.file = null;
        super.releaseAction();
    }
}

