/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.sampling;

import com.google.common.base.MoreObjects;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import java.util.Objects;

public class IndividualObservationSamplingCacheRequest {
    private final FishingOperation fishingOperation;
    private final Species species;
    private final Integer lengthClass;
    private Boolean forcedMaturity;
    private CaracteristicQualitativeValue maturity;
    private CaracteristicQualitativeValue gender;
    private final String samplingCode;

    public IndividualObservationSamplingCacheRequest(FishingOperation fishingOperation, Species species, Integer lengthClass, CaracteristicQualitativeValue maturity, CaracteristicQualitativeValue gender, String samplingCode) {
        this.fishingOperation = fishingOperation;
        Objects.requireNonNull(species);
        this.species = species;
        this.lengthClass = lengthClass;
        this.maturity = maturity;
        this.gender = gender;
        this.samplingCode = samplingCode;
        this.forcedMaturity = null;
    }

    public FishingOperation getFishingOperation() {
        return this.fishingOperation;
    }

    public Species getSpecies() {
        return this.species;
    }

    public void setGender(CaracteristicQualitativeValue gender) {
        this.gender = gender;
    }

    public Boolean getForcedMaturity() {
        return this.forcedMaturity;
    }

    public void setForcedMaturity(Boolean forcedMaturity) {
        this.forcedMaturity = forcedMaturity;
        this.maturity = null;
    }

    public Integer getLengthClass() {
        return this.lengthClass;
    }

    public CaracteristicQualitativeValue getMaturity() {
        return this.maturity;
    }

    public CaracteristicQualitativeValue getGender() {
        return this.gender;
    }

    public String getSamplingCode() {
        return this.samplingCode;
    }

    public boolean withMaturity() {
        return this.maturity != null;
    }

    public boolean withGender() {
        return this.gender != null;
    }

    public boolean withLengthClass() {
        return this.lengthClass != null;
    }

    public boolean withSamplingCode() {
        return this.samplingCode != null;
    }

    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this).add("fishingOperation", (Object)this.fishingOperation).add("species", (Object)this.species);
        if (this.withLengthClass()) {
            toStringHelper.add("lengthClass", (Object)this.lengthClass);
        }
        if (this.withMaturity()) {
            toStringHelper.add("maturity", (Object)this.maturity);
        }
        if (this.withGender()) {
            toStringHelper.add("gender", (Object)this.gender);
        }
        if (this.withSamplingCode()) {
            toStringHelper.add("samplingCode", (Object)this.samplingCode);
        }
        return toStringHelper.toString();
    }
}

