/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.psionimport;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.mutable.MutableInt;

public class PsionImportBatchModel {
    protected final Species species;
    protected final Integer lengthStepCaracteristicId;
    protected Float weight;
    protected Float sampleWeight;
    protected final List<SampleCategory> categories;
    protected final Map<Float, MutableInt> frequencies;
    protected String categoryCode;
    protected boolean applyBothWeightOnCategorizedBatch;

    public PsionImportBatchModel(Species species, Integer lengthStepCaracteristicId) {
        this.species = species;
        this.lengthStepCaracteristicId = lengthStepCaracteristicId;
        this.frequencies = Maps.newTreeMap();
        this.categories = Lists.newArrayList();
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    public void setWeight(Float weight) {
        this.weight = weight;
    }

    public void setSampleWeight(Float sampleWeight) {
        this.sampleWeight = sampleWeight;
    }

    public void setCategory(Integer categoryId, Serializable categoryValue) {
        SampleCategory category = new SampleCategory(categoryId, categoryValue);
        this.categories.add(category);
    }

    public void addFrequency(Float size, int number) {
        MutableInt mutableFloat = this.frequencies.get(size);
        if (mutableFloat == null) {
            mutableFloat = new MutableInt(0);
            this.frequencies.put(size, mutableFloat);
        }
        mutableFloat.add(number);
    }

    public Species getSpecies() {
        return this.species;
    }

    public String getCategoryCode() {
        return this.categoryCode;
    }

    public Integer getLengthStepCaracteristicId() {
        return this.lengthStepCaracteristicId;
    }

    public Float getWeight() {
        return this.weight;
    }

    public Float getSampleWeight() {
        return this.sampleWeight;
    }

    public Iterator<SampleCategory> getCategoryIterator() {
        return this.categories.iterator();
    }

    public boolean withFrequencies() {
        return !this.frequencies.isEmpty();
    }

    public boolean withCategories() {
        return !this.categories.isEmpty();
    }

    public Map<Float, MutableInt> getFrequencies() {
        return this.frequencies;
    }

    public int getNbFrequencies() {
        return this.frequencies.size();
    }

    public void setApplyBothWeightOnCategorizedBatch(boolean applyBothWeightOnCategorizedBatch) {
        this.applyBothWeightOnCategorizedBatch = applyBothWeightOnCategorizedBatch;
    }

    public boolean isApplyBothWeightOnCategorizedBatch() {
        return this.applyBothWeightOnCategorizedBatch;
    }

    void merge(PsionImportBatchModel batchModel) {
        this.setWeight(Float.valueOf(this.getWeight().floatValue() + batchModel.getWeight().floatValue()));
        this.setSampleWeight(Float.valueOf(this.getSampleWeight().floatValue() + batchModel.getSampleWeight().floatValue()));
        for (Map.Entry<Float, MutableInt> entry : batchModel.getFrequencies().entrySet()) {
            Float stepClass = entry.getKey();
            int number = entry.getValue().intValue();
            this.addFrequency(stepClass, number);
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("species", (Object)this.species.getSurveyCode()).append("categoryCode", (Object)this.categoryCode).append("weight", (Object)this.weight).append("sampleWeight", (Object)this.sampleWeight).append("frequencies", this.frequencies.size()).toString();
    }

    public static class SampleCategory {
        protected final Integer categoryId;
        protected final Serializable categoryValue;

        public SampleCategory(Integer categoryId, Serializable categoryValue) {
            this.categoryId = categoryId;
            this.categoryValue = categoryValue;
        }

        public Integer getCategoryId() {
            return this.categoryId;
        }

        public Serializable getCategoryValue() {
            return this.categoryValue;
        }
    }
}

