/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.importactions;

import com.google.common.collect.ImmutableList;
import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.service.genericformat.GenericFormatContextSupport;
import fr.ifremer.tutti.service.genericformat.GenericFormatCsvFileResult;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportCruiseContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportOperationContext;
import fr.ifremer.tutti.service.genericformat.GenericformatImportPersistenceHelper;
import fr.ifremer.tutti.service.genericformat.consumer.CsvConsumerForIndividualObservation;
import fr.ifremer.tutti.service.genericformat.csv.AttachmentRow;
import fr.ifremer.tutti.service.genericformat.importactions.ImportActionSupport;
import fr.ifremer.tutti.service.genericformat.importactions.ValidateIndividualObservationAction;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ImportIndividualObservationAction
extends ImportActionSupport {
    private static final Log log = LogFactory.getLog(ImportIndividualObservationAction.class);
    private final GenericformatImportPersistenceHelper persistenceHelper;

    public ImportIndividualObservationAction(GenericFormatImportContext importContext, GenericformatImportPersistenceHelper persistenceHelper) {
        super(importContext);
        this.persistenceHelper = persistenceHelper;
    }

    @Override
    protected boolean canExecute() {
        return this.importContext.isTechnicalFilesValid() && this.importContext.getSurveyFileResult().isValid() && this.importContext.getOperationFileResult().isValid() && this.importContext.getImportRequest().isImportIndividualObservation();
    }

    @Override
    protected void skipExecute() {
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.skip.import.individualObservations", (Object[])new Object[0]));
        if (!this.importContext.getImportRequest().isImportIndividualObservation()) {
            GenericFormatCsvFileResult importFileResult = this.importContext.getIndividualObservationFileResult();
            importFileResult.setSkipped(true);
        }
    }

    @Override
    protected void doExecute() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Import individualObservation.csv file.");
        }
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.import.individualObservations", (Object[])new Object[0]));
        GenericFormatCsvFileResult importFileResult = this.importContext.getIndividualObservationFileResult();
        try (CsvConsumerForIndividualObservation consumer = this.importContext.loadIndividualObservations(true);){
            for (ImportRow row : consumer) {
                GenericFormatImportOperationContext operationContext = consumer.validateRow(row, this.importContext);
                if (operationContext == null) continue;
                consumer.prepareRowForPersist(operationContext, row);
            }
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not close individualObservation.csv file", (Throwable)e);
        }
        catch (ImportRuntimeException e) {
            importFileResult.addGlobalError(e.getMessage());
        }
        this.persistIndividualObservationBatches();
    }

    private void persistIndividualObservationBatches() {
        this.importContext.doActionOnCruiseContexts(new GenericFormatContextSupport.CruiseContextAction(){

            @Override
            public void onCruise(GenericFormatImportCruiseContext cruiseContext, ProgressionModel progressionModel) {
                for (GenericFormatImportOperationContext fishingOperationContext : cruiseContext) {
                    boolean override = fishingOperationContext.isOverride();
                    if (override) {
                        this.deleteIndividualObservationBatches(fishingOperationContext);
                    }
                    String cruiseStr = cruiseContext.getCruiseLabel();
                    String operationStr = fishingOperationContext.getFishingOperationLabel();
                    ImportIndividualObservationAction.this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.persist.operation.individualObservations", (Object[])new Object[]{cruiseStr, operationStr}));
                    if (!fishingOperationContext.withIndividualObservationBatches()) continue;
                    ImmutableList<IndividualObservationBatch> individualObservationBatches = fishingOperationContext.getIndividualObservationBatches();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Check " + individualObservationBatches.size() + " individual observation(s) of " + operationStr + " for cruise: " + cruiseStr));
                    }
                    ValidateIndividualObservationAction.prepareIndividualObservationsForPersist(ImportIndividualObservationAction.this.persistenceHelper, individualObservationBatches);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Persist " + individualObservationBatches.size() + " individual observation(s) of " + operationStr + " for cruise: " + cruiseStr));
                    }
                    this.persistIndividualObservationBatches(fishingOperationContext, individualObservationBatches);
                }
            }

            private void deleteIndividualObservationBatches(GenericFormatImportOperationContext fishingOperationContext) {
                FishingOperation fishingOperation = fishingOperationContext.getFishingOperation();
                ImportIndividualObservationAction.this.persistenceHelper.deleteIndividualObservationBatchForFishingOperation(fishingOperation.getIdAsInt());
            }

            private void persistIndividualObservationBatches(GenericFormatImportOperationContext fishingOperationContext, ImmutableList<IndividualObservationBatch> batches) {
                for (IndividualObservationBatch individualObservation : batches) {
                    Integer batchId = individualObservation.getBatchId();
                    Integer speciesBatchId = fishingOperationContext.getSpeciesBatchId(batchId);
                    Objects.requireNonNull(speciesBatchId, "Persisted Species batch id not found for import species batch id: " + batchId);
                    individualObservation.setBatchId(speciesBatchId);
                }
                ImmutableList.Builder idsBuilder = ImmutableList.builder();
                batches.forEach(batch -> idsBuilder.add((Object)batch.getIdAsInt()));
                ImmutableList importIds = idsBuilder.build();
                batches.forEach(batch -> batch.setId((String)null));
                FishingOperation fishingOperation = fishingOperationContext.getFishingOperation();
                List<IndividualObservationBatch> savedBatches = ImportIndividualObservationAction.this.persistenceHelper.createIndividualObservationBatch(fishingOperation, batches);
                int index = 0;
                for (IndividualObservationBatch savedBatch : savedBatches) {
                    Integer importId = (Integer)importIds.get(index++);
                    Collection<AttachmentRow> attachmentRows = ImportIndividualObservationAction.this.importContext.popAttachmentRows(ObjectTypeCode.SAMPLE, importId);
                    ImportIndividualObservationAction.this.persistenceHelper.persistAttachments(savedBatch.getIdAsInt(), attachmentRows);
                }
            }
        });
    }
}

