/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.catches.multipost;

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.TuttiDataContext;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.catches.multipost.MultiPostConstants;
import fr.ifremer.tutti.service.catches.multipost.csv.AbstractFishingOperationRow;
import fr.ifremer.tutti.service.catches.multipost.csv.AbstractFishingOperationRowModel;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.nuiton.csv.Import;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationBusinessException;
import org.nuiton.jaxx.application.ApplicationIOUtil;
import org.nuiton.util.DateUtil;

public class MultiPostImportContext
implements MultiPostConstants,
Closeable {
    private final File file;
    private final TuttiServiceContext context;
    private final FishingOperation operation;
    protected List<Species> speciesList;
    protected List<Caracteristic> caracteristics;
    protected List<Caracteristic> caracteristicsWithProtected;
    private File explodedDirectory;

    public MultiPostImportContext(TuttiServiceContext context, File file, FishingOperation operation) {
        this.file = file;
        this.context = context;
        this.operation = operation;
    }

    public FishingOperation getOperation() {
        return this.operation;
    }

    public File getExplodedDirectory() {
        if (this.explodedDirectory == null) {
            this.explodedDirectory = ApplicationIOUtil.explodeZip((File)this.context.getConfig().getTmpDirectory(), (File)this.file, (String)I18n.n((String)"tutti.service.multipost.uncompress.error", (Object[])new Object[0]));
        }
        return this.explodedDirectory;
    }

    public List<Species> getSpeciesList() {
        if (this.speciesList == null) {
            TuttiDataContext dataContext = this.context.getDataContext();
            this.speciesList = dataContext.getReferentSpecies();
        }
        return this.speciesList;
    }

    public List<Caracteristic> getCaracteristics() {
        if (this.caracteristics == null) {
            TuttiDataContext dataContext = this.context.getDataContext();
            this.caracteristics = dataContext.getCaracteristics();
        }
        return this.caracteristics;
    }

    public List<Caracteristic> getCaracteristicsWithProtected() {
        if (this.caracteristicsWithProtected == null) {
            TuttiDataContext dataContext = this.context.getDataContext();
            this.caracteristicsWithProtected = dataContext.getCaracteristicWithProtected();
        }
        return this.caracteristicsWithProtected;
    }

    public Reader newFileReader(String fileName) throws IOException {
        return Files.newBufferedReader(new File(this.getExplodedDirectory(), fileName).toPath());
    }

    public File newFile(String fileName) {
        return new File(this.getExplodedDirectory(), fileName);
    }

    @Override
    public void close() throws IOException {
    }

    public <FO extends AbstractFishingOperationRow> void checkSameOperation(String fileName, AbstractFishingOperationRowModel<FO> fishingOperationRowModel) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(new File(this.getExplodedDirectory(), fileName).toPath());
             Import importer = Import.newImport(fishingOperationRowModel, (Reader)reader);){
            Iterator iterator = importer.iterator();
            if (iterator.hasNext()) {
                AbstractFishingOperationRow row = (AbstractFishingOperationRow)iterator.next();
                Date rowDate = DateUtil.getDay((Date)row.getDate());
                Date operationDate = DateUtil.getDay((Date)this.operation.getGearShootingStartDate());
                if (ObjectUtils.notEqual((Object)row.getStationNumber(), (Object)this.operation.getStationNumber()) || ObjectUtils.notEqual((Object)row.getOperationNumber(), (Object)this.operation.getFishingOperationNumber()) || ObjectUtils.notEqual((Object)row.getMultirigAggregation(), (Object)this.operation.getMultirigAggregation()) || ObjectUtils.notEqual((Object)rowDate, (Object)operationDate)) {
                    Decorator<FishingOperation> fishingOperationDecorator = this.context.getService(DecoratorService.class).getDecoratorByType(FishingOperation.class);
                    throw new ApplicationBusinessException(I18n.t((String)"tutti.service.multipost.import.wrongOperation.error", (Object[])new Object[]{fishingOperationDecorator.toString((Object)this.operation)}));
                }
            }
        }
    }
}

