/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.referential;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.dao.referential.StatusCode;
import fr.ifremer.adagio.core.dao.referential.gear.FishingGear;
import fr.ifremer.adagio.core.dao.referential.gear.FishingGearExtendDao;
import fr.ifremer.adagio.core.dao.referential.gear.GearClassification;
import fr.ifremer.adagio.core.dao.referential.gear.GearClassificationId;
import fr.ifremer.adagio.core.dao.referential.gear.GearClassificationImpl;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Gears;
import fr.ifremer.tutti.persistence.service.referential.GearPersistenceService;
import fr.ifremer.tutti.persistence.service.referential.ReferentialPersistenceServiceSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.hibernate.type.IntegerType;
import org.hibernate.type.StringType;
import org.nuiton.jaxx.application.ApplicationBusinessException;
import org.springframework.stereotype.Service;

@Service(value="gearPersistenceService")
public class GearPersistenceServiceImpl
extends ReferentialPersistenceServiceSupport
implements GearPersistenceService {
    @Resource(name="fishingGearDao")
    protected FishingGearExtendDao fishingGearDao;

    @Override
    public List<Gear> getAllScientificGear() {
        Iterator<Object[]> sources = this.queryListWithStatus("allGears", "gearClassificiationId", IntegerType.INSTANCE, GearClassificationId.SCIENTIFIC_CRUISE.getValue());
        ArrayList result = Lists.newArrayList();
        this.loadGears(sources, result);
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<Gear> getAllFishingGear() {
        Iterator<Object[]> sources = this.queryListWithStatus("allGears", "gearClassificiationId", IntegerType.INSTANCE, GearClassificationId.FAO.getValue());
        ArrayList result = Lists.newArrayList();
        this.loadGears(sources, result);
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<Gear> getAllGearWithObsoletes() {
        ArrayList result = Lists.newArrayList();
        Iterator<Object[]> fishingSources = this.queryListWithStatus2("allGearsWithObsoletes", "gearClassificiationId", IntegerType.INSTANCE, GearClassificationId.FAO.getValue());
        this.loadGears(fishingSources, result);
        Iterator<Object[]> scientificSources = this.queryListWithStatus2("allGearsWithObsoletes", "gearClassificiationId", IntegerType.INSTANCE, GearClassificationId.SCIENTIFIC_CRUISE.getValue());
        this.loadGears(scientificSources, result);
        return Collections.unmodifiableList(result);
    }

    @Override
    public Gear getGear(Integer gearId) {
        Object[] source = this.queryUniqueWithStatus2("gearById", "gearId", IntegerType.INSTANCE, gearId);
        return source == null ? null : this.loadGear(source);
    }

    protected void loadGears(Iterator<Object[]> sources, List<Gear> result) {
        while (sources.hasNext()) {
            Object[] source = sources.next();
            Gear target = this.loadGear(source);
            result.add(target);
        }
    }

    @Override
    public boolean isTemporaryGearUsed(Integer id) {
        boolean result;
        Long count = (Long)this.queryUniqueTyped("countGearInGearPhysicalFeatures", "id", IntegerType.INSTANCE, id);
        boolean bl = result = count > 0L;
        if (!result) {
            count = (Long)this.queryUniqueTyped("countGearInGearUseFeatures", "id", IntegerType.INSTANCE, id);
            result = count > 0L;
        }
        return result;
    }

    @Override
    public List<Gear> addTemporaryGears(List<Gear> gears) {
        ArrayList result = Lists.newArrayList();
        for (Gear source : gears) {
            Gear added = this.addTemporaryGear(source);
            result.add(added);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<Gear> updateTemporaryGears(List<Gear> gears) {
        ArrayList result = Lists.newArrayList();
        for (Gear source : gears) {
            Gear updated = this.updateTemporaryGear(source);
            result.add(updated);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<Gear> linkTemporaryGears(List<Gear> gears) {
        ArrayList result = Lists.newArrayList();
        for (Gear source : gears) {
            Gear linked = this.linkTemporaryGear(source);
            result.add(linked);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public void replaceGear(Gear source, Gear target, boolean delete) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)target);
        Preconditions.checkState((boolean)Gears.isTemporary(source));
        Preconditions.checkState((!Gears.isTemporary(target) ? 1 : 0) != 0);
        Integer sourceId = source.getIdAsInt();
        Integer targetId = target.getIdAsInt();
        this.queryUpdate("replaceGearInGearPhysicalFeatures", "sourceId", IntegerType.INSTANCE, sourceId, "targetId", IntegerType.INSTANCE, targetId);
        this.queryUpdate("replaceGearInGearUseFeatures", "sourceId", IntegerType.INSTANCE, sourceId, "targetId", IntegerType.INSTANCE, targetId);
        if (delete) {
            this.deleteTemporaryGear(sourceId);
        }
    }

    @Override
    public void deleteTemporaryGears(Collection<Integer> ids) {
        for (Integer id : ids) {
            this.deleteTemporaryGear(id);
        }
    }

    @Override
    public void deleteTemporaryGear(Integer id) {
        Preconditions.checkNotNull((Object)id);
        if (id > 0) {
            throw new ApplicationBusinessException(String.format("Can't delete a Gear with a positive id %d.", id));
        }
        Gear gear = this.getGear(id);
        if (gear == null) {
            throw new ApplicationBusinessException(String.format("Gear with id %d does not exists", id));
        }
        this.fishingGearDao.remove(id);
    }

    protected Gear addTemporaryGear(Gear source) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)source.getLabel());
        Preconditions.checkNotNull((Object)source.getName());
        Preconditions.checkArgument((source.getId() == null || Gears.isTemporaryId(source.getIdAsInt()) ? 1 : 0) != 0);
        Integer gearClassificationId = this.getGearClassificationId(source);
        FishingGear target = this.fishingGearDao.createAsTemporary(source.getLabel(), source.getName(), gearClassificationId);
        Gear result = Gears.newGear();
        result.setId(target.getId());
        result.setLabel(source.getLabel());
        result.setName(source.getName());
        result.setScientificGear(source.isScientificGear());
        this.setStatus(StatusCode.TEMPORARY.getValue(), result);
        return result;
    }

    protected Gear updateTemporaryGear(Gear source) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)source.getId());
        Preconditions.checkNotNull((Object)source.getLabel());
        Preconditions.checkNotNull((Object)source.getName());
        Preconditions.checkArgument((boolean)Gears.isTemporaryId(source.getIdAsInt()));
        Gear result = this.getGear(source.getIdAsInt());
        result.setLabel(source.getLabel());
        result.setName(source.getName());
        result.setScientificGear(source.isScientificGear());
        this.setStatus(StatusCode.TEMPORARY.getValue(), result);
        FishingGear toUpdate = this.fishingGearDao.load(source.getIdAsInt());
        toUpdate.setLabel(result.getLabel());
        toUpdate.setName(result.getName());
        Integer gearClassificationId = this.getGearClassificationId(source);
        toUpdate.setGearClassification((GearClassification)this.load(GearClassificationImpl.class, gearClassificationId));
        this.fishingGearDao.update(toUpdate);
        return result;
    }

    private Integer getGearClassificationId(Gear source) {
        Integer gearClassificationId = source.isScientificGear() ? GearClassificationId.SCIENTIFIC_CRUISE.getValue() : GearClassificationId.FAO.getValue();
        return gearClassificationId;
    }

    protected Gear linkTemporaryGear(Gear source) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)source.getId());
        Preconditions.checkNotNull((Object)source.getLabel());
        Preconditions.checkNotNull((Object)source.getName());
        Preconditions.checkArgument((boolean)Gears.isTemporaryId(source.getIdAsInt()));
        Object[] row = this.queryUniqueWithStatus2("gearByName", "gearName", StringType.INSTANCE, source.getName());
        return row == null ? null : this.loadGear(row);
    }

    protected Gear loadGear(Object ... source) {
        Gear result = Gears.newGear();
        result.setId(String.valueOf(source[0]));
        result.setLabel((String)source[1]);
        result.setName((String)source[2]);
        Integer classification = (Integer)source[3];
        boolean scientific = false;
        if (classification != null) {
            scientific = GearClassificationId.SCIENTIFIC_CRUISE.getValue().equals(classification);
        }
        result.setScientificGear(scientific);
        this.setStatus((String)source[4], result);
        return result;
    }
}

