/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.technical.liquibase;

import fr.ifremer.adagio.core.AdagioTechnicalException;
import fr.ifremer.adagio.core.config.AdagioConfiguration;
import fr.ifremer.adagio.core.config.AdagioConfigurationOption;
import fr.ifremer.adagio.core.dao.technical.DaoUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import javax.xml.parsers.ParserConfigurationException;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.diff.DiffResult;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.DiffToChangeLog;
import liquibase.diff.output.report.DiffToReport;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.integration.commandline.CommandLineUtils;
import liquibase.logging.LogFactory;
import liquibase.logging.Logger;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.structure.core.DatabaseObjectFactory;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.version.Version;
import org.nuiton.util.version.Versions;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.stereotype.Component;

@Component(value="liquibase")
@Lazy
public class Liquibase
implements InitializingBean,
BeanNameAware,
ResourceLoaderAware {
    protected static final String CHANGE_LOG_SNAPSHOT_SUFFIX = "-SNAPSHOT.xml";
    private String beanName;
    private ResourceLoader resourceLoader;
    private DataSource dataSource;
    private AdagioConfiguration config;
    private String changeLog;
    private String defaultSchema;
    private String contexts;
    private Map<String, String> parameters;
    protected Version maxChangeLogFileVersion;

    @Autowired
    public Liquibase(DataSource dataSource, AdagioConfiguration config) {
        this.dataSource = dataSource;
        this.config = config;
    }

    public Liquibase(AdagioConfiguration config) {
        this.dataSource = null;
        this.config = config;
        this.setChangeLog(config.getLiquibaseChangeLogPath());
    }

    public Liquibase(String changeLogPath) {
        this.dataSource = null;
        this.config = AdagioConfiguration.getInstance();
        this.setChangeLog(changeLogPath);
    }

    public void afterPropertiesSet() throws LiquibaseException {
        this.setChangeLog(this.config.getLiquibaseChangeLogPath());
        this.computeMaxChangeLogFileVersion();
        boolean shouldRun = AdagioConfiguration.getInstance().useLiquibaseAutoRun();
        if (!shouldRun) {
            this.getLog().debug(String.format("Liquibase did not run because properties '%s' set to false.", AdagioConfigurationOption.LIQUIBASE_RUN_AUTO.getKey()));
            return;
        }
        this.executeUpdate();
    }

    public String getDatabaseProductName() throws DatabaseException {
        Connection connection = null;
        String name = "unknown";
        try {
            connection = this.createConnection();
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(this.dataSource.getConnection()));
            name = database.getDatabaseProductName();
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    if (!connection.getAutoCommit()) {
                        connection.rollback();
                    }
                }
                catch (Exception e) {
                    this.getLog().warning("Problem rollback connection", (Throwable)e);
                }
                this.releaseConnection(connection);
            }
        }
        return name;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getChangeLog() {
        return this.changeLog;
    }

    public void setChangeLog(String dataModel) {
        this.changeLog = dataModel;
    }

    public String getContexts() {
        return this.contexts;
    }

    public void setContexts(String contexts) {
        this.contexts = contexts;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public void executeUpdate() throws LiquibaseException {
        this.executeUpdate(null);
    }

    public void executeUpdate(Properties connectionProperties) throws LiquibaseException {
        Connection c = null;
        try {
            c = this.createConnection(connectionProperties);
            liquibase.Liquibase liquibase = this.createLiquibase(c);
            liquibase.forceReleaseLocks();
            this.performUpdate(liquibase);
            liquibase.forceReleaseLocks();
            DaoUtils.compactDatabase(c);
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
        finally {
            if (c != null) {
                try {
                    c.rollback();
                }
                catch (SQLException sQLException) {}
                this.releaseConnection(c);
            }
        }
    }

    protected void performUpdate(liquibase.Liquibase liquibase) throws LiquibaseException {
        liquibase.update(this.getContexts());
    }

    public void reportStatus(Writer writer) throws LiquibaseException {
        Connection c = null;
        Writer myWriter = null;
        try {
            c = this.createConnection();
            liquibase.Liquibase liquibase = this.createLiquibase(c);
            liquibase.forceReleaseLocks();
            if (writer != null) {
                this.performReportStatus(liquibase, writer);
            } else {
                myWriter = new OutputStreamWriter(System.out);
                this.performReportStatus(liquibase, myWriter);
            }
            liquibase.forceReleaseLocks();
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
        finally {
            if (c != null) {
                try {
                    c.rollback();
                }
                catch (SQLException sQLException) {}
                this.releaseConnection(c);
            }
            if (myWriter != null) {
                try {
                    myWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void performReportStatus(liquibase.Liquibase liquibase, Writer writer) throws LiquibaseException {
        liquibase.reportStatus(true, this.getContexts(), writer);
    }

    protected liquibase.Liquibase createLiquibase(Connection c) throws LiquibaseException {
        String adjustedChangeLog = this.getChangeLog();
        if (this.resourceLoader == null) {
            adjustedChangeLog = this.adjustNoFilePrefix(this.adjustNoClasspath(adjustedChangeLog));
        }
        liquibase.Liquibase liquibase = new liquibase.Liquibase(adjustedChangeLog, this.createResourceAccessor(), this.createDatabase(c));
        if (this.parameters != null) {
            for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                liquibase.setChangeLogParameter(entry.getKey(), (Object)entry.getValue());
            }
        }
        return liquibase;
    }

    protected Database createDatabase(Connection c) throws DatabaseException {
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(c));
        if (StringUtils.trimToNull((String)this.defaultSchema) != null) {
            database.setDefaultSchemaName(this.defaultSchema);
        }
        return database;
    }

    protected Database createHibernateDatabase() throws DatabaseException {
        Database referenceDatabase = CommandLineUtils.createDatabaseObject((ClassLoader)this.getClass().getClassLoader(), (String)"hibernate:classic:hibernate.cfg.xml", null, null, null, (String)this.config.getJdbcCatalog(), (String)this.config.getJdbcSchema(), (boolean)false, (boolean)false, null, null, null, null);
        return referenceDatabase;
    }

    public void setChangeLogParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    protected ResourceAccessor createResourceAccessor() {
        if (this.resourceLoader != null) {
            return new SpringResourceAccessor(this.getChangeLog());
        }
        if (this.isClasspathPrefixPresent(this.changeLog)) {
            return new ClassLoaderResourceAccessor(this.getClass().getClassLoader());
        }
        return new FileSystemResourceAccessor(new File(this.adjustNoFilePrefix(this.changeLog)).getParent());
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.getResourceLoader().toString() + ")";
    }

    protected void computeMaxChangeLogFileVersion() {
        this.maxChangeLogFileVersion = null;
        String changeLogPath = this.getChangeLog();
        if (StringUtils.isBlank((CharSequence)changeLogPath)) {
            return;
        }
        int index = (changeLogPath = changeLogPath.replaceAll("\\\\", "/")).lastIndexOf(47);
        if (index == -1 || index == changeLogPath.length() - 1) {
            return;
        }
        String changeLogWithVersionRegex = changeLogPath.substring(index + 1);
        changeLogWithVersionRegex = changeLogWithVersionRegex.replaceAll("master\\.xml", "([0-9]\\\\.[.-_a-zA-Z]+)\\\\.xml");
        Pattern changeLogWithVersionPattern = Pattern.compile(changeLogWithVersionRegex);
        Version maxVersion = null;
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(this.resourceLoader);
        try {
            Resource[] resources;
            String pathPrefix = changeLogPath.substring(0, index);
            for (Resource resource : resources = resolver.getResources(pathPrefix + "/db-changelog-*.xml")) {
                String fileVersion;
                String filename = resource.getFilename();
                Matcher matcher = changeLogWithVersionPattern.matcher(filename);
                if (!matcher.matches() || (fileVersion = matcher.group(1)).endsWith(CHANGE_LOG_SNAPSHOT_SUFFIX)) continue;
                try {
                    Version version = Versions.valueOf((String)fileVersion);
                    if (maxVersion != null && maxVersion.compareTo(version) >= 0) continue;
                    maxVersion = version;
                }
                catch (IllegalArgumentException iae) {
                    this.getLog().warning(String.format("Bad format version found in file: %s/%s. Ignoring this file when computing the max schema version.", changeLogPath, filename));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get changelog files", e);
        }
        if (maxVersion != null) {
            this.maxChangeLogFileVersion = maxVersion;
        }
    }

    public Version getMaxChangeLogFileVersion() {
        return this.maxChangeLogFileVersion;
    }

    public void reportDiff(File outputFile, String typesToControl) throws LiquibaseException {
        Connection c = null;
        PrintStream writer = null;
        try {
            c = this.createConnection();
            liquibase.Liquibase liquibase = this.createLiquibase(c);
            liquibase.forceReleaseLocks();
            DiffResult diffResult = this.performDiff(liquibase, typesToControl);
            liquibase.forceReleaseLocks();
            writer = outputFile != null ? new PrintStream(outputFile) : null;
            new DiffToReport(diffResult, writer != null ? writer : System.out).print();
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new AdagioTechnicalException("Could not write diff report file.", e);
        }
        finally {
            if (c != null) {
                try {
                    c.rollback();
                }
                catch (SQLException sQLException) {}
                this.releaseConnection(c);
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    public void generateDiffChangelog(File changeLogFile, String typesToControl) throws LiquibaseException {
        Connection c = null;
        PrintStream writer = null;
        try {
            c = this.createConnection();
            liquibase.Liquibase liquibase = this.createLiquibase(c);
            liquibase.forceReleaseLocks();
            DiffResult diffResult = this.performDiff(liquibase, typesToControl);
            liquibase.forceReleaseLocks();
            writer = changeLogFile != null ? new PrintStream(changeLogFile) : null;
            DiffOutputControl diffOutputControl = new DiffOutputControl(false, false, false);
            new DiffToChangeLog(diffResult, diffOutputControl).print(writer != null ? writer : System.out);
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new AdagioTechnicalException("Could not generate changelog file.", e);
        }
        catch (ParserConfigurationException e) {
            throw new AdagioTechnicalException("Could not generate changelog file.", e);
        }
        catch (IOException e) {
            throw new AdagioTechnicalException("Could not generate changelog file.", e);
        }
        finally {
            if (c != null) {
                try {
                    c.rollback();
                }
                catch (SQLException sQLException) {}
                this.releaseConnection(c);
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    protected DiffResult performDiff(liquibase.Liquibase liquibase, String typesToControl) throws LiquibaseException {
        Database referenceDatabase = this.createHibernateDatabase();
        CompareControl compareControl = new CompareControl(DatabaseObjectFactory.getInstance().parseTypes(typesToControl));
        DiffResult diffResult = liquibase.diff(referenceDatabase, liquibase.getDatabase(), compareControl);
        return diffResult;
    }

    protected Logger getLog() {
        return LogFactory.getInstance().getLog();
    }

    protected Connection createConnection() throws SQLException {
        return this.createConnection(null);
    }

    protected Connection createConnection(Properties connectionProperties) throws SQLException {
        Properties targetConnectionProperties = connectionProperties != null ? connectionProperties : this.config.getConnectionProperties();
        String jdbcUrl = targetConnectionProperties.getProperty("hibernate.connection.url");
        if (Objects.equals(this.config.getJdbcURL(), jdbcUrl) && this.dataSource != null) {
            return DataSourceUtils.getConnection((DataSource)this.dataSource);
        }
        return DaoUtils.createConnection(targetConnectionProperties);
    }

    protected void releaseConnection(Connection conn) {
        if (this.dataSource != null) {
            DataSourceUtils.releaseConnection((Connection)conn, (DataSource)this.dataSource);
            return;
        }
        DaoUtils.closeSilently(conn);
    }

    protected String adjustClasspath(String parentFile, String file) {
        return this.isClasspathPrefixPresent(parentFile) && !this.isClasspathPrefixPresent(file) ? "classpath:" + file : file;
    }

    protected String adjustNoClasspath(String file) {
        return this.isClasspathPrefixPresent(file) ? file.substring("classpath:".length()) : file;
    }

    protected boolean isClasspathPrefixPresent(String file) {
        return file.startsWith("classpath:");
    }

    protected boolean isFilePrefixPresent(String file) {
        return file.startsWith("file:");
    }

    protected String adjustNoFilePrefix(String file) {
        return this.isFilePrefixPresent(file) ? file.substring("file:".length()) : file;
    }

    public class SpringResourceAccessor
    implements ResourceAccessor {
        private String parentFile;

        public SpringResourceAccessor(String parentFile) {
            this.parentFile = parentFile;
        }

        public InputStream getResourceAsStream(String file) throws IOException {
            try {
                Resource resource = this.getResource(file);
                return resource.getInputStream();
            }
            catch (FileNotFoundException ex) {
                return null;
            }
        }

        public Enumeration<URL> getResources(String packageName) throws IOException {
            Vector<URL> tmp = new Vector<URL>();
            tmp.add(this.getResource(packageName).getURL());
            return tmp.elements();
        }

        public Resource getResource(String file) {
            return Liquibase.this.resourceLoader.getResource(Liquibase.this.adjustClasspath(this.parentFile, file));
        }

        public ClassLoader toClassLoader() {
            return Liquibase.this.getResourceLoader().getClassLoader();
        }
    }
}

