/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.meta;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.SubscriberExceptionContext;
import com.google.common.eventbus.SubscriberExceptionHandler;
import fr.ifremer.adagio.synchro.SynchroTechnicalException;
import fr.ifremer.adagio.synchro.dao.Daos;
import fr.ifremer.adagio.synchro.intercept.SynchroInterceptor;
import fr.ifremer.adagio.synchro.meta.SynchroColumnMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroJoinMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroMetadataUtils;
import fr.ifremer.adagio.synchro.meta.event.CreateQueryEvent;
import fr.ifremer.adagio.synchro.meta.event.LoadJoinEvent;
import fr.ifremer.adagio.synchro.meta.event.LoadPkEvent;
import fr.ifremer.adagio.synchro.meta.event.LoadTableEvent;
import fr.ifremer.adagio.synchro.query.SynchroQueryBuilder;
import fr.ifremer.adagio.synchro.query.SynchroQueryName;
import fr.ifremer.adagio.synchro.service.SynchroDatabaseConfiguration;
import java.lang.reflect.Field;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.LockMode;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.tool.hbm2ddl.ColumnMetadata;
import org.hibernate.tool.hbm2ddl.ForeignKeyMetadata;
import org.hibernate.tool.hbm2ddl.IndexMetadata;
import org.hibernate.tool.hbm2ddl.TableMetadata;
import org.nuiton.i18n.I18n;

public class SynchroTableMetadata {
    private static final Log log = LogFactory.getLog(SynchroTableMetadata.class);
    public static final String PK_SEPARATOR = "~~";
    public static final String UPDATE_DATE_BINDPARAM = "updateDate";
    private static Field delegateTableMetadataColumnsField = null;
    protected final String selectPksStrQuery;
    protected final String selectPksQuery;
    protected final String selectMaxUpdateDateQuery;
    protected final String selectUpdateDateByPkQuery;
    protected final String countAllQuery;
    protected final TableMetadata delegate;
    protected final Map<String, SynchroColumnMetadata> columns;
    protected List<SynchroJoinMetadata> childJoins;
    protected List<SynchroJoinMetadata> parentJoins;
    protected List<SynchroJoinMetadata> joins;
    protected boolean hasJoins;
    protected boolean hasChildJoins;
    protected final List<String> columnNames;
    protected final List<String> selectColumnNames;
    protected final List<String> insertColumnNames;
    protected final int columnCount;
    protected final int selectColumnCount;
    protected final Set<String> pkNames;
    protected final int[] selectPkIndexs;
    protected String insertQuery;
    protected String updateQuery;
    protected final int updateDateIndexInSelectQuery;
    protected final boolean withUpdateDateColumn;
    protected final boolean withIdColumn;
    protected boolean isRoot;
    protected final String countQuery;
    protected final String countFromUpdateDateQuery;
    protected final String selectFromUpdateDateQuery;
    protected final String selectAllQuery;
    protected final String selectByPkQuery;
    protected final String deleteByPkQuery;
    protected final Map<String, List<String>> uniqueConstraints;
    protected final Map<String, DuplicateKeyStrategy> duplicateKeyStrategies;
    protected Map<String, String> selectPksByIndexQueries;
    protected String sequenceName;
    protected String selectSequenceNextValString;
    protected String sequenceNextValString;
    protected List<SynchroInterceptor> interceptors;
    protected boolean hasUniqueConstraints;
    protected LockMode lockModeOnUpdate;
    protected boolean isBuild;
    protected SynchroDatabaseMetadata dbMeta;
    protected Dialect dialect;
    protected EventBus eventBus;

    public static Map<String, ColumnMetadata> getColumns(TableMetadata delegate) {
        try {
            if (delegateTableMetadataColumnsField == null) {
                delegateTableMetadataColumnsField = TableMetadata.class.getDeclaredField("columns");
                delegateTableMetadataColumnsField.setAccessible(true);
            }
            return Maps.newLinkedHashMap((Map)((Map)delegateTableMetadataColumnsField.get(delegate)));
        }
        catch (Exception e) {
            throw new SynchroTechnicalException(e.getMessage(), e);
        }
    }

    public static String toPkStr(List<Object> pkList) {
        StringBuilder sb = new StringBuilder();
        for (Object pk : pkList) {
            sb.append(PK_SEPARATOR).append(pk);
        }
        return sb.substring(PK_SEPARATOR.length());
    }

    public static String toPkStr(Object[] pkList) {
        StringBuilder sb = new StringBuilder();
        for (Object pk : pkList) {
            sb.append(PK_SEPARATOR).append(pk);
        }
        return sb.substring(PK_SEPARATOR.length());
    }

    public static List<Object> fromPkStr(String pkStr) {
        String[] split;
        ArrayList pkList = Lists.newArrayList();
        for (String s : split = pkStr.split(PK_SEPARATOR)) {
            if ("null".equals(s)) {
                s = null;
            }
            pkList.add(s);
        }
        return pkList;
    }

    public static List<List<Object>> fromPksStr(Set<String> pksStr) {
        List result = Lists.transform((List)ImmutableList.copyOf(pksStr), (Function)new Function<String, List<Object>>(){

            public List<Object> apply(String pkStr) {
                return SynchroTableMetadata.fromPkStr(pkStr);
            }
        });
        return result;
    }

    protected SynchroTableMetadata(SynchroDatabaseMetadata dbMeta, TableMetadata delegate, Dialect dialect, List<Object> listeners, String tableName, Predicate<SynchroColumnMetadata> columnFilter, boolean enableQueries) {
        Preconditions.checkNotNull((Object)delegate);
        Preconditions.checkNotNull((Object)dbMeta);
        this.isBuild = false;
        this.dbMeta = dbMeta;
        this.dialect = dialect;
        this.delegate = delegate;
        this.eventBus = this.initEventBus(enableQueries, listeners, delegate.getName());
        this.interceptors = this.initInterceptors(listeners);
        SynchroDatabaseConfiguration config = dbMeta.getConfiguration();
        try {
            this.columns = this.initColumns(dialect, tableName, columnFilter);
            this.columnNames = this.initColumnNames(this.columns);
            this.columnCount = this.columnNames.size();
            this.pkNames = this.initPrimaryKeys(dbMeta);
            Preconditions.checkNotNull(this.pkNames);
            this.uniqueConstraints = Maps.newLinkedHashMap();
            this.duplicateKeyStrategies = Maps.newHashMap();
            this.initUniqueConstraints(dbMeta);
            this.hasUniqueConstraints = MapUtils.isNotEmpty(this.uniqueConstraints);
            this.withIdColumn = this.columnNames.contains(config.getColumnId());
            this.withUpdateDateColumn = this.columnNames.contains(config.getColumnUpdateDate());
            this.sequenceName = this.initSequenceName(dbMeta);
        }
        catch (Exception e) {
            throw new SynchroTechnicalException(I18n.t((String)"adagio.synchro.meta.table.instanciation.error", (Object[])new Object[]{delegate.getName()}), e);
        }
        if (enableQueries) {
            this.selectSequenceNextValString = this.createSelectSequenceNextValString(dialect, this.sequenceName);
            this.sequenceNextValString = this.createSequenceNextValString(dialect, this.sequenceName);
            this.countAllQuery = this.createAllCountQuery();
            this.countQuery = this.createCountQuery();
            this.countFromUpdateDateQuery = this.createCountFromUpdateDate(config);
            this.selectMaxUpdateDateQuery = this.createSelectMaxUpdateDateQuery(config);
            this.selectUpdateDateByPkQuery = this.createSelectUpdateDateByPkQuery(config);
            this.selectAllQuery = this.createSelectAllQuery();
            this.selectFromUpdateDateQuery = this.createSelectFromUpdateDateQuery(config);
            this.selectByPkQuery = this.createSelectByPkQuery();
            this.selectPksStrQuery = this.createSelectPksStrQuery(config);
            this.selectPksQuery = this.createSelectPksQuery(config);
            this.insertQuery = this.createInsertQuery();
            this.updateQuery = this.createUpdateQuery();
            this.selectPksByIndexQueries = this.createSelectPksByIndexQueries(config);
            this.selectColumnNames = this.initColumnNamesFromQuery(this.selectAllQuery);
            this.insertColumnNames = this.initColumnNamesFromQuery(this.insertQuery);
            this.selectPkIndexs = this.createSelectPkIndex(this.selectColumnNames);
            Preconditions.checkArgument((this.selectPkIndexs.length == this.pkNames.size() ? 1 : 0) != 0, (Object)"Could not found all table PKs in the select query. This is require.");
            this.selectColumnCount = this.selectColumnNames.size();
            this.updateDateIndexInSelectQuery = this.selectColumnNames.indexOf(config.getColumnUpdateDate());
            this.deleteByPkQuery = this.createDeleteByPk();
        } else {
            this.selectSequenceNextValString = null;
            this.sequenceNextValString = null;
            this.countAllQuery = null;
            this.countQuery = null;
            this.countFromUpdateDateQuery = null;
            this.selectMaxUpdateDateQuery = null;
            this.selectUpdateDateByPkQuery = null;
            this.selectAllQuery = null;
            this.selectFromUpdateDateQuery = null;
            this.selectByPkQuery = null;
            this.selectPksStrQuery = null;
            this.selectPksQuery = null;
            this.insertQuery = null;
            this.updateQuery = null;
            this.selectPksByIndexQueries = null;
            this.selectColumnNames = Lists.newArrayList();
            this.insertColumnNames = Lists.newArrayList();
            this.selectColumnCount = 0;
            this.updateDateIndexInSelectQuery = -1;
            this.selectPkIndexs = null;
            this.deleteByPkQuery = null;
        }
        this.joins = Lists.newArrayList();
        this.hasJoins = false;
        this.parentJoins = null;
        this.hasChildJoins = false;
        this.lockModeOnUpdate = LockMode.NONE;
        this.isRoot = false;
    }

    SynchroTableMetadata() {
        this.isBuild = false;
        this.eventBus = null;
        this.delegate = null;
        this.columns = null;
        this.columnNames = null;
        this.selectSequenceNextValString = null;
        this.sequenceNextValString = null;
        this.joins = null;
        this.pkNames = null;
        this.selectPkIndexs = null;
        this.updateDateIndexInSelectQuery = -1;
        this.withUpdateDateColumn = false;
        this.withIdColumn = false;
        this.isRoot = false;
        this.insertQuery = null;
        this.updateQuery = null;
        this.countAllQuery = null;
        this.countQuery = null;
        this.countFromUpdateDateQuery = null;
        this.selectPksStrQuery = null;
        this.selectPksQuery = null;
        this.selectMaxUpdateDateQuery = null;
        this.selectUpdateDateByPkQuery = null;
        this.selectFromUpdateDateQuery = null;
        this.sequenceName = null;
        this.selectAllQuery = null;
        this.selectByPkQuery = null;
        this.columnCount = 0;
        this.selectPksByIndexQueries = null;
        this.uniqueConstraints = null;
        this.duplicateKeyStrategies = null;
        this.selectColumnNames = null;
        this.insertColumnNames = null;
        this.selectColumnCount = 0;
        this.lockModeOnUpdate = LockMode.NONE;
        this.deleteByPkQuery = null;
    }

    public void initJoins(SynchroDatabaseMetadata dbMeta) {
        try {
            this.joins = this.initJoins(this.getCatalog(), this.getSchema(), this.getName(), dbMeta, this.columns);
            this.hasJoins = !this.joins.isEmpty();
            this.childJoins = this.initChildJoins(this.joins);
            this.parentJoins = this.initParentJoins(this.joins);
            this.hasChildJoins = !this.childJoins.isEmpty();
        }
        catch (Exception e) {
            throw new SynchroTechnicalException(I18n.t((String)"adagio.synchro.meta.table.instanciation.error", (Object[])new Object[]{this.delegate.getName()}), e);
        }
    }

    public Set<String> getPkNames() {
        return this.pkNames;
    }

    public boolean isWithUpdateDateColumn() {
        return this.withUpdateDateColumn;
    }

    public boolean isWithIdColumn() {
        return this.withIdColumn;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void setRoot(boolean isRoot) {
        this.isRoot = isRoot;
    }

    public int getColumnsCount() {
        return this.columnCount;
    }

    public Set<String> getColumnNames() {
        return ImmutableSet.copyOf(this.columnNames);
    }

    public int getSelectColumnsCount() {
        return this.selectColumnCount;
    }

    public Set<String> getSelectColumnNames() {
        return ImmutableSet.copyOf(this.selectColumnNames);
    }

    public String getColumnName(int columnIndex) {
        return this.columnNames.get(columnIndex);
    }

    public int getColumnIndex(String name) {
        return this.columnNames.indexOf(name.toLowerCase());
    }

    public int getSelectColumnIndex(String name) {
        return this.selectColumnNames.indexOf(name.toLowerCase());
    }

    public int getInsertColumnIndex(String name) {
        return this.insertColumnNames.indexOf(name.toLowerCase());
    }

    public TableMetadata getDelegate() {
        return this.delegate;
    }

    public String getName() {
        return this.delegate.getName();
    }

    public ForeignKeyMetadata getForeignKeyMetadata(ForeignKey fk) {
        return this.delegate.getForeignKeyMetadata(fk);
    }

    public SynchroColumnMetadata getColumnMetadata(String columnName) {
        return this.columns.get(StringHelper.toLowerCase((String)columnName));
    }

    public String getSchema() {
        return this.delegate.getSchema();
    }

    public String getCatalog() {
        return this.delegate.getCatalog();
    }

    public ForeignKeyMetadata getForeignKeyMetadata(String keyName) {
        return this.delegate.getForeignKeyMetadata(keyName);
    }

    public IndexMetadata getIndexMetadata(String indexName) {
        return this.delegate.getIndexMetadata(indexName);
    }

    public SynchroColumnMetadata getColumn(String columnName) {
        return this.columns.get(columnName);
    }

    public List<SynchroJoinMetadata> getJoins() {
        return this.joins;
    }

    public List<SynchroJoinMetadata> getChildJoins() {
        return this.childJoins;
    }

    public List<SynchroJoinMetadata> getParentJoins() {
        return this.parentJoins;
    }

    public boolean hasJoins() {
        return this.hasJoins;
    }

    public boolean hasChildJoins() {
        return this.hasChildJoins;
    }

    public LockMode getLockModeOnUpdate() {
        return this.lockModeOnUpdate;
    }

    public void setLockOnUpdate(LockMode lockModeOnUpdate) {
        this.lockModeOnUpdate = lockModeOnUpdate;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public List<SynchroInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public String getTableLogPrefix() {
        return "[" + this.getName() + "]";
    }

    public String toString() {
        return this.delegate.toString();
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public String getInsertQuery() {
        return this.insertQuery;
    }

    public String getUpdateQuery() {
        return this.updateQuery;
    }

    public String getSelectPksStrQuery() {
        return this.selectPksStrQuery;
    }

    public String getSelectPksQuery() {
        return this.selectPksQuery;
    }

    public String getSelectMaxUpdateDateQuery() {
        return this.selectMaxUpdateDateQuery;
    }

    public String getSelectUpdateDateByPkQuery() {
        return this.selectUpdateDateByPkQuery;
    }

    public String getSelectDataQueryFromPk() {
        return this.selectByPkQuery;
    }

    public String getSelectAllQuery() {
        return this.selectAllQuery;
    }

    public String getSelectUpdatedDataQuery() {
        return this.selectFromUpdateDateQuery;
    }

    public String getDeleteByPkQuery() {
        return this.deleteByPkQuery;
    }

    public String getSequenceNextValString() {
        return this.sequenceNextValString;
    }

    public String getSelectSequenceNextValString() {
        return this.selectSequenceNextValString;
    }

    public String getCountAllQuery() {
        return this.countAllQuery;
    }

    public String getCountQuery() {
        return this.countQuery;
    }

    public String getCountUpdatedDataQuery() {
        if (this.countFromUpdateDateQuery == null) {
            return null;
        }
        return this.countFromUpdateDateQuery;
    }

    public int[] getSelectPkIndexs() {
        return this.selectPkIndexs;
    }

    public boolean isSimpleKey() {
        return this.selectPkIndexs.length == 1;
    }

    public boolean isSelectPrimaryKeysAsStringQueryEnable() {
        return this.selectPksStrQuery != null;
    }

    public Timestamp getUpdateDate(ResultSet incomingData) throws SQLException {
        return incomingData.getTimestamp(this.updateDateIndexInSelectQuery + 1);
    }

    public Timestamp getUpdateDate(Object[] incomingData) throws SQLException {
        return (Timestamp)incomingData[this.updateDateIndexInSelectQuery];
    }

    public void addUniqueConstraint(String indexName, List<String> columnNames, DuplicateKeyStrategy duplicateKeyStrategy) {
        Preconditions.checkNotNull((Object)indexName);
        Preconditions.checkArgument((!this.uniqueConstraints.containsKey(indexName) ? 1 : 0) != 0, (Object)"Duplicate unique constraints name");
        Preconditions.checkNotNull((Object)CollectionUtils.isNotEmpty(columnNames));
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("[%s] Add unique constraint: %s", this.getName(), indexName));
        }
        ArrayList columnNamesLowerCase = Lists.newArrayListWithCapacity((int)columnNames.size());
        for (String columnName : columnNames) {
            columnNamesLowerCase.add(columnName.toLowerCase());
        }
        this.uniqueConstraints.put(indexName, columnNamesLowerCase);
        this.duplicateKeyStrategies.put(indexName, duplicateKeyStrategy);
        this.hasUniqueConstraints = true;
    }

    public void putUniqueConstraint(String indexName, List<String> columnNames, DuplicateKeyStrategy duplicateKeyStrategy) {
        Preconditions.checkNotNull((Object)indexName);
        Preconditions.checkNotNull((Object)CollectionUtils.isNotEmpty(columnNames));
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("[%s] Add unique constraint: %s", this.getName(), indexName));
        }
        ArrayList columnNamesLowerCase = Lists.newArrayListWithCapacity((int)columnNames.size());
        for (String columnName : columnNames) {
            columnNamesLowerCase.add(columnName.toLowerCase());
        }
        this.uniqueConstraints.put(indexName, columnNamesLowerCase);
        this.duplicateKeyStrategies.put(indexName, duplicateKeyStrategy);
        this.hasUniqueConstraints = true;
    }

    public Map<String, List<String>> getUniqueConstraints() {
        this.checkBuild();
        return this.uniqueConstraints;
    }

    public boolean hasUniqueConstraint(String constraintName) {
        return this.uniqueConstraints.containsKey(constraintName);
    }

    public boolean hasUniqueConstraints() {
        return this.hasUniqueConstraints;
    }

    public boolean hasUniqueConstraints(DuplicateKeyStrategy filter) {
        Preconditions.checkNotNull((Object)((Object)filter));
        for (DuplicateKeyStrategy indexStrategy : this.duplicateKeyStrategies.values()) {
            if (!filter.equals((Object)indexStrategy)) continue;
            return true;
        }
        return false;
    }

    public void removeUniqueConstraints(String indexName) {
        this.checkBuild();
        this.uniqueConstraints.remove(indexName);
        this.duplicateKeyStrategies.remove(indexName);
    }

    public Map<String, DuplicateKeyStrategy> getDuplicatKeyStrategies() {
        this.checkBuild();
        return this.duplicateKeyStrategies;
    }

    public String getSelectPkByIndex(String indexName) {
        this.checkBuild();
        return MapUtils.getString(this.selectPksByIndexQueries, (Object)indexName);
    }

    public Map<String, String> getCountPkReferenceQueries(DatabaseMetaData dbMeta) throws SQLException {
        this.checkBuild();
        Preconditions.checkNotNull((Object)dbMeta);
        if (CollectionUtils.isEmpty(this.pkNames)) {
            return null;
        }
        Map<String, String> result = this.pkNames.size() == 1 ? this.getCountPkReferenceQueriesUniquePk(dbMeta) : this.getCountPkReferenceQueriesCompositePk(dbMeta);
        return result;
    }

    protected Map<String, SynchroColumnMetadata> initColumns(Dialect dialect, String tableName, Predicate<SynchroColumnMetadata> columnFilter) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Map<String, ColumnMetadata> delegateColumns = SynchroTableMetadata.getColumns(this.delegate);
        HashMap columns = Maps.newHashMap();
        for (String columnName : delegateColumns.keySet()) {
            ColumnMetadata delegateColumn = delegateColumns.get(columnName);
            SynchroColumnMetadata column = new SynchroColumnMetadata(tableName, delegateColumn, dialect);
            boolean skipColumn = columnFilter != null && !columnFilter.apply((Object)column);
            if (skipColumn) continue;
            columns.put(columnName, column);
        }
        return columns;
    }

    protected List<String> initColumnNames(Map<String, SynchroColumnMetadata> columns) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)columns.size());
        for (String name : columns.keySet()) {
            result.add(name.toLowerCase());
        }
        return result;
    }

    protected List<String> initColumnNamesFromQuery(String aQuery) {
        return SynchroQueryBuilder.newBuilder(aQuery).getColumnNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> initPrimaryKeys(SynchroDatabaseMetadata dbMeta) throws SQLException {
        Set<Object> result = Sets.newLinkedHashSet();
        ResultSet rs = dbMeta.getPrimaryKeys(this.getCatalog(), this.getSchema(), this.getName());
        try {
            while (rs.next()) {
                result.add(rs.getString("COLUMN_NAME").toLowerCase());
            }
            result = this.fireOnPkLoad(result);
            ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)result);
            return immutableSet;
        }
        finally {
            Daos.closeSilently(rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initUniqueConstraints(SynchroDatabaseMetadata dbMeta) throws SQLException {
        Preconditions.checkNotNull(this.uniqueConstraints);
        ResultSet rs = null;
        try {
            rs = dbMeta.getIndexInfo(this.getCatalog(), this.getSchema(), this.getName(), true, true);
            ArrayList columnNames = Lists.newArrayList();
            String lastIndexName = null;
            while (rs.next()) {
                String indexName = rs.getString("INDEX_NAME");
                if (indexName == null) continue;
                indexName = indexName.toLowerCase();
                if (lastIndexName != null && !indexName.equals(lastIndexName)) {
                    this.addUniqueConstraintsIfNotPK(indexName, columnNames, DuplicateKeyStrategy.REJECT);
                    lastIndexName = indexName;
                    columnNames = Lists.newArrayList();
                }
                String columName = rs.getString("COLUMN_NAME").toLowerCase();
                columnNames.add(columName);
            }
            if (lastIndexName != null) {
                this.addUniqueConstraintsIfNotPK(lastIndexName, columnNames, DuplicateKeyStrategy.REJECT);
            }
        }
        catch (Throwable throwable) {
            Daos.closeSilently(rs);
            throw throwable;
        }
        Daos.closeSilently(rs);
    }

    protected List<SynchroInterceptor> initInterceptors(List<Object> listeners) {
        ArrayList result = Lists.newArrayList();
        if (listeners != null) {
            for (Object listener : listeners) {
                if (!(listener instanceof SynchroInterceptor)) continue;
                result.add((SynchroInterceptor)listener);
            }
        }
        return result;
    }

    protected int[] createSelectPkIndex(List<String> selectColumnNames) {
        int[] result = new int[this.pkNames.size()];
        int pkI = 0;
        for (String pkName : this.pkNames) {
            String pkColumnName = pkName.toLowerCase();
            int i = 1;
            int index = -1;
            for (String columnName : selectColumnNames) {
                if (pkColumnName.equals(columnName)) {
                    index = i;
                    continue;
                }
                ++i;
            }
            result[pkI++] = index;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SynchroJoinMetadata> initJoins(String catalog, String schema, String tableName, SynchroDatabaseMetadata dbMeta, Map<String, SynchroColumnMetadata> columns) throws SQLException {
        SynchroJoinMetadata join;
        String columnName;
        ArrayList result = Lists.newArrayList();
        ResultSet rs = null;
        try {
            rs = dbMeta.getExportedKeys(catalog, schema, tableName);
            while (rs.next()) {
                columnName = rs.getString("PKCOLUMN_NAME").toLowerCase();
                if (!columns.containsKey(columnName)) continue;
                join = new SynchroJoinMetadata(rs, this, dbMeta);
                this.fireOnJoinLoad(join);
                if (!join.isValid()) continue;
                result.add(join);
            }
        }
        catch (Throwable throwable) {
            Daos.closeSilently(rs);
            throw throwable;
        }
        Daos.closeSilently(rs);
        try {
            rs = dbMeta.getImportedKeys(catalog, schema, tableName);
            while (rs.next()) {
                columnName = rs.getString("FKCOLUMN_NAME").toLowerCase();
                if (!columns.containsKey(columnName)) continue;
                join = new SynchroJoinMetadata(rs, this, dbMeta);
                this.fireOnJoinLoad(join);
                if (!join.isValid()) continue;
                result.add(join);
                SynchroColumnMetadata column = columns.get(columnName);
                column.setParentJoin(join);
            }
        }
        finally {
            Daos.closeSilently(rs);
        }
        return result;
    }

    protected List<SynchroJoinMetadata> initChildJoins(List<SynchroJoinMetadata> joins) throws SQLException {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)joins.size());
        for (SynchroJoinMetadata join : joins) {
            if (!join.isChild()) continue;
            result.add(join);
        }
        return result;
    }

    protected List<SynchroJoinMetadata> initParentJoins(List<SynchroJoinMetadata> joins) throws SQLException {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)joins.size());
        for (SynchroJoinMetadata join : joins) {
            if (join.isChild()) continue;
            result.add(join);
        }
        return result;
    }

    protected String createInsertQuery() {
        if (CollectionUtils.isEmpty(this.columnNames)) {
            return null;
        }
        StringBuilder queryParams = new StringBuilder();
        StringBuilder valueParams = new StringBuilder();
        for (String columnName : this.columnNames) {
            queryParams.append(", ").append(columnName);
            valueParams.append(", ?");
        }
        String sql = String.format("INSERT INTO %s (%s) VALUES (%s)", this.getName(), queryParams.substring(2), valueParams.substring(2));
        return this.fireOnCreateQuery(SynchroQueryName.insert, sql);
    }

    protected String createUpdateQuery() {
        if (CollectionUtils.isEmpty(this.pkNames)) {
            return null;
        }
        if (CollectionUtils.isEmpty(this.columnNames)) {
            return null;
        }
        StringBuilder updateParams = new StringBuilder();
        for (String columnName : this.columnNames) {
            updateParams.append(", ").append(columnName);
            updateParams.append(" = ?");
        }
        String sql = String.format("UPDATE %s SET %s WHERE %s", this.getName(), updateParams.substring(2), this.createPkWhereClause());
        return this.fireOnCreateQuery(SynchroQueryName.update, sql);
    }

    protected String createDeleteByPk() {
        String sql = String.format("DELETE FROM %s WHERE %s", this.getName(), this.createPkWhereClause());
        return this.fireOnCreateQuery(SynchroQueryName.deleteByPk, sql);
    }

    protected String createSelectByPkQuery() {
        if (CollectionUtils.isEmpty(this.pkNames)) {
            return null;
        }
        String sql = String.format("SELECT %s FROM %s t WHERE %s", this.createSelectParams("t"), this.getName(), this.createPkWhereClause("t"));
        return this.fireOnCreateQuery(SynchroQueryName.selectByPk, sql);
    }

    protected String createSelectPksStrQuery(SynchroDatabaseConfiguration config) {
        if (CollectionUtils.isEmpty(this.pkNames)) {
            return null;
        }
        String prefix = " || '~~' || ";
        StringBuilder pkParams = new StringBuilder();
        boolean allowUniqueOutputColumn = true;
        for (String columnName : this.pkNames) {
            SynchroColumnMetadata column = this.columns.get(columnName);
            if (column.getTypeCode() == 93 || column.getTypeCode() == 91) {
                allowUniqueOutputColumn = false;
            }
            pkParams.append(prefix).append("t.").append(columnName);
        }
        if (!allowUniqueOutputColumn) {
            return null;
        }
        if (this.withUpdateDateColumn) {
            pkParams.append(", ").append(config.getColumnUpdateDate());
        }
        String sql = String.format("SELECT %s FROM %s t", pkParams.substring(prefix.length()), this.getName());
        return this.fireOnCreateQuery(SynchroQueryName.selectPksStr, sql);
    }

    protected String createSelectPksQuery(SynchroDatabaseConfiguration config) {
        if (CollectionUtils.isEmpty(this.pkNames)) {
            return null;
        }
        StringBuilder pkParams = new StringBuilder();
        for (String columnName : this.pkNames) {
            pkParams.append(", t.").append(columnName);
        }
        if (this.withUpdateDateColumn) {
            pkParams.append(", t.").append(config.getColumnUpdateDate());
        }
        String sql = String.format("SELECT %s FROM %s t", pkParams.substring(2), this.getName());
        return this.fireOnCreateQuery(SynchroQueryName.selectPks, sql);
    }

    protected Map<String, String> createSelectPksByIndexQueries(SynchroDatabaseConfiguration config) {
        if (MapUtils.isEmpty(this.uniqueConstraints)) {
            return null;
        }
        if (CollectionUtils.isEmpty(this.pkNames)) {
            return null;
        }
        HashMap result = Maps.newHashMap();
        StringBuilder pkParams = new StringBuilder();
        for (String string : this.pkNames) {
            pkParams.append(", t.").append(string);
        }
        if (this.withUpdateDateColumn) {
            pkParams.append(", t.").append(config.getColumnUpdateDate());
        }
        for (Map.Entry entry : this.uniqueConstraints.entrySet()) {
            StringBuilder whereParams = new StringBuilder();
            for (String columnName : (List)entry.getValue()) {
                boolean isNullable = this.getColumn(columnName).isNullable();
                if (isNullable) {
                    whereParams.append(String.format(" AND (t.%s = ? OR (? is null and t.%s is null))", columnName, columnName));
                    continue;
                }
                whereParams.append(" AND t.").append(columnName).append(" = ?");
            }
            String sql = String.format("SELECT %s FROM %s t WHERE %s", pkParams.substring(2), this.getName(), whereParams.substring(5));
            if (!StringUtils.isNotBlank((CharSequence)(sql = this.fireOnCreateQuery(SynchroQueryName.selectPksByIndex, sql)))) continue;
            result.put(entry.getKey(), sql);
        }
        return result;
    }

    protected String createSelectAllQuery() {
        String sql = String.format("SELECT %s FROM %s t", this.createSelectParams("t"), this.getName());
        return this.fireOnCreateQuery(SynchroQueryName.select, sql);
    }

    protected String createSelectMaxUpdateDateQuery(SynchroDatabaseConfiguration config) {
        if (!this.withUpdateDateColumn) {
            return null;
        }
        String sql = String.format("SELECT max(t.%s) FROM %s t", config.getColumnUpdateDate(), this.getName());
        return this.fireOnCreateQuery(SynchroQueryName.selectMaxUpdateDate, sql);
    }

    protected String createSelectUpdateDateByPkQuery(SynchroDatabaseConfiguration config) {
        if (!this.withUpdateDateColumn) {
            return null;
        }
        String sql = String.format("SELECT t.%s FROM %s t WHERE %s", config.getColumnUpdateDate(), this.getName(), this.createPkWhereClause("t"));
        return this.fireOnCreateQuery(SynchroQueryName.selectUpdateDateByPk, sql);
    }

    protected String createSelectFromUpdateDateQuery(SynchroDatabaseConfiguration config) {
        if (!this.withUpdateDateColumn) {
            return null;
        }
        String sql = String.format("SELECT %s FROM %s t%s", this.createSelectParams("t"), this.getName(), this.createWithUpdateDateWhereClause(config, "t"));
        return this.fireOnCreateQuery(SynchroQueryName.selectFromUpdateDate, sql);
    }

    protected String createAllCountQuery() {
        String sql = String.format("SELECT count(*) FROM %s t", this.getName());
        return sql;
    }

    protected String createCountQuery() {
        String sql = String.format("SELECT count(*) FROM %s t", this.getName());
        return this.fireOnCreateQuery(SynchroQueryName.count, sql);
    }

    protected String createCountFromUpdateDate(SynchroDatabaseConfiguration config) {
        String sql = String.format("SELECT count(*) FROM %s t%s", this.getName(), this.createWithUpdateDateWhereClause(config, "t"));
        return this.fireOnCreateQuery(SynchroQueryName.countFromUpdateDate, sql);
    }

    public String createPkWhereClause() {
        return this.createPkWhereClause(null);
    }

    public String createPkWhereClause(String tableAlias) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.pkNames));
        StringBuilder pkParams = new StringBuilder();
        String prefix = tableAlias != null ? tableAlias + "." : "";
        for (String columnName : this.pkNames) {
            pkParams.append(" AND ").append(prefix).append(columnName).append(" = ?");
        }
        return pkParams.substring(5);
    }

    protected String createWithUpdateDateWhereClause(SynchroDatabaseConfiguration config) {
        return this.createWithUpdateDateWhereClause(config, null);
    }

    protected String createWithUpdateDateWhereClause(SynchroDatabaseConfiguration config, String tableAlias) {
        String whereClause;
        if (this.isWithUpdateDateColumn()) {
            String columnUpdateDate = config.getColumnUpdateDate();
            String prefix = tableAlias != null ? tableAlias + "." : "";
            whereClause = String.format(" WHERE (%s%s IS NULL OR %s%s > :%s)", prefix, columnUpdateDate, prefix, columnUpdateDate, UPDATE_DATE_BINDPARAM);
        } else {
            whereClause = "";
        }
        return whereClause;
    }

    protected String createSelectParams() {
        return this.createSelectParams(null);
    }

    protected String createSelectParams(String tableAlias) {
        return this.createSelectParams(this.columnNames, tableAlias);
    }

    protected String createSelectParams(List<String> columnNames, String tableAlias) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(columnNames), (Object)String.format("No column found for table: %s", this.delegate.getName()));
        StringBuilder queryParams = new StringBuilder();
        for (String columnName : columnNames) {
            queryParams.append(", ");
            if (tableAlias != null) {
                queryParams.append(tableAlias).append(".");
            }
            queryParams.append(columnName);
        }
        return queryParams.substring(2);
    }

    protected String initSequenceName(SynchroDatabaseMetadata dbMeta) {
        String sequenceName;
        Set<String> availableSequences = dbMeta.getSequences();
        SynchroDatabaseConfiguration config = dbMeta.getConfiguration();
        String sequenceSuffix = config.getSequenceSuffix();
        int maxSqlNameLength = config.getMaxSqlNameLength();
        String tableName = this.getName().toLowerCase();
        int maxLength = maxSqlNameLength - sequenceSuffix.length();
        if (maxLength > 0 && availableSequences.contains((sequenceName = SynchroMetadataUtils.ensureMaximumNameLength(tableName, maxLength) + sequenceSuffix).toLowerCase())) {
            return sequenceName;
        }
        sequenceName = tableName + sequenceSuffix;
        if (availableSequences.contains(sequenceName.toLowerCase())) {
            return sequenceName;
        }
        return null;
    }

    protected String createSelectSequenceNextValString(Dialect dialect, String sequenceName) {
        if (StringUtils.isBlank((CharSequence)sequenceName)) {
            return null;
        }
        return dialect.getSelectSequenceNextValString(sequenceName);
    }

    protected String createSequenceNextValString(Dialect dialect, String sequenceName) {
        if (StringUtils.isBlank((CharSequence)sequenceName)) {
            return null;
        }
        return dialect.getSequenceNextValString(sequenceName);
    }

    protected String fireOnCreateQuery(SynchroQueryName queryName, String sql) {
        if (this.eventBus == null) {
            return sql;
        }
        CreateQueryEvent e = new CreateQueryEvent(this, queryName, sql);
        this.eventBus.post((Object)e);
        return e.sql;
    }

    protected SynchroJoinMetadata fireOnJoinLoad(SynchroJoinMetadata join) {
        if (this.eventBus == null || !join.isValid()) {
            return join;
        }
        LoadJoinEvent e = new LoadJoinEvent(this, join);
        this.eventBus.post((Object)e);
        return e.join;
    }

    protected Set<String> fireOnPkLoad(Set<String> pk) {
        if (this.eventBus == null) {
            return pk;
        }
        LoadPkEvent e = new LoadPkEvent(this, pk);
        this.eventBus.post((Object)e);
        return e.pk;
    }

    public SynchroTableMetadata build() {
        if (this.isBuild) {
            return this;
        }
        if (this.eventBus != null) {
            LoadTableEvent e = new LoadTableEvent(this.dbMeta, this);
            this.eventBus.post((Object)e);
        }
        try {
            this.selectPksByIndexQueries = this.createSelectPksByIndexQueries(this.dbMeta.getConfiguration());
            this.selectSequenceNextValString = this.createSelectSequenceNextValString(this.dialect, this.sequenceName);
            this.sequenceNextValString = this.createSequenceNextValString(this.dialect, this.sequenceName);
        }
        catch (Exception e) {
            throw new SynchroTechnicalException(I18n.t((String)"adagio.synchro.meta.table.instanciation.error", (Object[])new Object[]{this.delegate.getName()}), e);
        }
        this.eventBus = null;
        this.dbMeta = null;
        this.dialect = null;
        if (log.isTraceEnabled()) {
            this.logQueriesMappings();
        }
        this.isBuild = true;
        return this;
    }

    public void logQueriesMappings() {
        if (this.selectAllQuery == null || !log.isDebugEnabled()) {
            return;
        }
        List<String> selectColumnNames = SynchroQueryBuilder.newBuilder(this.selectAllQuery).getColumnNames();
        SynchroQueryBuilder insertQuery = SynchroQueryBuilder.newBuilder(this.insertQuery);
        SynchroQueryBuilder updateQuery = SynchroQueryBuilder.newBuilder(this.updateQuery);
        ArrayList insertBindColumnNames = Lists.newArrayList();
        for (String string : insertQuery.getColumnNames()) {
            if (!"?".equals(insertQuery.getColumnValue(string))) continue;
            insertBindColumnNames.add(string);
        }
        ArrayList updateBindColumnNames = Lists.newArrayList();
        for (String columnName : updateQuery.getColumnNames()) {
            if (!"?".equals(updateQuery.getColumnValue(columnName))) continue;
            updateBindColumnNames.add(columnName);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("[%s] Insert mapping:", this.getName()));
        StringBuilder updateBuffer = new StringBuilder();
        updateBuffer.append(String.format("[%s] Update mapping:", this.getName()));
        int i = 0;
        int j = 0;
        for (String selectColumnName : selectColumnNames) {
            String insertColumnName = "N/A";
            if (i < insertBindColumnNames.size()) {
                insertColumnName = (String)insertBindColumnNames.get(i++);
            }
            String updateColumnName = "N/A";
            if (j < updateBindColumnNames.size()) {
                updateColumnName = (String)updateBindColumnNames.get(j++);
            }
            stringBuilder.append("\n\t").append(selectColumnName).append(" -> ").append(insertColumnName);
            updateBuffer.append("\n\t").append(selectColumnName).append(" -> ").append(updateColumnName);
        }
        if (insertBindColumnNames.size() > i) {
            for (int k = i; k < insertBindColumnNames.size(); ++k) {
                stringBuilder.append("\n\tN/A  -> ").append((String)insertBindColumnNames.get(k));
            }
        }
        if (updateBindColumnNames.size() > j) {
            for (int k = j; k < updateBindColumnNames.size(); ++k) {
                updateBuffer.append("\n\tN/A  -> ").append((String)updateBindColumnNames.get(k));
            }
        }
        log.trace((Object)stringBuilder.toString());
        log.trace((Object)updateBuffer.toString());
    }

    protected EventBus initEventBus(boolean enableEvent, List<Object> listeners, String tableName) {
        if (CollectionUtils.isEmpty(listeners) || !enableEvent) {
            return null;
        }
        EventBus eventBus = new EventBus(new SubscriberExceptionHandler(){

            public void handleException(Throwable exception, SubscriberExceptionContext context) {
                throw new SynchroTechnicalException(exception);
            }
        });
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("[%s] Active listeners: ", tableName));
        }
        for (Object listener : listeners) {
            eventBus.register(listener);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)String.format("[%s]  - %s", tableName, listener.getClass().getName()));
        }
        return eventBus;
    }

    protected void addUniqueConstraintsIfNotPK(String indexName, List<String> columnNames, DuplicateKeyStrategy duplicateKeyStrategy) {
        Preconditions.checkArgument((!this.uniqueConstraints.containsKey(indexName) ? 1 : 0) != 0, (Object)"Duplicate unique constraints name");
        Preconditions.checkNotNull((Object)CollectionUtils.isNotEmpty(columnNames));
        if (CollectionUtils.isEqualCollection(this.pkNames, columnNames)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("[%s] Add unique constraint: %s", this.getName(), indexName));
        }
        this.uniqueConstraints.put(indexName, columnNames);
        this.duplicateKeyStrategies.put(indexName, duplicateKeyStrategy);
        this.hasUniqueConstraints = true;
    }

    protected void checkBuild() {
        Preconditions.checkState((boolean)this.isBuild, (Object)"table not build. Please call build() first.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> getCountPkReferenceQueriesUniquePk(DatabaseMetaData dbMeta) throws SQLException {
        String pkColumnName = this.pkNames.iterator().next();
        ArrayListMultimap columnMappingsByTable = ArrayListMultimap.create();
        ResultSet rs = null;
        try {
            rs = dbMeta.getExportedKeys(this.getCatalog(), this.getSchema(), this.getName());
            while (rs.next()) {
                String columnName = rs.getString("PKCOLUMN_NAME").toLowerCase();
                if (!pkColumnName.equals(columnName)) continue;
                String fkTableName = rs.getString("FKTABLE_NAME").toUpperCase();
                String fkColumnName = rs.getString("FKCOLUMN_NAME").toLowerCase();
                columnMappingsByTable.put((Object)fkTableName, (Object)new String[]{columnName, fkColumnName});
            }
        }
        catch (Throwable throwable) {
            Daos.closeSilently(rs);
            throw throwable;
        }
        Daos.closeSilently(rs);
        if (columnMappingsByTable.isEmpty()) {
            return null;
        }
        HashMap result = Maps.newHashMap();
        for (String fkTableName : columnMappingsByTable.keySet()) {
            StringBuilder whereClause = new StringBuilder();
            Collection columnMappings = columnMappingsByTable.get((Object)fkTableName);
            for (String[] columnMapping : columnMappings) {
                String fkColumnName = columnMapping[1];
                whereClause.append(" OR ").append(fkColumnName).append("=:pk1");
            }
            String sql = String.format("select count(*) from %s where %s", fkTableName, whereClause.substring(4));
            result.put(fkTableName, sql);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> getCountPkReferenceQueriesCompositePk(DatabaseMetaData dbMeta) throws SQLException {
        Set<String> pkColumnNames = this.getPkNames();
        ArrayListMultimap columnMappingsByTable = ArrayListMultimap.create();
        ResultSet rs = null;
        try {
            rs = dbMeta.getExportedKeys(this.getCatalog(), this.getSchema(), this.getName());
            while (rs.next()) {
                String columnName = rs.getString("PKCOLUMN_NAME").toLowerCase();
                if (!pkColumnNames.contains(columnName)) continue;
                String fkTableName = rs.getString("FKTABLE_NAME").toUpperCase();
                String fkColumnName = rs.getString("FKCOLUMN_NAME").toLowerCase();
                columnMappingsByTable.put((Object)fkTableName, (Object)new String[]{columnName, fkColumnName});
            }
        }
        catch (Throwable throwable) {
            Daos.closeSilently(rs);
            throw throwable;
        }
        Daos.closeSilently(rs);
        if (columnMappingsByTable.isEmpty()) {
            return null;
        }
        HashMap result = Maps.newHashMap();
        for (String fkTableName : columnMappingsByTable.keySet()) {
            StringBuilder whereClause = new StringBuilder();
            Collection columnMappings = columnMappingsByTable.get((Object)fkTableName);
            int pkIndex = 1;
            for (String pkColumnName : pkColumnNames) {
                String pkParamName = ":pk" + pkIndex;
                for (String[] columnMapping : columnMappings) {
                    if (columnMapping[0].equals(pkColumnName)) {
                        String fkColumnName = columnMapping[1];
                        whereClause.append(" AND ").append(fkColumnName).append("=").append(pkParamName);
                        continue;
                    }
                    whereClause.append(" AND ").append(pkParamName).append(" is not null");
                }
                ++pkIndex;
            }
            String sql = String.format("select count(*) from %s where %s", fkTableName, whereClause.substring(5));
            result.put(fkTableName, sql);
        }
        return result;
    }

    public static enum DuplicateKeyStrategy {
        REPLACE,
        REJECT,
        WARN;

    }
}

