/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol.zones.tree;

import fr.ifremer.tutti.persistence.entities.protocol.Zone;
import fr.ifremer.tutti.ui.swing.content.protocol.zones.tree.ZoneEditorTreeModelSupport;
import fr.ifremer.tutti.ui.swing.content.protocol.zones.tree.node.StrataNode;
import fr.ifremer.tutti.ui.swing.content.protocol.zones.tree.node.ZoneNode;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.tree.TreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ZonesTreeModel
extends ZoneEditorTreeModelSupport {
    private static final Log log = LogFactory.getLog(ZonesTreeModel.class);

    public ZonesTreeModel() {
        super(I18n.t((String)"tutti.zoneEditor.zones.root.label", (Object[])new Object[0]));
    }

    public ZoneNode addZone(Zone zone) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Add zone: " + zone));
        }
        ZoneNode zoneNode = new ZoneNode(zone.getId(), zone.getLabel());
        this.addNode(this.getRoot(), zoneNode);
        zone.getStrata().forEach(strata -> {
            StrataNode strataNode = this.addStrata(zoneNode, strata.getId());
            strata.getSubstrata().forEach(subStrata -> this.addSubsStrata(strataNode, subStrata.getId()));
        });
        return zoneNode;
    }

    public Set<Zone> getZones() {
        LinkedHashSet<Zone> zones = new LinkedHashSet<Zone>();
        Enumeration<TreeNode> zoneNodes = this.getRoot().children();
        while (zoneNodes.hasMoreElements()) {
            TreeNode zoneNode = zoneNodes.nextElement();
            zones.add(((ZoneNode)zoneNode).toBean());
        }
        return zones;
    }
}

